/*
 * Decompiled with CFR 0.152.
 */
package blockcanary.ui;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import blockcanary.ui.NotificationType;
import blockcanary.ui.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lblockcanary/ui/Notifications;", "", "()V", "canShowNotification", "", "getCanShowNotification", "()Z", "setCanShowNotification", "(Z)V", "buildNotification", "Landroid/app/Notification;", "context", "Landroid/content/Context;", "builder", "Landroid/app/Notification$Builder;", "type", "Lblockcanary/ui/NotificationType;", "showNotification", "", "contentTitle", "", "contentText", "pendingIntent", "Landroid/app/PendingIntent;", "notificationId", "", "blockcanary-ui_release"})
public final class Notifications {
    private static boolean canShowNotification;
    public static final Notifications INSTANCE;

    public final boolean getCanShowNotification() {
        return canShowNotification;
    }

    public final void setCanShowNotification(boolean bl) {
        canShowNotification = bl;
    }

    public final void showNotification(@NotNull Context context, @NotNull CharSequence contentTitle, @NotNull CharSequence contentText, @Nullable PendingIntent pendingIntent, int notificationId, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contentTitle, (String)"contentTitle");
        Intrinsics.checkNotNullParameter((Object)contentText, (String)"contentText");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!canShowNotification) {
            return;
        }
        Notification.Builder builder = Build.VERSION.SDK_INT >= 26 ? new Notification.Builder(context, type.name()) : new Notification.Builder(context);
        builder.setContentText(contentText).setContentTitle(contentTitle).setAutoCancel(true).setContentIntent(pendingIntent);
        Notification notification = this.buildNotification(context, builder, type);
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        notificationManager.notify(notificationId, notification);
    }

    @NotNull
    public final Notification buildNotification(@NotNull Context context, @NotNull Notification.Builder builder, @NotNull NotificationType type) {
        Notification notification;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        builder.setWhen(System.currentTimeMillis());
        builder.setSmallIcon(R.drawable.block_canary);
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context.getSystemService("notification");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
            }
            NotificationManager notificationManager = (NotificationManager)object;
            NotificationChannel notificationChannel = notificationManager.getNotificationChannel(type.name());
            if (notificationChannel == null) {
                String string2 = context.getString(type.getNameResId());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(type.nameResId)");
                String channelName = string2;
                notificationChannel = new NotificationChannel(type.name(), (CharSequence)channelName, type.getImportance());
                notificationManager.createNotificationChannel(notificationChannel);
            }
            builder.setChannelId(type.name());
            builder.setGroup(type.name());
        }
        if (Build.VERSION.SDK_INT < 16) {
            Notification notification2 = builder.getNotification();
            notification = notification2;
            Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"builder.notification");
        } else {
            Notification notification3 = builder.build();
            notification = notification3;
            Intrinsics.checkNotNullExpressionValue((Object)notification3, (String)"builder.build()");
        }
        return notification;
    }

    private Notifications() {
    }

    static {
        Notifications notifications;
        INSTANCE = notifications = new Notifications();
        canShowNotification = true;
    }
}

