/*
 * Decompiled with CFR 0.152.
 */
package blockcanary;

public class BlockCanaryConfig {
    private int blockThresholdTime;
    private int blockMaxThresholdTime;
    private int stackSampleInterval;
    private int maxStackSampleCacheCount;
    private int maxCacheBlockingFiles;
    private boolean detectWhenDebuggerConnected;

    private BlockCanaryConfig(Builder builder) {
        this.setBlockThresholdTime(builder.blockThresholdTime);
        this.setBlockMaxThresholdTime(builder.blockMaxThresholdTime);
        this.setStackSampleInterval(builder.stackSampleInterval);
        this.setMaxStackSampleCacheCount(builder.maxStackSampleCacheCount);
        this.setMaxCacheBlockingFiles(builder.maxCacheBlockingFiles);
        this.setDetectWhenDebuggerConnected(builder.detectWhenDebuggerConnected);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(BlockCanaryConfig copy) {
        Builder builder = new Builder();
        builder.blockThresholdTime = copy.getBlockThresholdTime();
        builder.blockMaxThresholdTime = copy.getBlockMaxThresholdTime();
        builder.stackSampleInterval = copy.getStackSampleInterval();
        builder.maxStackSampleCacheCount = copy.getMaxStackSampleCacheCount();
        builder.maxCacheBlockingFiles = copy.getMaxCacheBlockingFiles();
        builder.detectWhenDebuggerConnected = copy.isDetectWhenDebuggerConnected();
        return builder;
    }

    public int getBlockThresholdTime() {
        return this.blockThresholdTime;
    }

    public void setBlockThresholdTime(int blockThresholdTime) {
        this.blockThresholdTime = blockThresholdTime;
    }

    public int getBlockMaxThresholdTime() {
        return this.blockMaxThresholdTime;
    }

    public void setBlockMaxThresholdTime(int blockMaxThresholdTime) {
        this.blockMaxThresholdTime = blockMaxThresholdTime;
    }

    public int getStackSampleInterval() {
        return this.stackSampleInterval;
    }

    public void setStackSampleInterval(int stackSampleInterval) {
        this.stackSampleInterval = stackSampleInterval;
    }

    public int getMaxStackSampleCacheCount() {
        return this.maxStackSampleCacheCount;
    }

    public void setMaxStackSampleCacheCount(int maxStackSampleCacheCount) {
        this.maxStackSampleCacheCount = maxStackSampleCacheCount;
    }

    public int getMaxCacheBlockingFiles() {
        return this.maxCacheBlockingFiles;
    }

    public void setMaxCacheBlockingFiles(int maxCacheBlockingFiles) {
        this.maxCacheBlockingFiles = maxCacheBlockingFiles;
    }

    public boolean isDetectWhenDebuggerConnected() {
        return this.detectWhenDebuggerConnected;
    }

    public void setDetectWhenDebuggerConnected(boolean detectWhenDebuggerConnected) {
        this.detectWhenDebuggerConnected = detectWhenDebuggerConnected;
    }

    public static final class Builder {
        private int blockThresholdTime = 240;
        private int blockMaxThresholdTime = 5000;
        private int stackSampleInterval = 50;
        private int maxStackSampleCacheCount = 110;
        private int maxCacheBlockingFiles = 50;
        private boolean detectWhenDebuggerConnected = false;

        private Builder() {
        }

        public Builder blockThresholdTime(int val) {
            this.blockThresholdTime = val;
            return this;
        }

        public Builder blockMaxThresholdTime(int val) {
            this.blockMaxThresholdTime = val;
            return this;
        }

        public Builder stackSampleInterval(int val) {
            this.stackSampleInterval = val;
            return this;
        }

        public Builder maxStackSampleCacheCount(int val) {
            this.maxStackSampleCacheCount = val;
            return this;
        }

        public Builder maxCacheBlockingFiles(int val) {
            this.maxCacheBlockingFiles = val;
            return this;
        }

        public Builder detectWhenDebuggerConnected(boolean val) {
            this.detectWhenDebuggerConnected = val;
            return this;
        }

        public BlockCanaryConfig build() {
            return new BlockCanaryConfig(this);
        }
    }
}

