/*
 * Decompiled with CFR 0.152.
 */
package blockcanary;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import blockcanary.BlockCanaryConfig;
import blockcanary.BlockCanaryInternal;
import blockcanary.BlockDetectListener;
import blockcanary.BlockInfo;
import blockcanary.CanaryExecutors;
import blockcanary.LooperMonitor;
import blockcanary.db.BlockInfoRepository;
import blockcanary.db.BlockInfoRepositoryImpl;
import com.knightboost.stacksampler.StackSampler;
import com.knightboost.stacksampler.StackTraceSample;
import com.knightboost.stacksampler.util.FastTimer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f*\u0001%\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001:B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0011J\b\u00101\u001a\u00020/H\u0002J\u0016\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0007J\u0010\u00105\u001a\u00020/2\u0006\u00106\u001a\u00020\u0019H\u0002J\u000e\u00107\u001a\u00020/2\u0006\u00100\u001a\u00020\u0011J\u0006\u00108\u001a\u00020/J\u0006\u00109\u001a\u00020/R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u0010\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R\u001b\u0010'\u001a\u00020(8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010#\u001a\u0004\b)\u0010*R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lblockcanary/BlockCanaryInternal;", "", "()V", "_application", "Landroid/app/Application;", "get_application$annotations", "_blockCanaryConfig", "Lblockcanary/BlockCanaryConfig;", "get_blockCanaryConfig$annotations", "application", "getApplication", "()Landroid/app/Application;", "blockCanaryConfig", "getBlockCanaryConfig", "()Lblockcanary/BlockCanaryConfig;", "blockCanaryListeners", "", "Lblockcanary/BlockDetectListener;", "blockInfoRepository", "Lblockcanary/db/BlockInfoRepository;", "getBlockInfoRepository", "()Lblockcanary/db/BlockInfoRepository;", "setBlockInfoRepository", "(Lblockcanary/db/BlockInfoRepository;)V", "curBlockInfo", "Lblockcanary/BlockInfo;", "getCurBlockInfo", "()Lblockcanary/BlockInfo;", "setCurBlockInfo", "(Lblockcanary/BlockInfo;)V", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "handler$delegate", "Lkotlin/Lazy;", "messageListener", "blockcanary/BlockCanaryInternal$messageListener$1", "Lblockcanary/BlockCanaryInternal$messageListener$1;", "stackSampler", "Lcom/knightboost/stacksampler/StackSampler;", "getStackSampler", "()Lcom/knightboost/stacksampler/StackSampler;", "stackSampler$delegate", "watchDogHandler", "Landroid/os/HandlerThread;", "addBlockDetectListener", "", "blockDetectListener", "initUICore", "install", "app", "config", "onBlockDetect", "blockInfo", "removeBlockDetectListener", "start", "stop", "SlowMessageWatchdog", "blockcanary_release"})
public final class BlockCanaryInternal {
    private static Application _application;
    private static BlockCanaryConfig _blockCanaryConfig;
    @Nullable
    private static BlockInfo curBlockInfo;
    private static final HandlerThread watchDogHandler;
    private static final Lazy handler$delegate;
    @NotNull
    public static BlockInfoRepository blockInfoRepository;
    private static final List<BlockDetectListener> blockCanaryListeners;
    @NotNull
    private static final Lazy stackSampler$delegate;
    private static final messageListener.1 messageListener;
    public static final BlockCanaryInternal INSTANCE;

    private static /* synthetic */ void get_application$annotations() {
    }

    private static /* synthetic */ void get_blockCanaryConfig$annotations() {
    }

    @Nullable
    public final BlockInfo getCurBlockInfo() {
        return curBlockInfo;
    }

    public final void setCurBlockInfo(@Nullable BlockInfo blockInfo) {
        curBlockInfo = blockInfo;
    }

    private final Handler getHandler() {
        Lazy lazy = handler$delegate;
        BlockCanaryInternal blockCanaryInternal = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    @NotNull
    public final BlockInfoRepository getBlockInfoRepository() {
        BlockInfoRepository blockInfoRepository = BlockCanaryInternal.blockInfoRepository;
        if (blockInfoRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blockInfoRepository");
        }
        return blockInfoRepository;
    }

    public final void setBlockInfoRepository(@NotNull BlockInfoRepository blockInfoRepository) {
        Intrinsics.checkNotNullParameter((Object)blockInfoRepository, (String)"<set-?>");
        BlockCanaryInternal.blockInfoRepository = blockInfoRepository;
    }

    @NotNull
    public final StackSampler getStackSampler() {
        Lazy lazy = stackSampler$delegate;
        BlockCanaryInternal blockCanaryInternal = this;
        Object var3_3 = null;
        boolean bl = false;
        return (StackSampler)lazy.getValue();
    }

    @NotNull
    public final Application getApplication() {
        boolean bl = _application != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "BlockCanary not installed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Application application = _application;
        Intrinsics.checkNotNull((Object)application);
        return application;
    }

    @NotNull
    public final BlockCanaryConfig getBlockCanaryConfig() {
        boolean bl = _blockCanaryConfig != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "BlockCanary not installed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BlockCanaryConfig blockCanaryConfig = _blockCanaryConfig;
        Intrinsics.checkNotNull((Object)blockCanaryConfig);
        return blockCanaryConfig;
    }

    public final void install(@NotNull Application app, @NotNull BlockCanaryConfig config) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (_application != null) {
            return;
        }
        _application = app;
        _blockCanaryConfig = config;
        Context context = (Context)this.getApplication();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        blockInfoRepository = new BlockInfoRepositoryImpl(context, executorService, new File(this.getApplication().getCacheDir(), "blockCanary"));
        this.initUICore();
        this.start();
    }

    public final void start() {
        LooperMonitor.ofMainThread().addListener(messageListener);
        this.getStackSampler().startSampling();
    }

    public final void stop() {
        LooperMonitor.ofMainThread().removeListener(messageListener);
        this.getStackSampler().stopSampling();
    }

    public final void addBlockDetectListener(@NotNull BlockDetectListener blockDetectListener) {
        Intrinsics.checkNotNullParameter((Object)blockDetectListener, (String)"blockDetectListener");
        blockCanaryListeners.add(blockDetectListener);
    }

    public final void removeBlockDetectListener(@NotNull BlockDetectListener blockDetectListener) {
        Intrinsics.checkNotNullParameter((Object)blockDetectListener, (String)"blockDetectListener");
        blockCanaryListeners.remove(blockDetectListener);
    }

    private final void onBlockDetect(BlockInfo blockInfo) {
        blockInfo.setSampleInterval(this.getBlockCanaryConfig().getStackSampleInterval());
        CanaryExecutors.INSTANCE.getWorkExecutor().execute(new Runnable(blockInfo){
            final /* synthetic */ BlockInfo $blockInfo;

            public final void run() {
                BlockDetectListener[] listeners;
                long dispatchStartTime = this.$blockInfo.getStartTime();
                List stackSamples = BlockCanaryInternal.INSTANCE.getStackSampler().getStackSamplesBetweenWallTime(dispatchStartTime, this.$blockInfo.getEndTime());
                List<StackTraceSample> list = this.$blockInfo.getStackTraceSamples();
                List list2 = stackSamples;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"stackSamples");
                list.addAll(list2);
                BlockCanaryInternal.INSTANCE.getBlockInfoRepository().insertBlockInfo(this.$blockInfo);
                Collection $this$toTypedArray$iv = BlockCanaryInternal.access$getBlockCanaryListeners$p(BlockCanaryInternal.INSTANCE);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                BlockDetectListener[] blockDetectListenerArray = thisCollection$iv.toArray(new BlockDetectListener[0]);
                if (blockDetectListenerArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                for (BlockDetectListener listener : listeners = blockDetectListenerArray) {
                    listener.onBlockDetected(this.$blockInfo);
                }
            }
            {
                this.$blockInfo = blockInfo;
            }
        });
    }

    private final void initUICore() {
        try {
            Class<?> clazz = Class.forName("blockcanary.ui.BlockCanaryUI");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private BlockCanaryInternal() {
    }

    static {
        BlockCanaryInternal blockCanaryInternal;
        INSTANCE = blockCanaryInternal = new BlockCanaryInternal();
        watchDogHandler = new HandlerThread("block-canary-handler");
        handler$delegate = LazyKt.lazy((Function0)handler.2.INSTANCE);
        boolean bl = false;
        blockCanaryListeners = new ArrayList();
        stackSampler$delegate = LazyKt.lazy((Function0)stackSampler.2.INSTANCE);
        messageListener = new LooperMonitor.MessageDispatchListener(){

            public void onDispatchStart(@Nullable String x) {
                super.onDispatchStart(x);
                BlockInfo messageInfo = new BlockInfo();
                messageInfo.setStartTime(FastTimer.Companion.currentTimeMillis());
                BlockCanaryInternal.INSTANCE.setCurBlockInfo(messageInfo);
                BlockCanaryInternal.access$getHandler$p(BlockCanaryInternal.INSTANCE).postDelayed((Runnable)new SlowMessageWatchdog(messageInfo), (long)BlockCanaryInternal.INSTANCE.getBlockCanaryConfig().getBlockMaxThresholdTime());
            }

            public void onDispatchEnd(@Nullable String x) {
                super.onDispatchEnd(x);
                BlockCanaryInternal.access$getHandler$p(BlockCanaryInternal.INSTANCE).removeCallbacksAndMessages(null);
                BlockInfo blockInfo = BlockCanaryInternal.INSTANCE.getCurBlockInfo();
                if (blockInfo == null) {
                    return;
                }
                BlockInfo messageInfo = blockInfo;
                messageInfo.setEndTime(FastTimer.Companion.currentTimeMillis());
                if (messageInfo.costTime() > (long)BlockCanaryInternal.INSTANCE.getBlockCanaryConfig().getBlockThresholdTime()) {
                    BlockCanaryInternal.access$onBlockDetect(BlockCanaryInternal.INSTANCE, messageInfo);
                }
                messageInfo.setDispatchFinish(true);
            }
        };
    }

    public static final /* synthetic */ List access$getBlockCanaryListeners$p(BlockCanaryInternal $this) {
        BlockCanaryInternal blockCanaryInternal = $this;
        return blockCanaryListeners;
    }

    public static final /* synthetic */ HandlerThread access$getWatchDogHandler$p(BlockCanaryInternal $this) {
        BlockCanaryInternal blockCanaryInternal = $this;
        return watchDogHandler;
    }

    public static final /* synthetic */ Handler access$getHandler$p(BlockCanaryInternal $this) {
        return $this.getHandler();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lblockcanary/BlockCanaryInternal$SlowMessageWatchdog;", "Ljava/lang/Runnable;", "blockInfo", "Lblockcanary/BlockInfo;", "(Lblockcanary/BlockInfo;)V", "run", "", "blockcanary_release"})
    private static final class SlowMessageWatchdog
    implements Runnable {
        private final BlockInfo blockInfo;

        @Override
        public void run() {
            this.blockInfo.setDispatchFinish(false);
            this.blockInfo.setEndTime(FastTimer.Companion.currentTimeMillis());
            INSTANCE.onBlockDetect(this.blockInfo);
        }

        public SlowMessageWatchdog(@NotNull BlockInfo blockInfo) {
            Intrinsics.checkNotNullParameter((Object)blockInfo, (String)"blockInfo");
            this.blockInfo = blockInfo;
        }
    }
}

