/*
 * Decompiled with CFR 0.152.
 */
package blockcanary;

import android.os.Build;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import androidx.annotation.CallSuper;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class LooperMonitor
implements MessageQueue.IdleHandler {
    private final List<MessageDispatchListener> listeners = new CopyOnWriteArrayList<MessageDispatchListener>();
    private static final String TAG = "LooperMonitor";
    private LooperPrinter printer;
    private Looper looper;
    private static long CHECK_TIME = 2000L;
    private static final long CHECK_TIME_THRESHOLD = 60000L;
    private long lastCheckPrinterTime = 0L;
    private static LooperMonitor mainMonitor = new LooperMonitor(Looper.getMainLooper());
    private static boolean isReflectLoggingError = false;

    public static LooperMonitor ofMainThread() {
        return mainMonitor;
    }

    public List<MessageDispatchListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MessageDispatchListener listener) {
        List<MessageDispatchListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MessageDispatchListener listener) {
        List<MessageDispatchListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public LooperMonitor(Looper looper) {
        this.looper = looper;
        this.resetPrinter();
        this.addIdleHandler(looper);
    }

    public boolean queueIdle() {
        if (SystemClock.uptimeMillis() - this.lastCheckPrinterTime >= CHECK_TIME) {
            this.resetPrinter();
            this.lastCheckPrinterTime = SystemClock.uptimeMillis();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onRelease() {
        if (this.printer != null) {
            List<MessageDispatchListener> list = this.listeners;
            synchronized (list) {
                this.listeners.clear();
            }
            Log.v((String)TAG, (String)String.format("[onRelease] %s, origin printer:%s", this.looper.getThread().getName(), this.printer.origin));
            this.looper.setMessageLogging(this.printer.origin);
            this.removeIdleHandler(this.looper);
            this.looper = null;
            this.printer = null;
        }
    }

    private synchronized void resetPrinter() {
        Printer originPrinter = null;
        try {
            if (!isReflectLoggingError) {
                Field mLoggingField = this.looper.getClass().getDeclaredField("mLogging");
                mLoggingField.setAccessible(true);
                originPrinter = (Printer)mLoggingField.get(this.looper);
                if (originPrinter == this.printer && null != this.printer) {
                    return;
                }
            }
        }
        catch (Exception e) {
            isReflectLoggingError = true;
            Log.e((String)TAG, (String)"[resetPrinter] %s", (Throwable)e);
        }
        if (null != this.printer) {
            Log.w((String)TAG, (String)String.format("maybe thread:%s printer[%s] was replace other[%s]!", this.looper.getThread().getName(), this.printer, originPrinter));
        }
        CHECK_TIME = Math.max(60000L, CHECK_TIME * 2L);
        this.printer = new LooperPrinter(originPrinter);
        this.looper.setMessageLogging((Printer)this.printer);
        if (null != originPrinter) {
            Log.i((String)TAG, (String)String.format("reset printer, originPrinter[%s] in %s", originPrinter, this.looper.getThread().getName()));
        }
    }

    private synchronized void removeIdleHandler(Looper looper) {
        if (Build.VERSION.SDK_INT >= 23) {
            looper.getQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
        } else {
            try {
                MessageQueue queue = this.getLooperQueue(looper);
                queue.removeIdleHandler((MessageQueue.IdleHandler)this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[removeIdleHandler] %s", (Throwable)e);
            }
        }
    }

    private synchronized void addIdleHandler(Looper looper) {
        if (Build.VERSION.SDK_INT >= 23) {
            looper.getQueue().addIdleHandler((MessageQueue.IdleHandler)this);
        } else {
            try {
                MessageQueue queue = this.getLooperQueue(looper);
                queue.addIdleHandler((MessageQueue.IdleHandler)this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("[removeIdleHandler] " + e.toString()));
            }
        }
    }

    private MessageQueue getLooperQueue(Looper looper) throws Exception {
        Field mQueueField = Looper.class.getDeclaredField("mQueue");
        mQueueField.setAccessible(true);
        return (MessageQueue)mQueueField.get(looper);
    }

    private void dispatch(boolean isBegin, String log) {
        for (MessageDispatchListener listener : this.listeners) {
            if (isBegin) {
                listener.onDispatchStart(log);
                continue;
            }
            if (!listener.dispatchStarted) continue;
            listener.onDispatchEnd(log);
        }
    }

    private class LooperPrinter
    implements Printer {
        public Printer origin;
        boolean isHasChecked = false;

        LooperPrinter(Printer printer) {
            this.origin = printer;
        }

        public void println(String x) {
            if (null != this.origin) {
                this.origin.println(x);
                if (this.origin == this) {
                    throw new RuntimeException("LooperMonitor origin == this");
                }
            }
            if (!this.isHasChecked) {
                LooperMonitor.this.dispatch(x.charAt(0) == '>', x);
            }
        }
    }

    public static abstract class MessageDispatchListener {
        boolean dispatchStarted = false;

        @CallSuper
        public void onDispatchStart(String x) {
            this.dispatchStarted = true;
        }

        @CallSuper
        public void onDispatchEnd(String x) {
            this.dispatchStarted = false;
        }
    }
}

