/*
 * Decompiled with CFR 0.152.
 */
package blockcanary.db;

import android.content.Context;
import android.content.SharedPreferences;
import blockcanary.BlockInfo;
import blockcanary.db.BlockInfoRepository;
import com.google.gson.Gson;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lblockcanary/db/BlockInfoRepositoryImpl;", "Lblockcanary/db/BlockInfoRepository;", "mContext", "Landroid/content/Context;", "executors", "Ljava/util/concurrent/ExecutorService;", "cacheDir", "Ljava/io/File;", "(Landroid/content/Context;Ljava/util/concurrent/ExecutorService;Ljava/io/File;)V", "mGson", "Lcom/google/gson/Gson;", "mSp", "Landroid/content/SharedPreferences;", "blockInfoDetail", "Lblockcanary/BlockInfo;", "token", "", "delete", "", "deleteAll", "deleteBefore", "insertBlockInfo", "blockInfo", "listBlockInfo", "", "blockcanary_release"})
public final class BlockInfoRepositoryImpl
implements BlockInfoRepository {
    private final SharedPreferences mSp;
    private final ExecutorService executors;
    private final Gson mGson;
    private final File cacheDir;
    private final Context mContext;

    @Override
    public void insertBlockInfo(@NotNull BlockInfo blockInfo) {
        Intrinsics.checkNotNullParameter((Object)blockInfo, (String)"blockInfo");
        this.executors.submit(new Runnable(this, blockInfo){
            final /* synthetic */ BlockInfoRepositoryImpl this$0;
            final /* synthetic */ BlockInfo $blockInfo;

            public final void run() {
                String text = BlockInfoRepositoryImpl.access$getMGson$p(this.this$0).toJson((Object)this.$blockInfo);
                File file = new File(BlockInfoRepositoryImpl.access$getCacheDir$p(this.this$0), String.valueOf(this.$blockInfo.getStartTime()) + "-" + this.$blockInfo.costTime() + ".blockInfo");
                if (!BlockInfoRepositoryImpl.access$getCacheDir$p(this.this$0).exists()) {
                    BlockInfoRepositoryImpl.access$getCacheDir$p(this.this$0).mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                String string = text;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
            }
            {
                this.this$0 = blockInfoRepositoryImpl;
                this.$blockInfo = blockInfo;
            }
        });
    }

    @Override
    @NotNull
    public List<BlockInfo> listBlockInfo() {
        File[] fileArray = this.cacheDir.listFiles();
        if (fileArray == null) {
            return CollectionsKt.emptyList();
        }
        File[] files2 = fileArray;
        boolean bl = false;
        List blockInfoList = new ArrayList();
        File[] fileArray2 = files2;
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file;
            File file2 = file = fileArray2[i];
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            String name = FilesKt.getNameWithoutExtension((File)file2);
            List splitTokens = StringsKt.split$default((CharSequence)name, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null);
            String string = (String)splitTokens.get(0);
            boolean bl2 = false;
            long time = Long.parseLong(string);
            String string2 = (String)splitTokens.get(1);
            boolean bl3 = false;
            long costTime = Long.parseLong(string2);
            BlockInfo blockInfo = new BlockInfo();
            blockInfo.setStartTime(time);
            blockInfo.setEndTime(time + costTime);
            blockInfoList.add(blockInfo);
        }
        List $this$sortByDescending$iv = blockInfoList;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            boolean bl4 = false;
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    T receiver = b;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(((BlockInfo)receiver).getStartTime());
                    receiver = a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = ((BlockInfo)receiver).getStartTime();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            });
        }
        return blockInfoList;
    }

    @Override
    @Nullable
    public BlockInfo blockInfoDetail(long token) {
        BlockInfo blockInfo;
        File file;
        File[] files2;
        File[] fileArray = this.cacheDir.listFiles(new FilenameFilter(token){
            final /* synthetic */ long $token;

            public boolean accept(@NotNull File dir, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return StringsKt.startsWith$default((String)name, (String)("" + this.$token + '-'), (boolean)false, (int)2, null);
            }
            {
                this.$token = $captured_local_variable$0;
            }
        });
        if (fileArray == null) {
            return null;
        }
        File[] fileArray2 = files2 = fileArray;
        boolean bl = false;
        if (fileArray2.length == 0) {
            return null;
        }
        File file2 = file = files2[0];
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
        String text = FilesKt.readText$default((File)file2, null, (int)1, null);
        try {
            BlockInfo blockInfo2;
            blockInfo = blockInfo2 = (BlockInfo)this.mGson.fromJson(text, BlockInfo.class);
        }
        catch (Exception e) {
            blockInfo = null;
        }
        return blockInfo;
    }

    @Override
    public void deleteAll() {
        File[] listFiles;
        File[] fileArray = this.cacheDir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : listFiles = fileArray) {
            file.delete();
        }
    }

    @Override
    public void deleteBefore(long token) {
        File[] files2;
        File[] fileArray = this.cacheDir.listFiles(new FilenameFilter(token){
            final /* synthetic */ long $token;

            public boolean accept(@NotNull File dir, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                List splitTokens = StringsKt.split$default((CharSequence)name, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null);
                String string = (String)splitTokens.get(0);
                boolean bl = false;
                long time = Long.parseLong(string);
                return time < this.$token;
            }
            {
                this.$token = $captured_local_variable$0;
            }
        });
        if (fileArray == null) {
            return;
        }
        for (File file : files2 = fileArray) {
            file.delete();
        }
    }

    @Override
    public void delete(long token) {
        File[] files2;
        File[] fileArray = this.cacheDir.listFiles(new FilenameFilter(token){
            final /* synthetic */ long $token;

            public boolean accept(@NotNull File dir, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                List splitTokens = StringsKt.split$default((CharSequence)name, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null);
                String string = (String)splitTokens.get(0);
                boolean bl = false;
                long time = Long.parseLong(string);
                return time == this.$token;
            }
            {
                this.$token = $captured_local_variable$0;
            }
        });
        if (fileArray == null) {
            return;
        }
        for (File file : files2 = fileArray) {
            file.delete();
        }
    }

    public BlockInfoRepositoryImpl(@NotNull Context mContext, @NotNull ExecutorService executors, @NotNull File cacheDir) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intrinsics.checkNotNullParameter((Object)executors, (String)"executors");
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        this.mContext = mContext;
        this.mGson = new Gson();
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("block_info_meta", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"mContext.getSharedPrefer\u2026a\", Context.MODE_PRIVATE)");
        this.mSp = sharedPreferences;
        this.executors = executors;
        this.cacheDir = cacheDir;
    }

    public static final /* synthetic */ Gson access$getMGson$p(BlockInfoRepositoryImpl $this) {
        return $this.mGson;
    }

    public static final /* synthetic */ File access$getCacheDir$p(BlockInfoRepositoryImpl $this) {
        return $this.cacheDir;
    }
}

