/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.lancet.internal.asm.visitor;

import com.knightboost.lancet.internal.asm.visitor.BaseWeaveClassVisitor;
import com.knightboost.lancet.internal.asm.visitor.MethodChain;
import com.knightboost.lancet.internal.entity.InsertInfo;
import com.knightboost.lancet.internal.util.TypeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class InsertClassVisitor
extends BaseWeaveClassVisitor {
    private Map<String, List<InsertInfo>> executeInfos;
    private List<InsertInfo> matched;
    private int version;

    public InsertClassVisitor(Map<String, List<InsertInfo>> executeInfos) {
        this.executeInfos = executeInfos;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.version = version;
        this.matched = this.executeInfos.get(name);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.matched != null) {
            ArrayList methodsMatched = new ArrayList(this.matched.size() >> 1);
            this.matched.removeIf(e -> {
                if (e.targetMethod.equals(name) && e.targetDesc.equals(desc)) {
                    if (((e.sourceMethod.access ^ access) & 8) != 0) {
                        throw new IllegalStateException(e.sourceClass + "." + e.sourceMethod.name + " must have same static flag as " + this.transformer.className + "." + name);
                    }
                    methodsMatched.add(e);
                    return true;
                }
                return false;
            });
            if (methodsMatched.size() > 0 && (access & 0x500) == 0) {
                String staticDesc = TypeUtils.descToStatic(access, desc, this.transformer.className);
                ClassVisitor cv = this.transformer.getInnerClassVisitor("_boostWeave");
                String owner = this.transformer.getCanonicalName("_boostWeave");
                String newName = "original$" + name;
                boolean isInitMethod = "<init>".equals(name);
                if (isInitMethod) {
                    throw new RuntimeException("\u6784\u9020\u51fd\u6570\u6682\u4e0d\u652f\u6301Insert\u4fee\u6539");
                }
                int newAccess = access & 0xFFFFFFFA | 2;
                MethodChain chain = this.transformer.getMethodChain();
                chain.headFromInsert(newAccess, this.transformer.className, newName, desc);
                methodsMatched.forEach(insetInfo -> {
                    String methodName = insetInfo.sourceClass.substring(insetInfo.sourceClass.lastIndexOf("/") + 1) + "_" + insetInfo.sourceMethod.name;
                    chain.next(owner, 8, methodName, staticDesc, insetInfo.cloneMethodNode(), cv);
                });
                chain.fakePreMethod(this.transformer.className, access, name, desc, signature, exceptions);
                return super.visitMethod(newAccess, newName, desc, signature, exceptions);
            }
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        if (this.matched != null && this.matched.size() > 0) {
            new ArrayList<InsertInfo>(this.matched).stream().collect(Collectors.groupingBy(e -> e.targetMethod)).forEach((k, v) -> {
                if (v.stream().anyMatch(e -> e.createSuper)) {
                    InsertInfo insertInfo = (InsertInfo)v.get(0);
                    MethodVisitor mv = this.visitMethod(insertInfo.sourceMethod.access, insertInfo.targetMethod, insertInfo.targetDesc, insertInfo.sourceMethod.signature, insertInfo.sourceMethod.exceptions.toArray(new String[0]));
                    GeneratorAdapter adapter = new GeneratorAdapter(mv, insertInfo.sourceMethod.access, insertInfo.targetMethod, insertInfo.targetDesc);
                    adapter.visitCode();
                    adapter.loadThis();
                    adapter.loadArgs();
                    adapter.visitMethodInsn(183, this.transformer.superName, insertInfo.targetMethod, insertInfo.targetDesc, false);
                    adapter.returnValue();
                    int sz = Type.getArgumentsAndReturnSizes((String)insertInfo.targetDesc);
                    adapter.visitMaxs(Math.max(sz >> 2, sz & 3), sz >> 2);
                    adapter.visitEnd();
                }
            });
        }
        super.visitEnd();
    }
}

