/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.lancet.internal.asm.visitor;

import com.google.common.base.Preconditions;
import com.knightboost.lancet.api.annotations.ClassOf;
import com.knightboost.lancet.internal.asm.visitor.AutoUnboxMethodVisitor;
import com.knightboost.lancet.internal.log.WeaverLog;
import com.knightboost.lancet.internal.parser.AopMethodAdjuster;
import com.knightboost.lancet.internal.util.Bitset;
import com.knightboost.lancet.internal.util.PrimitiveUtil;
import com.knightboost.lancet.internal.util.TypeUtils;
import com.ss.android.ugc.bytex.common.graph.ClassEntity;
import com.ss.android.ugc.bytex.common.graph.FieldEntity;
import com.ss.android.ugc.bytex.common.graph.Graph;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodChain {
    private static final String ACCESS = "access$";
    private static final String FORMAT = "access$%03d";
    private static final String CLASS_OF = Type.getDescriptor(ClassOf.class);
    private String className;
    private ClassVisitor baseClassVisitor;
    private final Graph graph;
    private Bitset bitset;
    private Invoker head;
    private Map<String, FieldEntity> fieldMap;
    private final Map<String, Invoker> invokerMap = new HashMap<String, Invoker>();

    public MethodChain(Graph graph) {
        this.graph = graph;
    }

    public void init(String className, ClassVisitor classVisitor) {
        this.className = className;
        this.baseClassVisitor = classVisitor;
        this.bitset = new Bitset();
        this.bitset.setInitializer(b -> {
            int len = ACCESS.length();
            ClassEntity entity = this.graph.get((String)className).entity;
            entity.methods.forEach(m -> {
                if (TypeUtils.isStatic(m.access()) && m.name().startsWith(ACCESS)) {
                    this.bitset.tryAdd(m.name(), len);
                }
            });
        });
    }

    private void head(int access, int opcode, String owner, String name, String desc) {
        this.head = Invoker.createInvokerForMethod(new MethodInsnNode(opcode, owner, name, desc, opcode == 185), !this.hasPermission(access, owner), this.className);
    }

    private boolean hasPermission(int access, String owner) {
        return TypeUtils.isPublic(access) || !TypeUtils.isPrivate(access) && owner.equals(this.className);
    }

    public void headFromProxy(int opcode, String owner, String name, String desc) {
        int access = 2;
        if (opcode == 185 || opcode == 182) {
            access = 1;
        }
        this.head(access, opcode, owner, name, desc);
    }

    public void headFromInsert(int access, String owner, String name, String desc) {
        this.head(access, TypeUtils.isStatic(access) ? 184 : 183, owner, name, desc);
    }

    public void next(final String className, int access, String name, String desc, MethodNode node, ClassVisitor cv) {
        String[] exs = node.exceptions.toArray(new String[0]);
        this.head.createIfNeed(this.baseClassVisitor, this.bitset, exs);
        MethodVisitor mv = cv.visitMethod(access, name, desc, null, exs);
        node.accept(new MethodVisitor(327680, new AutoUnboxMethodVisitor(mv)){

            public void visitLdcInsn(Object value) {
                if (value instanceof String && value.equals("$ClassNameOfJoinPoint$")) {
                    String originalClassName = className.replace("$_boostWeave", "").replaceAll("/", ".");
                    super.visitLdcInsn((Object)originalClassName);
                } else {
                    super.visitLdcInsn(value);
                }
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == AopMethodAdjuster.OP_CALL) {
                    MethodChain.this.head.loadArgsAndInvoke(this.mv);
                } else if (opcode == AopMethodAdjuster.OP_THIS_GET_FIELD) {
                    MethodChain.this.dealField(180, name, this.mv);
                } else if (opcode == AopMethodAdjuster.OP_THIS_PUT_FIELD) {
                    MethodChain.this.dealField(181, name, this.mv);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                if (CLASS_OF.equals(desc)) {
                    return null;
                }
                return super.visitParameterAnnotation(parameter, desc, visible);
            }
        });
        this.headFromInsert(access, className, name, desc);
    }

    private void dealField(int opcode, String name, MethodVisitor mv) {
        this.initFields();
        String obj = "Ljava/lang/Object;";
        FieldEntity entity = this.fieldMap.get(name);
        if (entity == null) {
            this.baseClassVisitor.visitField(2, name, "Ljava/lang/Object;", null, null);
            entity = new FieldEntity(2, this.className, name, "Ljava/lang/Object;");
            this.fieldMap.put(name, entity);
        }
        boolean needCreate = TypeUtils.isPrivate(entity.access());
        String desc = entity.desc();
        this.invokerMap.computeIfAbsent(opcode + " " + name, k -> {
            Invoker invoker = Invoker.forField(new FieldInsnNode(opcode, this.className, name, desc), needCreate, this.className);
            invoker.createIfNeed(this.baseClassVisitor, this.bitset, null);
            return invoker;
        }).loadArgsAndInvoke(mv);
    }

    private void initFields() {
        if (this.fieldMap == null) {
            this.fieldMap = this.graph.get((String)this.className).entity.fields.stream().collect(Collectors.toMap(f -> f.name(), f -> f));
        }
    }

    public void fakePreMethod(String className, int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.baseClassVisitor.visitMethod(access, name, desc, null, exceptions);
        MethodChain.createMethod(access, desc, this.head.action()).accept(mv);
        this.headFromInsert(access, className, name, desc);
    }

    public Invoker getHead() {
        return this.head;
    }

    private static Consumer<MethodVisitor> createMethod(final int access, final String desc, final AbstractInsnNode action) {
        return new Consumer<MethodVisitor>(){

            @Override
            public void accept(MethodVisitor mv) {
                mv.visitCode();
                Type[] params = Type.getArgumentTypes((String)desc);
                int index = 0;
                if (!TypeUtils.isStatic(access)) {
                    ++index;
                    mv.visitVarInsn(25, 0);
                }
                for (Type t : params) {
                    mv.visitVarInsn(t.getOpcode(21), index);
                    index += t.getSize();
                }
                action.accept(mv);
                Type ret = Type.getReturnType((String)desc);
                mv.visitInsn(ret.getOpcode(172));
                mv.visitMaxs(Math.max(index, ret.getSize()), index);
                mv.visitEnd();
            }
        };
    }

    public static class Invoker
    implements Opcodes {
        final MethodInsnNode mn;
        final FieldInsnNode fn;
        final String staticDesc;
        final String owner;
        final boolean needCreate;
        MethodInsnNode syntheticNode;

        public static Invoker forField(FieldInsnNode fn, boolean needCreate, String className) {
            String staticDesc = Invoker.staticDesc(className, null, (FieldInsnNode)Preconditions.checkNotNull((Object)fn));
            return new Invoker(null, fn, needCreate, staticDesc, className);
        }

        public static Invoker createInvokerForMethod(MethodInsnNode mn, boolean needCreate, String className) {
            String staticDesc = Invoker.staticDesc(mn.owner, (MethodInsnNode)Preconditions.checkNotNull((Object)mn), null);
            return new Invoker(mn, null, needCreate, staticDesc, className);
        }

        private static String staticDesc(String className, MethodInsnNode mn, FieldInsnNode fn) {
            String desc = mn != null ? mn.desc : (fn.getOpcode() == 181 ? '(' + fn.desc + ")V" : "()" + fn.desc);
            int access = mn != null && mn.getOpcode() == 184 ? 8 : 0;
            return TypeUtils.descToStatic(access, desc, className);
        }

        Invoker(MethodInsnNode mn, FieldInsnNode fn, boolean needCreate, String staticDesc, String owner) {
            this.mn = mn;
            this.fn = fn;
            this.needCreate = needCreate;
            this.staticDesc = staticDesc;
            this.owner = owner;
        }

        public void createIfNeed(ClassVisitor cv, Bitset bitset, String[] exceptions) {
            if (this.syntheticNode != null) {
                throw new IllegalStateException("can't create more than once");
            }
            if (this.needCreate) {
                String name = String.format(MethodChain.FORMAT, bitset.consume());
                this.syntheticNode = new MethodInsnNode(184, this.owner, name, this.staticDesc, false);
                WeaverLog.tag("transform").i("create synthetic node :" + this.owner + " " + name + " " + this.staticDesc);
                MethodVisitor mv = cv.visitMethod(4104, name, this.staticDesc, null, exceptions);
                MethodChain.createMethod(8, this.staticDesc, (AbstractInsnNode)(this.mn == null ? this.fn : this.mn)).accept(mv);
            }
        }

        public void invoke(MethodVisitor mv) {
            this.action().accept(mv);
        }

        public void loadArgsAndInvoke(MethodVisitor mv) {
            if (this.mn != null) {
                Type[] params = Type.getArgumentTypes((String)this.staticDesc);
                int index = 0;
                for (Type t : params) {
                    mv.visitVarInsn(t.getOpcode(21), index);
                    index += t.getSize();
                }
                this.invoke(mv);
            } else if (this.fn.getOpcode() == 181) {
                mv.visitVarInsn(25, 0);
                mv.visitInsn(95);
                if (PrimitiveUtil.isPrimitive(this.fn.desc)) {
                    String owner = PrimitiveUtil.box(this.fn.desc);
                    mv.visitMethodInsn(182, PrimitiveUtil.virtualType(owner), PrimitiveUtil.unboxMethod(owner), "()" + this.fn.desc, false);
                }
                this.invoke(mv);
            } else {
                mv.visitVarInsn(25, 0);
                this.invoke(mv);
                if (PrimitiveUtil.isPrimitive(this.fn.desc)) {
                    String owner = PrimitiveUtil.box(this.fn.desc);
                    mv.visitMethodInsn(184, owner, "valueOf", "(" + this.fn.desc + ")L" + owner + ";", false);
                    ((AutoUnboxMethodVisitor)mv).markBoxed();
                }
            }
        }

        public AbstractInsnNode action() {
            if (this.syntheticNode != null) {
                return this.syntheticNode;
            }
            if (this.mn != null) {
                return this.mn;
            }
            return this.fn;
        }
    }
}

