/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.lancet.internal.asm.visitor;

import com.knightboost.lancet.internal.asm.visitor.MethodChain;
import com.knightboost.lancet.internal.asm.visitor.WeaveTransformer;
import com.knightboost.lancet.internal.entity.ProxyInfo;
import com.knightboost.lancet.internal.log.WeaverLog;
import com.knightboost.lancet.internal.util.TypeUtils;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ProxyMethodVisitor
extends MethodVisitor {
    private final Map<String, MethodChain.Invoker> invokerMap;
    private final Map<String, List<ProxyInfo>> matchMap;
    private final String className;
    private final String name;
    private final MethodChain chain;
    private final WeaveTransformer weaveTransformer;

    public ProxyMethodVisitor(MethodChain chain, MethodVisitor mv, Map<String, MethodChain.Invoker> invokerMap, Map<String, List<ProxyInfo>> matchMap, String className, String name, WeaveTransformer weaveTransformer) {
        super(327680, mv);
        this.chain = chain;
        this.invokerMap = invokerMap;
        this.matchMap = matchMap;
        this.className = className;
        this.name = name;
        this.weaveTransformer = weaveTransformer;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        String key = owner + " " + name + " " + desc;
        List<ProxyInfo> infos = this.matchMap.get(key);
        MethodChain.Invoker invoker = this.invokerMap.get(key);
        if (invoker != null) {
            invoker.invoke(this.mv);
        } else if (infos != null && infos.size() > 0) {
            String staticDesc = TypeUtils.descToStatic(opcode == 184 ? 8 : 0, desc, owner);
            this.chain.headFromProxy(opcode, owner, name, desc);
            String artificialClassname = this.weaveTransformer.getCanonicalName("_boostWeave");
            ClassVisitor cv = this.weaveTransformer.getInnerClassVisitor("_boostWeave");
            WeaverLog.tag("transform").i("start weave Call method  for " + owner + "." + name + desc + " in " + this.className + "." + this.name);
            infos.forEach(c -> {
                if (TypeUtils.isStatic(c.sourceMethod.access) != (opcode == 184)) {
                    throw new IllegalStateException(c.sourceClass + "." + c.sourceMethod.name + " should have the same static flag with " + owner + "." + name);
                }
                WeaverLog.tag("transform").i(" from " + c.sourceClass + "." + c.sourceMethod.name);
                String methodName = c.sourceClass.replace("/", "_") + "_" + c.sourceMethod.name;
                this.chain.next(artificialClassname, 8, methodName, staticDesc, c.threadLocalNode(), cv);
            });
            this.invokerMap.put(key, this.chain.getHead());
            this.chain.getHead().invoke(this.mv);
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

