/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.lancet.internal.asm.visitor;

import com.knightboost.lancet.internal.asm.visitor.BaseWeaveClassVisitor;
import com.knightboost.lancet.internal.asm.visitor.ReplaceWeaveMethodVisitor;
import com.knightboost.lancet.internal.entity.ReplaceInfo;
import com.knightboost.lancet.internal.entity.TransformInfo;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.objectweb.asm.MethodVisitor;

public class ReplaceClassVisitor
extends BaseWeaveClassVisitor {
    private List<ReplaceInfo> replaceInfos;
    private List<ReplaceInfo> matches;
    private TransformInfo transformInfo;
    private String className;

    public ReplaceClassVisitor(TransformInfo transformInfo) {
        this.transformInfo = transformInfo;
        this.replaceInfos = transformInfo.replaceInfo;
    }

    public void visit(int version, int access, final String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
        this.matches = this.replaceInfos.stream().filter(t -> t.match(name)).filter(new Predicate<ReplaceInfo>(){

            @Override
            public boolean test(ReplaceInfo replaceInfo) {
                for (String weaverClass : ((ReplaceClassVisitor)ReplaceClassVisitor.this).transformInfo.weaverClasses) {
                    if (!name.startsWith(weaverClass)) continue;
                    return false;
                }
                return true;
            }
        }).collect(Collectors.toList());
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matches == null || this.matches.size() == 0) {
            return mv;
        }
        return new ReplaceWeaveMethodVisitor(mv, access, name, desc, this.matches, this.className);
    }
}

