/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.lancet.internal.asm.visitor;

import com.knightboost.lancet.internal.asm.visitor.BaseWeaveClassVisitor;
import com.knightboost.lancet.internal.entity.ReplaceInvokeInfo;
import com.knightboost.lancet.internal.entity.TransformInfo;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class ReplaceNewClassVisitor
extends BaseWeaveClassVisitor {
    private final List<ReplaceInvokeInfo> replaceInvokes;

    public ReplaceNewClassVisitor(TransformInfo transformInfo) {
        this.replaceInvokes = transformInfo.replaceInvokes;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new ReplaceNewInstructionVisitor(methodVisitor);
    }

    class ReplaceNewInstructionVisitor
    extends MethodVisitor {
        private ReplaceInvokeInfo replaceInvokeInfo;

        public ReplaceNewInstructionVisitor(MethodVisitor methodVisitor) {
            super(327680, methodVisitor);
            this.replaceInvokeInfo = null;
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 187) {
                for (ReplaceInvokeInfo invokeInfo : ReplaceNewClassVisitor.this.replaceInvokes) {
                    if (!invokeInfo.getTargetClassType().equals(type)) continue;
                    String newType = invokeInfo.getNewClassType();
                    this.replaceInvokeInfo = invokeInfo;
                    type = newType;
                    break;
                }
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (this.replaceInvokeInfo != null && "<init>".equals(name) && owner.equals(this.replaceInvokeInfo.getTargetClassType())) {
                owner = this.replaceInvokeInfo.getNewClassType();
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }
    }
}

