/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.lancet.internal.core;

import com.knightboost.lancet.api.Scope;
import com.knightboost.lancet.api.annotations.ClassOf;
import com.knightboost.lancet.api.annotations.ImplementedInterface;
import com.knightboost.lancet.api.annotations.Insert;
import com.knightboost.lancet.api.annotations.NameRegex;
import com.knightboost.lancet.api.annotations.Proxy;
import com.knightboost.lancet.api.annotations.ReplaceInvoke;
import com.knightboost.lancet.api.annotations.ReplaceNewInvoke;
import com.knightboost.lancet.api.annotations.TargetClass;
import com.knightboost.lancet.api.annotations.TargetMethod;
import com.knightboost.lancet.internal.core.WeaverType;
import com.knightboost.lancet.internal.entity.InsertInfo;
import com.knightboost.lancet.internal.entity.ProxyInfo;
import com.knightboost.lancet.internal.entity.ReplaceInfo;
import com.knightboost.lancet.internal.entity.ReplaceInvokeInfo;
import com.knightboost.lancet.internal.entity.TransformInfo;
import com.knightboost.lancet.internal.graph.GraphUtil;
import com.knightboost.lancet.internal.parser.AopMethodAdjuster;
import com.knightboost.lancet.internal.util.AnnotationNodeUtil;
import com.knightboost.lancet.internal.util.TypeUtils;
import com.knightboost.lancet.plugin.LancetContext;
import com.ss.android.ugc.bytex.common.graph.Graph;
import com.ss.android.ugc.bytex.common.graph.Node;
import com.ss.android.ugc.bytex.common.log.ILogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class WeaverMethodParser {
    private WeaverType weaverType;
    private final MethodNode methodNode;
    private final ClassNode classNode;
    private final Graph graph;
    private Pattern classNamePattern = Pattern.compile("^(((?![0-9])\\w+\\.)*((?![0-9])\\w+\\$)?(?![0-9])\\w+)((\\[])*)$");
    private static final Set<String> weaveAnnotations = new HashSet<String>();

    public static boolean isWeaverMethodNode(MethodNode methodNode) {
        List annotationNodes = methodNode.visibleAnnotations;
        if (annotationNodes == null || annotationNodes.size() == 0) {
            return false;
        }
        for (AnnotationNode annotationNode : annotationNodes) {
            if (!weaveAnnotations.contains(annotationNode.desc)) continue;
            return true;
        }
        return false;
    }

    public WeaverMethodParser(Graph graph, ClassNode classNode, MethodNode methodNode) {
        this.graph = graph;
        this.classNode = classNode;
        this.methodNode = methodNode;
    }

    public String sourceClassName() {
        return this.classNode.name;
    }

    public void parseWeaverType(MethodNode methodNode) {
        if (this.getAnnotation(methodNode, Insert.class) != null) {
            this.weaverType = WeaverType.INSERT;
        } else if (this.getAnnotation(methodNode, Proxy.class) != null) {
            this.weaverType = WeaverType.PROXY;
        } else if (this.getAnnotation(methodNode, ReplaceInvoke.class) != null) {
            this.weaverType = WeaverType.REPLACE_INVOKE;
        } else if (this.getAnnotation(methodNode, ReplaceNewInvoke.class) != null) {
            this.weaverType = WeaverType.REPLACE_NEW_INVOKE;
        }
    }

    public String getTargetMethodDesc() {
        String methodDesc = this.methodNode.desc;
        List[] visibleParameterAnnotations = this.methodNode.visibleParameterAnnotations;
        Type[] argumentTypes = Type.getArgumentTypes((String)methodDesc);
        if (visibleParameterAnnotations != null) {
            for (int index = 0; index < visibleParameterAnnotations.length; ++index) {
                List annotationNodes = visibleParameterAnnotations[index];
                if (annotationNodes == null || annotationNodes.size() <= 0) continue;
                for (AnnotationNode annotationNode : annotationNodes) {
                    if (!annotationNode.desc.equals(Type.getDescriptor(ClassOf.class))) continue;
                    String parameterTypeDesc = AnnotationNodeUtil.getAnnotationStringValue(annotationNode, "value");
                    Type type = TypeUtils.classNameToType(parameterTypeDesc);
                    Type originalType = argumentTypes[index];
                    argumentTypes[index] = type;
                    if (originalType.getSort() != 10 && originalType.getSort() != 9) {
                        throw new IllegalArgumentException("@ClassOf \u7684\u53c2\u6570\u7c7b\u578b\u5e94\u5f53\u662f\u5bf9\u8c61\u6216\u8005\u6570\u7ec4\u7c7b\u578b");
                    }
                    if (type.getDimensions() == originalType.getDimensions()) {
                        if (this.graph.inherit(this.internalClassName(type), this.internalClassName(originalType))) continue;
                        throw new IllegalArgumentException("@ClassOf 's \u7684\u53c2\u6570\u7c7b\u578b \u5e94\u5f53\u662f @classOf\u6ce8\u89e3\u503c\u7684\u7236\u7c7b\u578b");
                    }
                    if (originalType.getSort() == 10 && "java/lang/Object".equals(originalType.getInternalName())) continue;
                    throw new IllegalArgumentException("@ClassOf 's origin type should be parent  in value");
                }
            }
        }
        StringBuilder methodDescBuilder = new StringBuilder();
        methodDescBuilder.append("(");
        for (int i = 0; i < argumentTypes.length; ++i) {
            methodDescBuilder.append(argumentTypes[i].getDescriptor());
        }
        methodDescBuilder.append(")");
        methodDescBuilder.append(Type.getReturnType((String)methodDesc));
        return methodDescBuilder.toString();
    }

    public List<String> getTargetClasses() {
        AnnotationNode targetClassNode = this.getAnnotation(this.methodNode, TargetClass.class);
        AnnotationNode implementedInterfaceNode = this.getAnnotation(this.methodNode, ImplementedInterface.class);
        if (targetClassNode == null && implementedInterfaceNode == null) {
            return new ArrayList<String>();
        }
        if (targetClassNode != null && implementedInterfaceNode != null) {
            throw new IllegalStateException("@TargetClass \u548c @ImplementedInterface \u4e0d\u80fd\u540c\u65f6\u4f7f\u7528");
        }
        final ArrayList<String> targetClasses = new ArrayList<String>();
        if (targetClassNode != null) {
            String targetClassName = AnnotationNodeUtil.getAnnotationStringValue(targetClassNode, "value");
            String[] vs = (String[])AnnotationNodeUtil.getAnnotationValue(targetClassNode, "scope");
            String targetClassDesc = targetClassName.replace('.', '/');
            Scope scope = Scope.SELF;
            if (vs != null) {
                scope = Scope.valueOf((String)vs[1]);
            }
            GraphUtil.childrenOf(this.graph, targetClassDesc, scope).forEach(new Consumer<Node>(){

                @Override
                public void accept(Node node) {
                    targetClasses.add(node.entity.name);
                }
            });
        } else {
            List targetInterfaces = (List)AnnotationNodeUtil.getAnnotationValue(implementedInterfaceNode, "value");
            if (targetInterfaces == null || targetInterfaces.size() == 0) {
                throw new IllegalArgumentException("@ImplementedInterface values can't be null or empty");
            }
            List<String> targetInterfaceDescList = targetInterfaces.stream().map(new Function<String, String>(){

                @Override
                public String apply(String s) {
                    return s.replace(".", "/");
                }
            }).collect(Collectors.toList());
            String[] vs = (String[])AnnotationNodeUtil.getAnnotationValue(implementedInterfaceNode, "scope");
            Scope scope = Scope.SELF;
            if (vs != null) {
                scope = Scope.valueOf((String)vs[1]);
            }
            GraphUtil.childrenOfInterfaces(this.graph, targetInterfaceDescList, scope).forEach(new Consumer<Node>(){

                @Override
                public void accept(Node node) {
                    targetClasses.add(node.entity.name);
                }
            });
        }
        return targetClasses;
    }

    public String getTargetMethodName() {
        AnnotationNode targetMethodNode = this.getAnnotation(this.methodNode, TargetMethod.class);
        if (targetMethodNode == null) {
            return this.methodNode.name;
        }
        return AnnotationNodeUtil.getAnnotationStringValue(targetMethodNode, "methodName");
    }

    public void parse() {
        this.parseWeaverType(this.methodNode);
        if (this.weaverType == null) {
            throw new IllegalStateException(this.classNode.name + "." + this.methodNode.name + " \u672a\u58f0\u660eWeave\u7c7b\u578b");
        }
        TransformInfo transformInfo = LancetContext.instance().getTransformInfo();
        if (this.weaverType == WeaverType.INSERT) {
            AnnotationNode insertAnnotation = this.getAnnotation(this.methodNode, Insert.class);
            String targetMethodName = this.getTargetMethodName();
            String targetMethodDesc = this.getTargetMethodDesc();
            boolean mayCreateSuper = AnnotationNodeUtil.getAnnotationBoolValue(insertAnnotation, "mayCreateSuper", false);
            List<String> targetClasses = this.getTargetClasses();
            for (String targetClass : targetClasses) {
                InsertInfo insertInfo = new InsertInfo(mayCreateSuper, targetClass, targetMethodName, targetMethodDesc, this.sourceClassName(), this.methodNode);
                transformInfo.addInsertInfo(insertInfo);
            }
        } else if (this.weaverType == WeaverType.PROXY) {
            List<String> targetClasses = this.getTargetClasses();
            String targetMethodName = this.getTargetMethodName();
            String targetMethodDesc = this.getTargetMethodDesc();
            AnnotationNode nameRegex = this.getAnnotation(this.methodNode, NameRegex.class);
            String regex = null;
            if (nameRegex != null) {
                regex = AnnotationNodeUtil.getAnnotationStringValue(nameRegex, "value");
            }
            for (String targetClass : targetClasses) {
                ProxyInfo proxyInfo = new ProxyInfo(regex, targetClass, targetMethodName, targetMethodDesc, this.sourceClassName(), this.methodNode);
                transformInfo.addProxyInfo(proxyInfo);
            }
        } else if (this.weaverType == WeaverType.REPLACE_INVOKE) {
            AnnotationNode annotation = this.getAnnotation(this.methodNode, ReplaceInvoke.class);
            boolean isStatic = AnnotationNodeUtil.getAnnotationBoolValue(annotation, "isStatic", false);
            List<String> targetClasses = this.getTargetClasses();
            String targetMethodName = this.getTargetMethodName();
            String targetMethodDesc = this.getTargetMethodDesc();
            AnnotationNode nameRegex = this.getAnnotation(this.methodNode, NameRegex.class);
            String regex = null;
            if (nameRegex != null) {
                regex = AnnotationNodeUtil.getAnnotationStringValue(nameRegex, "value");
            }
            for (String targetClass : targetClasses) {
                if (!isStatic) {
                    targetMethodDesc = TypeUtils.removeFirstParam(targetMethodDesc);
                }
                ReplaceInfo replaceInfo = new ReplaceInfo(regex, targetClass, targetMethodName, targetMethodDesc, this.sourceClassName(), this.methodNode);
                replaceInfo.targetIsStatic = isStatic;
                replaceInfo.check();
                transformInfo.addReplaceInfo(replaceInfo);
            }
        } else if (this.weaverType == WeaverType.REPLACE_NEW_INVOKE) {
            AnnotationNode annotation = this.getAnnotation(this.methodNode, ReplaceNewInvoke.class);
            Type argumentType = Type.getArgumentTypes((String)this.methodNode.desc)[0];
            String className = argumentType.getClassName().replace('.', '/');
            Type newType = Type.getArgumentTypes((String)this.methodNode.desc)[1];
            String newClassType = newType.getClassName().replace('.', '/');
            ReplaceInvokeInfo replaceInvokeInfo = new ReplaceInvokeInfo(className, newClassType, this.methodNode);
            transformInfo.addReplaceInvokes(replaceInvokeInfo);
        }
        new AopMethodAdjuster(this.weaverType == WeaverType.INSERT, this.sourceClassName(), this.methodNode).adjust();
    }

    private AnnotationNode getAnnotation(MethodNode methodNode, Class annotationClass) {
        List annotations = methodNode.visibleAnnotations;
        if (annotations == null) {
            return null;
        }
        for (AnnotationNode annotation : annotations) {
            if (!Type.getDescriptor((Class)annotationClass).equals(annotation.desc)) continue;
            return annotation;
        }
        return null;
    }

    public void parseMethodAnnotation(AnnotationNode annotationNode) {
        String desc = annotationNode.desc;
        if (Type.getDescriptor(Insert.class).equals(desc)) {
            this.weaverType = WeaverType.INSERT;
        } else if (Type.getDescriptor(Proxy.class).equals(desc)) {
            this.weaverType = WeaverType.PROXY;
        } else if (Type.getDescriptor(ReplaceInvoke.class).equals(desc)) {
            this.weaverType = WeaverType.REPLACE_INVOKE;
        }
    }

    private String internalClassName(Type type) {
        if (type.getSort() == 10) {
            return type.getInternalName();
        }
        return type.getElementType().getInternalName();
    }

    public ILogger getLogger() {
        return LancetContext.instance().getLogger();
    }

    static {
        weaveAnnotations.add(Type.getDescriptor(Insert.class));
        weaveAnnotations.add(Type.getDescriptor(Proxy.class));
        weaveAnnotations.add(Type.getDescriptor(ReplaceInvoke.class));
        weaveAnnotations.add(Type.getDescriptor(ReplaceNewInvoke.class));
    }
}

