/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.lancet.internal.log;

import com.knightboost.lancet.internal.log.ILogger;
import com.knightboost.lancet.internal.log.Impl.SystemLoggerImpl;

public class WeaverLog {
    private static ILogger logger = new SystemLoggerImpl();
    private static Level level = Level.INFO;
    public static final String DEFAULT_TAG = "KnightBoostWeaver";

    public static void setLevel(Level l) {
        level = l;
    }

    public static void setImpl(ILogger l) {
        logger = l;
    }

    public static Tag tag(String tag) {
        return new Tag(tag);
    }

    public static Tag tag(Object tag) {
        return new Tag(tag.getClass().getSimpleName());
    }

    public static Tag tag(Class clazz) {
        return new Tag(clazz.getSimpleName());
    }

    public static void d(String msg) {
        WeaverLog.tag(DEFAULT_TAG).d(msg);
    }

    public static void i(String msg) {
        WeaverLog.tag(DEFAULT_TAG).i(msg);
    }

    public static void w(String msg) {
        WeaverLog.w(msg, null);
    }

    public static void w(String msg, Throwable t) {
        WeaverLog.tag(DEFAULT_TAG).w(msg, t);
    }

    public static void e(String msg) {
        WeaverLog.e(msg, null);
    }

    public static void e(String msg, Throwable t) {
        WeaverLog.tag(DEFAULT_TAG).e(msg, t);
    }

    public static class Tag {
        private final String tag;

        Tag(String tag) {
            this.tag = tag;
        }

        public Tag d(String msg) {
            if (level.compareTo(Level.DEBUG) <= 0) {
                logger.d(this.tag, msg);
            }
            return this;
        }

        public Tag i(String msg) {
            if (level.compareTo(Level.INFO) <= 0) {
                logger.i(this.tag, msg);
            }
            return this;
        }

        public Tag w(String msg) {
            return this.w(msg, null);
        }

        public Tag w(String msg, Throwable t) {
            if (level.compareTo(Level.WARN) <= 0) {
                logger.w(this.tag, msg, t);
            }
            return this;
        }

        public Tag e(String msg) {
            return this.e(msg, null);
        }

        public Tag e(String msg, Throwable t) {
            if (level.compareTo(Level.ERROR) <= 0) {
                logger.e(this.tag, msg, t);
            }
            return this;
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

