/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.lancet.internal.meta;

import com.google.common.collect.Sets;
import com.knightboost.lancet.internal.entity.InsertInfo;
import com.knightboost.lancet.internal.entity.ProxyInfo;
import com.knightboost.lancet.internal.entity.ReplaceInfo;
import com.knightboost.lancet.internal.entity.TransformInfo;
import com.knightboost.lancet.internal.entity.TryCatchInfo;
import com.knightboost.lancet.internal.exception.IllegalAnnotationException;
import com.knightboost.lancet.internal.graph.GraphUtil;
import com.knightboost.lancet.internal.log.WeaverLog;
import com.knightboost.lancet.internal.parser.AopMethodAdjuster;
import com.knightboost.lancet.internal.util.TypeUtils;
import com.ss.android.ugc.bytex.common.graph.Graph;
import com.ss.android.ugc.bytex.common.graph.MethodEntity;
import java.util.Arrays;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class WeaveInfoLocator {
    private static final int INSERT = 1;
    private static final int PROXY = 16;
    private static final int TRY_CATCH = 256;
    private static final int REPLACE = 4096;
    private static final int PUBLIC_STATIC = 9;
    private int flag = 0;
    private Set<String> targetClasses;
    private Set<String> tempClasses;
    private String targetMethodDesc;
    private String targetMethodName;
    private boolean isStatic;
    private boolean mayCreateSuper;
    private String nameRegex;
    private boolean matchResultReverse;
    private Type[] argsType;
    private Type returnType;
    private String replaceClassName;
    private String replaceMethodName;
    private String replaceMethodDesc;
    private MethodNode sourceNode;
    private String sourceClass;
    private final Graph graph;

    public WeaveInfoLocator(Graph graph) {
        this.graph = graph;
    }

    public Graph graph() {
        return this.graph;
    }

    public Type[] getArgsType() {
        return this.argsType;
    }

    public void goMethod() {
        this.tempClasses = null;
    }

    public void intersectTargetClasses(Set<String> targetClasses) {
        this.tempClasses = this.tempClasses == null ? targetClasses : Sets.intersection(this.tempClasses, targetClasses);
        this.targetClasses = this.tempClasses;
    }

    public void adjustTargetMethodArgs(int index, Type type) {
        this.argsType[index] = type;
        this.targetMethodDesc = this.sourceNode.desc = Type.getMethodDescriptor((Type)this.returnType, (Type[])this.argsType);
    }

    public void setInsert(String targetMethod, boolean mayCreateSuper) {
        this.flag |= 1;
        this.targetMethodName = targetMethod;
        this.mayCreateSuper = mayCreateSuper;
    }

    public void setReplace(String targetMethodName, String targetMethodDesc, String replaceClassName, String replaceMethodName, String replaceMethodDesc, boolean isStatic) {
        this.flag |= 0x1000;
        this.targetMethodDesc = targetMethodDesc;
        this.targetMethodName = targetMethodName;
        this.replaceClassName = replaceClassName;
        this.replaceMethodName = replaceMethodName;
        this.replaceMethodDesc = replaceMethodDesc;
        this.isStatic = isStatic;
    }

    public void setProxy(String targetMethod) {
        this.flag |= 0x10;
        this.targetMethodName = targetMethod;
    }

    public void setTryCatch() {
        this.flag |= 0x100;
    }

    public void setNameRegex(String regex, boolean reverse) {
        this.nameRegex = regex;
        this.matchResultReverse = reverse;
    }

    public void setSourceNode(String sourceClass, MethodNode node) {
        this.sourceClass = sourceClass;
        this.sourceNode = node;
        this.targetMethodDesc = this.sourceNode.desc;
        this.argsType = Type.getArgumentTypes((String)this.targetMethodDesc);
        this.returnType = Type.getReturnType((String)this.targetMethodDesc);
    }

    public void appendTo(TransformInfo transformInfo) {
        this.check();
        switch (this.flag) {
            case 1: {
                for (String targetClass : this.targetClasses) {
                    MethodEntity finalOriginalMethod;
                    if (this.mayCreateSuper && (finalOriginalMethod = GraphUtil.findFinalOriginalMethod(this.graph, targetClass, this.targetMethodName, this.targetMethodDesc)) != null && !finalOriginalMethod.className().equals(targetClass)) {
                        WeaverLog.e(" >> << ignore Replace for final " + targetClass + " " + this.targetMethodName);
                        continue;
                    }
                    InsertInfo insertInfo = new InsertInfo(this.mayCreateSuper, targetClass, this.targetMethodName, this.targetMethodDesc, this.sourceClass, this.sourceNode);
                    transformInfo.addInsertInfo(insertInfo);
                }
                break;
            }
            case 16: {
                for (String c : this.targetClasses) {
                    ProxyInfo proxyInfo = new ProxyInfo(this.nameRegex, c, this.targetMethodName, this.targetMethodDesc, this.sourceClass, this.sourceNode);
                    transformInfo.addProxyInfo(proxyInfo);
                }
                break;
            }
            case 4096: {
                this.generateAndAddReplaceInfo(transformInfo);
                break;
            }
            case 256: {
                transformInfo.addTryCatch(new TryCatchInfo(this.nameRegex, this.sourceClass, this.sourceNode.name, this.targetMethodDesc));
            }
        }
    }

    private void generateAndAddReplaceInfo(TransformInfo transformInfo) {
        this.targetClasses.stream().map(c -> {
            ReplaceInfo replaceInfo = new ReplaceInfo(this.nameRegex, (String)c, this.targetMethodName, this.targetMethodDesc, this.sourceClass, this.sourceNode);
            replaceInfo.matchResultReverse = this.matchResultReverse;
            replaceInfo.replaceClassName = this.replaceClassName;
            replaceInfo.replaceMethodName = this.replaceMethodName;
            replaceInfo.replaceMethodDesc = this.replaceMethodDesc;
            replaceInfo.targetIsStatic = this.isStatic;
            replaceInfo.check();
            return replaceInfo;
        }).forEach(transformInfo::addReplaceInfo);
    }

    private void check() {
        if (this.flag <= 0) {
            throw new IllegalAnnotationException("no @Proxy, @Insert or @TryCatchHandler on " + this.sourceClass + "." + this.sourceNode.name);
        }
        if (Integer.bitCount(this.flag) > 1) {
            throw new IllegalAnnotationException("@Proxy @Insert or @TryCatchHandler can only appear once");
        }
        if (this.flag != 256) {
            if (this.targetClasses == null) {
                throw new IllegalAnnotationException("no @targetClass or @ImplementedInterface on " + this.sourceClass + "." + this.sourceNode.name);
            }
            if (this.targetClasses.size() <= 0) {
                WeaverLog.w("can't find satisfied class with " + this.sourceClass + "." + this.sourceNode.name);
            }
        } else if (!this.targetMethodDesc.equals("(Ljava/lang/Throwable;)Ljava/lang/Throwable;") || (this.sourceNode.access & 9) != 9) {
            throw new IllegalAnnotationException("method annotated with @TryCatchHandler should be like this: public static Throwable method_name(Throwable)");
        }
        if (this.mayCreateSuper && TypeUtils.isStatic(this.sourceNode.access)) {
            throw new IllegalAnnotationException("can't use mayCreateSuper while method is static, " + this.sourceClass + "." + this.sourceNode.name);
        }
    }

    public boolean satisfied() {
        return this.targetClasses != null && this.targetClasses.size() > 0 && (this.flag == 1 || this.flag == 16);
    }

    public void transformNode() {
        new AopMethodAdjuster(this.flag == 1, this.sourceClass, this.sourceNode).adjust();
    }

    public String toString() {
        return "HookInfoLocator{flag=" + this.flag + ", classes=" + this.targetClasses + ", targetDesc='" + this.targetMethodDesc + '\'' + ", targetMethod='" + this.targetMethodName + '\'' + ", mayCreateSuper=" + this.mayCreateSuper + ", nameRegex='" + this.nameRegex + '\'' + ", argsType=" + Arrays.toString(this.argsType) + ", returnType=" + this.returnType + ", sourceClass='" + this.sourceClass + '\'' + '}';
    }
}

