/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.lancet.internal.parser;

import com.knightboost.lancet.api.Origin;
import com.knightboost.lancet.api.This;
import com.knightboost.lancet.internal.util.PrimitiveUtil;
import com.knightboost.lancet.internal.util.TypeUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AopMethodAdjuster {
    public static int OP_CALL = 225;
    public static int OP_THIS_GET_FIELD = 226;
    public static int OP_THIS_PUT_FIELD = 227;
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private final boolean allowField;
    private final String sourceClass;
    private final MethodNode methodNode;
    private final CallReplacer CALL_REPLACER;
    private final ThisReplacer THIS_REPLACER = new ThisReplacer();

    public AopMethodAdjuster(boolean allowField, String sourceClass, MethodNode methodNode) {
        this.allowField = allowField;
        this.sourceClass = sourceClass;
        this.methodNode = methodNode;
        this.CALL_REPLACER = new CallReplacer(methodNode.desc);
        this.init();
    }

    private void init() {
        String desc = this.methodNode.desc;
        int size = Type.getArgumentsAndReturnSizes((String)desc);
        if (TypeUtils.isStatic(this.methodNode.access)) {
            size -= 4;
        }
        size = Math.max(size & 3, size >> 2);
        this.methodNode.maxStack = Math.max(size, this.methodNode.maxStack);
    }

    public void adjust() {
        for (AbstractInsnNode element = this.methodNode.instructions.getFirst(); element != null; element = element.getNext()) {
            if (!(element instanceof MethodInsnNode)) continue;
            element = this.transform((MethodInsnNode)element);
        }
    }

    private AbstractInsnNode transform(MethodInsnNode node) {
        String owner = node.owner;
        String name = node.name;
        NodeReplacer replacer = NodeReplacer.IDENTITY;
        if (owner.equals(Origin.CLASS_NAME)) {
            if (name.startsWith("call")) {
                replacer = this.CALL_REPLACER;
            }
        } else if (owner.equals(This.CLASS_NAME)) {
            replacer = this.THIS_REPLACER;
        }
        return replacer.replace(node);
    }

    private void illegalState(String msg) {
        throw new IllegalStateException("error in " + this.sourceClass + "." + this.methodNode.name + ": " + msg);
    }

    private class ThisReplacer
    implements NodeReplacer {
        private ThisReplacer() {
        }

        @Override
        public AbstractInsnNode replace(MethodInsnNode node) {
            if (TypeUtils.isStatic(((AopMethodAdjuster)AopMethodAdjuster.this).methodNode.access)) {
                AopMethodAdjuster.this.illegalState("static method shouldn't call This's function");
            }
            switch (node.name) {
                case "get": {
                    VarInsnNode varInsnNode = new VarInsnNode(25, 0);
                    ((AopMethodAdjuster)AopMethodAdjuster.this).methodNode.instructions.set((AbstractInsnNode)node, (AbstractInsnNode)varInsnNode);
                    return varInsnNode;
                }
                case "getField": {
                    this.checkAllow(node.name);
                    node.setOpcode(OP_THIS_GET_FIELD);
                    node.name = this.getFieldName(node.getPrevious());
                    break;
                }
                case "putField": {
                    this.checkAllow(node.name);
                    node.setOpcode(OP_THIS_PUT_FIELD);
                    node.name = this.getFieldName(node.getPrevious());
                }
            }
            return node;
        }

        private void checkAllow(String name) {
            if (!AopMethodAdjuster.this.allowField) {
                AopMethodAdjuster.this.illegalState("This." + name + " only allow in @Insert");
            }
        }

        private void removeBox(AbstractInsnNode previous) {
            MethodInsnNode node;
            if (previous instanceof MethodInsnNode && (node = (MethodInsnNode)previous).getOpcode() == 184 && node.name.equals("valueOf") && PrimitiveUtil.boxedTypes().contains(node.owner)) {
                ((AopMethodAdjuster)AopMethodAdjuster.this).methodNode.instructions.remove(previous);
            }
        }

        private String getType(AbstractInsnNode next) {
            if (next instanceof TypeInsnNode && next.getOpcode() == 192) {
                String desc = ((TypeInsnNode)next).desc;
                if (next.getNext() instanceof MethodInsnNode) {
                    MethodInsnNode methodInsnNode = (MethodInsnNode)next.getNext();
                    if (methodInsnNode.owner.equals(desc) && methodInsnNode.name.equals(PrimitiveUtil.unboxMethod(desc))) {
                        ((AopMethodAdjuster)AopMethodAdjuster.this).methodNode.instructions.remove((AbstractInsnNode)methodInsnNode);
                    }
                }
                ((AopMethodAdjuster)AopMethodAdjuster.this).methodNode.instructions.remove(next);
                return desc;
            }
            return AopMethodAdjuster.JAVA_LANG_OBJECT;
        }

        private String getFieldName(AbstractInsnNode node) {
            if (!(node instanceof LdcInsnNode)) {
                AopMethodAdjuster.this.illegalState("only accept constant string as field name");
            }
            LdcInsnNode ldc = (LdcInsnNode)node;
            if (ldc.cst == null || !(ldc.cst instanceof String)) {
                AopMethodAdjuster.this.illegalState("only accept constant string as field name");
            }
            String val = (String)ldc.cst;
            ((AopMethodAdjuster)AopMethodAdjuster.this).methodNode.instructions.remove(node);
            return val;
        }
    }

    private class CallReplacer
    implements NodeReplacer {
        private static final int VOID = 1;
        private static final int REFERENCE = 2;
        private static final int PRIMITIVE = 3;
        private int type;
        private String returnType;

        CallReplacer(String desc) {
            String retDesc = desc.substring(desc.lastIndexOf(41) + 1);
            if (retDesc.equals("V")) {
                this.type = 1;
            } else if (retDesc.endsWith(";") || retDesc.charAt(0) == '[') {
                this.type = 2;
                if (retDesc.charAt(0) != '[' && retDesc.endsWith(";")) {
                    retDesc = retDesc.substring(1, retDesc.length() - 1);
                }
                this.returnType = retDesc;
            } else {
                this.type = 3;
                this.returnType = PrimitiveUtil.box(retDesc);
            }
        }

        @Override
        public AbstractInsnNode replace(MethodInsnNode node) {
            this.checkReturnType(node);
            node.setOpcode(OP_CALL);
            if (this.type != 1 && !this.returnType.equals(AopMethodAdjuster.JAVA_LANG_OBJECT)) {
                this.checkCast(node.getNext());
                ((AopMethodAdjuster)AopMethodAdjuster.this).methodNode.instructions.remove(node.getNext());
            }
            if (this.type == 3) {
                this.checkUnbox(node.getNext());
                ((AopMethodAdjuster)AopMethodAdjuster.this).methodNode.instructions.remove(node.getNext());
            }
            return node;
        }

        private void checkReturnType(MethodInsnNode node) {
            boolean hasInDesc;
            boolean has = !node.name.startsWith("callVoid");
            boolean bl = hasInDesc = this.type != 1;
            if (has != hasInDesc) {
                AopMethodAdjuster.this.illegalState("\u539f\u51fd\u6570\u7684\u8fd4\u56de\u7c7b\u578b\u4e0d\u4e3avoid\uff0c\u8bf7\u9009\u62e9\u5408\u9002\u7684\u4ee3\u7406\u51fd\u6570\u8c03\u7528");
            }
        }

        private void checkCast(AbstractInsnNode insnNode) {
            TypeInsnNode typeInsnNode;
            if (!(insnNode instanceof TypeInsnNode)) {
                AopMethodAdjuster.this.illegalState("Returned Object type should be cast to origin type immediately.");
            }
            if ((typeInsnNode = (TypeInsnNode)insnNode).getOpcode() != 192) {
                AopMethodAdjuster.this.illegalState("Returned Object type should be cast to origin type immediately.");
            }
            if (!typeInsnNode.desc.equals(this.returnType)) {
                AopMethodAdjuster.this.illegalState("Casted type is expected to be " + this.returnType + " , but is " + typeInsnNode.desc);
            }
        }

        private void checkUnbox(AbstractInsnNode insnNode) {
            if (!(insnNode instanceof MethodInsnNode)) {
                AopMethodAdjuster.this.illegalState("Please don't unbox by your self.");
            }
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            if (!methodInsnNode.owner.equals(this.returnType)) {
                AopMethodAdjuster.this.illegalState("Please don't unbox by your self.");
            }
            if (!methodInsnNode.name.equals(PrimitiveUtil.unboxMethod(this.returnType))) {
                AopMethodAdjuster.this.illegalState("Please don't unbox by your self.");
            }
        }
    }

    private static interface NodeReplacer {
        public static final NodeReplacer IDENTITY = node -> node;

        public AbstractInsnNode replace(MethodInsnNode var1);
    }
}

