/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.lancet.internal.util;

import java.util.Arrays;

public class Bitset {
    private static final int[] EMPTY = new int[0];
    private int[] bits = EMPTY;
    int next = 0;
    private Initializer initializer;

    public void tryAdd(String intLike, int index) {
        int res = 0;
        while (index < intLike.length()) {
            int e = intLike.charAt(index) - 48;
            if (e < 0 || e > 9) {
                return;
            }
            res = res * 10 + e;
            ++index;
        }
        this.add(res);
    }

    private void add(int bit) {
        this.ensureCapacity(bit);
        int n = bit >> 5;
        this.bits[n] = this.bits[n] | 1 << (bit & 0x1F);
        if (bit == this.next) {
            this.moveToNext();
        }
    }

    private void moveToNext() {
        int i = this.next;
        int[] localBits = this.bits;
        while ((localBits[i >> 5] >> (i & 0x1F) & 1) != 0) {
            ++i;
        }
        this.next = i;
    }

    private void ensureCapacity(int bit) {
        if (bit > 2147483616) {
            throw new OutOfMemoryError();
        }
        bit = (bit >> 5) + 1;
        if (this.bits == EMPTY) {
            this.bits = new int[Bitset.minPow(bit)];
        } else if (bit >= this.bits.length) {
            int bl = this.bits.length << 1;
            this.bits = Arrays.copyOf(this.bits, bit <= bl ? bl : Bitset.minPow(bit));
        }
    }

    private static int minPow(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    public int consume() {
        this.init();
        int i = this.next;
        this.add(i);
        return i;
    }

    private void init() {
        if (this.bits == EMPTY) {
            this.initializer.initialize(this);
        }
    }

    public void setInitializer(Initializer initializer) {
        this.initializer = initializer;
    }

    public static interface Initializer {
        public void initialize(Bitset var1);
    }
}

