/*
 * Decompiled with CFR 0.152.
 */
package com.knightboost.stacksampler;

import androidx.annotation.NonNull;
import com.knightboost.stacksampler.StackTraceSample;
import com.knightboost.stacksampler.util.FastTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class StackSampler {
    private Thread targetThread;
    private int sampleInterval;
    private int maxCacheCount;
    private ScheduledExecutorService scheduler;
    private final ConcurrentLinkedQueue<StackTraceSample> stackTraceSampleQueue = new ConcurrentLinkedQueue();
    private final Object queueLock = new Object();
    private boolean isSampling = false;
    private final int DEFAULT_MAX_SAMPLING_TOTAL_MILL_TIME = 20000;

    public StackSampler(@NonNull Thread targetThread, int sampleInterval) {
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("StackSampler");
                return thread;
            }
        });
        this.init(targetThread, this.scheduler, sampleInterval, 20000);
    }

    public StackSampler(@NonNull Thread targetThread, @NonNull ScheduledExecutorService scheduler, int sampleInterval) {
        this.init(targetThread, scheduler, sampleInterval, 20000);
    }

    private void init(@NonNull Thread targetThread, @NonNull ScheduledExecutorService scheduler, int samplingInterval, int maxSamplingTotalTime) {
        StackSampler.checkThread(targetThread);
        StackSampler.checkInterval(samplingInterval);
        this.targetThread = targetThread;
        this.sampleInterval = samplingInterval;
        this.maxCacheCount = maxSamplingTotalTime / this.sampleInterval;
        this.scheduler = scheduler;
    }

    public synchronized void startSampling() {
        if (this.isSampling) {
            return;
        }
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long wallTime = FastTimer.currentTimeMillis();
                StackTraceElement[] stackTraceElements = StackSampler.this.targetThread.getStackTrace();
                StackTraceSample stackTraceSample = new StackTraceSample(wallTime, stackTraceElements);
                Object object = StackSampler.this.queueLock;
                synchronized (object) {
                    if (StackSampler.this.stackTraceSampleQueue.size() > StackSampler.this.maxCacheCount) {
                        StackSampler.this.stackTraceSampleQueue.poll();
                    }
                    StackSampler.this.stackTraceSampleQueue.offer(stackTraceSample);
                }
            }
        }, 0L, this.sampleInterval, TimeUnit.MILLISECONDS);
        this.isSampling = true;
    }

    public synchronized void stopSampling() {
        this.isSampling = false;
        this.stackTraceSampleQueue.clear();
    }

    public int getSampleInterval() {
        return this.sampleInterval;
    }

    public List<StackTraceSample> getStackSamplesBetweenElapseRealTime(long beginTime, long endTime) {
        long beginWallTime = FastTimer.convertElapseRealTimeToRTCTime(beginTime);
        long endWallTime = FastTimer.convertElapseRealTimeToRTCTime(endTime);
        return this.getStackSamplesBetweenWallTime(beginWallTime, endWallTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StackTraceSample> getStackSamplesBetweenWallTime(long beginTime, long endTime) {
        ArrayList<StackTraceSample> stackTraceSamples = null;
        Object object = this.queueLock;
        synchronized (object) {
            stackTraceSamples = new ArrayList<StackTraceSample>(this.stackTraceSampleQueue);
        }
        ArrayList<StackTraceSample> result = new ArrayList<StackTraceSample>();
        for (int i = 0; i < stackTraceSamples.size(); ++i) {
            StackTraceSample item = stackTraceSamples.get(i);
            long time = item.getTime();
            if (time < beginTime || time > endTime) continue;
            result.add(item);
        }
        return result;
    }

    private static void checkThread(Object o) {
        if (o == null) {
            throw new RuntimeException("targetThread can't be null");
        }
    }

    private static void checkInterval(int interval) {
        if (interval <= 0) {
            throw new RuntimeException("interval value must >0");
        }
    }
}

