/*
 * Decompiled with CFR 0.152.
 */
package com.k6.weaver.generator;

import com.k6.weaver.config.annotation.K6Ignore;
import com.k6.weaver.service.EndPoint;
import com.k6.weaver.util.K6WeaverConfigProperties;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Component
public class ControllerScanner {
    private static final List<EndPoint> END_POINTS = new ArrayList<EndPoint>();
    private final ApplicationContext applicationContext;
    private final K6WeaverConfigProperties k6WeaverConfigProperties;

    public ControllerScanner(ApplicationContext applicationContext, K6WeaverConfigProperties k6WeaverConfigProperties) {
        this.applicationContext = applicationContext;
        this.k6WeaverConfigProperties = k6WeaverConfigProperties;
    }

    @PostConstruct
    public void findEndPoints() {
        Map restController = this.applicationContext.getBeansWithAnnotation(RestController.class);
        String basePackage = this.k6WeaverConfigProperties.getBasePackage();
        for (Object controller : restController.values()) {
            Method[] methods;
            Class<?> controllerClass = controller.getClass();
            String controllerPackage = controllerClass.getPackage().getName();
            String baseEndPoint = "";
            if (!controllerPackage.startsWith(basePackage) || controllerClass.isAnnotationPresent(K6Ignore.class)) continue;
            if (controllerClass.isAnnotationPresent(RequestMapping.class)) {
                RequestMapping requestMapping = controllerClass.getAnnotation(RequestMapping.class);
                baseEndPoint = this.endPointFormatter(requestMapping.value()[0]);
            }
            for (Method method : methods = controllerClass.getDeclaredMethods()) {
                EndPoint targetEndPoint;
                if (method.isAnnotationPresent(K6Ignore.class) || (targetEndPoint = this.getTargetEndPoint(method, baseEndPoint, controllerPackage)) == null) continue;
                END_POINTS.add(targetEndPoint);
            }
        }
    }

    public static List<EndPoint> fetchEndPoints() {
        Collections.sort(END_POINTS);
        return END_POINTS;
    }

    private String endPointFormatter(String endPoint) {
        if (!((String)endPoint).startsWith("/")) {
            endPoint = "/" + (String)endPoint;
        }
        if (((String)endPoint).endsWith("/")) {
            endPoint = ((String)endPoint).substring(0, ((String)endPoint).length() - 1);
        }
        return endPoint;
    }

    private EndPoint getTargetEndPoint(Method method, String baseEndPoint, String controllerPackage) {
        EndPoint targetEndPoint = null;
        if (method.isAnnotationPresent(GetMapping.class)) {
            targetEndPoint = this.generateTargetEndPoint(baseEndPoint, method.getAnnotation(GetMapping.class).value(), "GET", controllerPackage);
        } else if (method.isAnnotationPresent(PostMapping.class)) {
            targetEndPoint = this.generateTargetEndPoint(baseEndPoint, method.getAnnotation(PostMapping.class).value(), "POST", controllerPackage);
        } else if (method.isAnnotationPresent(PutMapping.class)) {
            targetEndPoint = this.generateTargetEndPoint(baseEndPoint, method.getAnnotation(PutMapping.class).value(), "PUT", controllerPackage);
        } else if (method.isAnnotationPresent(DeleteMapping.class)) {
            targetEndPoint = this.generateTargetEndPoint(baseEndPoint, method.getAnnotation(DeleteMapping.class).value(), "DELETE", controllerPackage);
        }
        return targetEndPoint;
    }

    private EndPoint generateTargetEndPoint(String baseEndPoint, String[] urlValues, String requestMethod, String controllerPackage) {
        Object fullEndPoint = baseEndPoint;
        if (urlValues.length > 0) {
            fullEndPoint = (String)fullEndPoint + this.endPointFormatter(urlValues[0]);
        }
        return new EndPoint((String)fullEndPoint, requestMethod, controllerPackage);
    }
}

