/*
 * Decompiled with CFR 0.152.
 */
package io.github.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.GraphqlCodegen;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.supplier.JsonMappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.supplier.SchemaFinder;
import io.github.kobylynskyi.graphql.codegen.SchemaFinderConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GraphqlCodegenMojo
extends AbstractMojo {
    @Parameter
    private String[] graphqlSchemaPaths;
    @Parameter
    private SchemaFinderConfig graphqlSchemas = new SchemaFinderConfig();
    @Parameter(required=true)
    private File outputDir;
    @Parameter
    private Map<String, String> customTypesMapping;
    @Parameter
    private Map<String, String> customAnnotationsMapping;
    @Parameter
    private String packageName;
    @Parameter(defaultValue="true")
    private boolean generateApis;
    @Parameter(defaultValue="false")
    private boolean generateEqualsAndHashCode;
    @Parameter(defaultValue="false")
    private boolean generateToString;
    @Parameter
    private String apiPackageName;
    @Parameter
    private String modelPackageName;
    @Parameter
    private String modelNamePrefix;
    @Parameter
    private String modelNameSuffix;
    @Parameter
    private String subscriptionReturnType;
    @Parameter(defaultValue="false")
    private boolean generateAsyncApi;
    @Parameter(defaultValue="javax.validation.constraints.NotNull")
    private String modelValidationAnnotation;
    @Parameter(defaultValue="true")
    private boolean generateParameterizedFieldsResolvers;
    @Parameter
    private Set<String> fieldsWithResolvers = new HashSet<String>();
    @Parameter(name="jsonConfigurationFile", required=false)
    private String jsonConfigurationFile;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.addCompileSourceRootIfConfigured();
        MappingConfig mappingConfig = new MappingConfig();
        mappingConfig.setPackageName(this.packageName);
        mappingConfig.setCustomTypesMapping(this.customTypesMapping != null ? this.customTypesMapping : new HashMap());
        mappingConfig.setModelNamePrefix(this.modelNamePrefix);
        mappingConfig.setModelNameSuffix(this.modelNameSuffix);
        mappingConfig.setApiPackageName(this.apiPackageName);
        mappingConfig.setModelPackageName(this.modelPackageName);
        mappingConfig.setGenerateApis(Boolean.valueOf(this.generateApis));
        mappingConfig.setModelValidationAnnotation(this.modelValidationAnnotation);
        mappingConfig.setCustomAnnotationsMapping(this.customAnnotationsMapping != null ? this.customAnnotationsMapping : new HashMap());
        mappingConfig.setGenerateEqualsAndHashCode(Boolean.valueOf(this.generateEqualsAndHashCode));
        mappingConfig.setGenerateToString(Boolean.valueOf(this.generateToString));
        mappingConfig.setSubscriptionReturnType(this.subscriptionReturnType);
        mappingConfig.setGenerateAsyncApi(Boolean.valueOf(this.generateAsyncApi));
        mappingConfig.setGenerateParameterizedFieldsResolvers(Boolean.valueOf(this.generateParameterizedFieldsResolvers));
        mappingConfig.setFieldsWithResolvers(this.fieldsWithResolvers != null ? this.fieldsWithResolvers : new HashSet());
        MappingConfigSupplier mappingConfigSupplier = this.buildJsonSupplier(this.jsonConfigurationFile);
        try {
            new GraphqlCodegen(this.getSchemas(), this.outputDir, mappingConfig, mappingConfigSupplier).generate();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
    }

    private List<String> getSchemas() throws MojoExecutionException, IOException {
        if (this.graphqlSchemaPaths != null) {
            return Arrays.asList(this.graphqlSchemaPaths);
        }
        if (this.graphqlSchemas != null) {
            SchemaFinder finder = new SchemaFinder(Paths.get(this.graphqlSchemas.getRootDir(), new String[0]));
            finder.setRecursive(this.graphqlSchemas.isRecursive());
            finder.setIncludePattern(this.graphqlSchemas.getIncludePattern());
            finder.setExcludedFiles(this.graphqlSchemas.getExcludedFiles());
            return finder.findSchemas();
        }
        throw new MojoExecutionException("One of graphqlSchemaPaths or graphqlSchemas parameters must be provided");
    }

    private MappingConfigSupplier buildJsonSupplier(String jsonConfigurationFile) {
        if (jsonConfigurationFile != null && !jsonConfigurationFile.isEmpty()) {
            return new JsonMappingConfigSupplier(jsonConfigurationFile);
        }
        return null;
    }

    private void addCompileSourceRootIfConfigured() {
        String path = this.outputDir.getPath();
        this.getLog().info((CharSequence)("Added the following path to the source root: " + path));
        this.project.addCompileSourceRoot(path);
    }

    public String[] getGraphqlSchemaPaths() {
        return this.graphqlSchemaPaths;
    }

    public void setGraphqlSchemaPaths(String[] graphqlSchemaPaths) {
        this.graphqlSchemaPaths = graphqlSchemaPaths;
    }

    public SchemaFinderConfig getGraphqlSchemas() {
        return this.graphqlSchemas;
    }

    public void setGraphqlSchemas(SchemaFinderConfig graphqlSchemas) {
        this.graphqlSchemas = graphqlSchemas;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public Map<String, String> getCustomTypesMapping() {
        return this.customTypesMapping;
    }

    public void setCustomTypesMapping(Map<String, String> customTypesMapping) {
        this.customTypesMapping = customTypesMapping;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getApiPackageName() {
        return this.apiPackageName;
    }

    public void setApiPackageName(String apiPackageName) {
        this.apiPackageName = apiPackageName;
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public void setModelPackageName(String modelPackageName) {
        this.modelPackageName = modelPackageName;
    }

    public String getModelNamePrefix() {
        return this.modelNamePrefix;
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        this.modelNamePrefix = modelNamePrefix;
    }

    public String getModelNameSuffix() {
        return this.modelNameSuffix;
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        this.modelNameSuffix = modelNameSuffix;
    }

    public Map<String, String> getCustomAnnotationsMapping() {
        return this.customAnnotationsMapping;
    }

    public void setCustomAnnotationsMapping(Map<String, String> customAnnotationsMapping) {
        this.customAnnotationsMapping = customAnnotationsMapping;
    }

    public String getModelValidationAnnotation() {
        return this.modelValidationAnnotation;
    }

    public void setModelValidationAnnotation(String modelValidationAnnotation) {
        this.modelValidationAnnotation = modelValidationAnnotation;
    }

    public boolean isGenerateApis() {
        return this.generateApis;
    }

    public void setGenerateApis(boolean generateApis) {
        this.generateApis = generateApis;
    }

    public boolean isGenerateEqualsAndHashCode() {
        return this.generateEqualsAndHashCode;
    }

    public void setGenerateEqualsAndHashCode(boolean generateEqualsAndHashCode) {
        this.generateEqualsAndHashCode = generateEqualsAndHashCode;
    }

    public boolean isGenerateToString() {
        return this.generateToString;
    }

    public void setGenerateToString(boolean generateToString) {
        this.generateToString = generateToString;
    }

    public boolean isGenerateAsyncApi() {
        return this.generateAsyncApi;
    }

    public void setGenerateAsyncApi(boolean generateAsyncApi) {
        this.generateAsyncApi = generateAsyncApi;
    }

    public void setJsonConfigurationFile(String jsonConfigurationFile) {
        this.jsonConfigurationFile = jsonConfigurationFile;
    }

    public String getJsonConfigurationFile() {
        return this.jsonConfigurationFile;
    }

    public void setSubscriptionReturnType(String subscriptionReturnType) {
        this.subscriptionReturnType = subscriptionReturnType;
    }

    public String getSubscriptionReturnType() {
        return this.subscriptionReturnType;
    }

    public boolean isGenerateParameterizedFieldsResolvers() {
        return this.generateParameterizedFieldsResolvers;
    }

    public void setGenerateParameterizedFieldsResolvers(boolean generateParameterizedFieldsResolvers) {
        this.generateParameterizedFieldsResolvers = generateParameterizedFieldsResolvers;
    }

    public Set<String> getFieldsWithResolvers() {
        return this.fieldsWithResolvers;
    }

    public void setFieldsWithResolvers(Set<String> fieldsWithResolvers) {
        this.fieldsWithResolvers = fieldsWithResolvers;
    }
}

