/*
 * Decompiled with CFR 0.152.
 */
package io.github.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.GraphQLCodegen;
import com.kobylynskyi.graphql.codegen.model.GraphQLCodegenConfiguration;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.supplier.JsonMappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.supplier.SchemaFinder;
import io.github.kobylynskyi.graphql.codegen.SchemaFinderConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GraphQLCodegenMojo
extends AbstractMojo
implements GraphQLCodegenConfiguration {
    @Parameter
    private String[] graphqlSchemaPaths;
    @Parameter
    private SchemaFinderConfig graphqlSchemas = new SchemaFinderConfig();
    @Parameter(required=true)
    private File outputDir;
    @Parameter
    private Map<String, String> customTypesMapping;
    @Parameter
    private Map<String, String> customAnnotationsMapping;
    @Parameter
    private String packageName;
    @Parameter(defaultValue="true")
    private boolean generateBuilder;
    @Parameter(defaultValue="true")
    private boolean generateApis;
    @Parameter(defaultValue="false")
    private boolean generateEqualsAndHashCode;
    @Parameter(defaultValue="false")
    private boolean generateToString;
    @Parameter
    private String apiPackageName;
    @Parameter
    private String modelPackageName;
    @Parameter
    private String modelNamePrefix;
    @Parameter
    private String modelNameSuffix;
    @Parameter
    private String subscriptionReturnType;
    @Parameter(defaultValue="false")
    private Boolean generateAsyncApi;
    @Parameter(defaultValue="javax.validation.constraints.NotNull")
    private String modelValidationAnnotation;
    @Parameter(defaultValue="true")
    private boolean generateParameterizedFieldsResolvers;
    @Parameter(defaultValue="false")
    private boolean generateExtensionFieldsResolvers;
    @Parameter(defaultValue="false")
    private boolean generateDataFetchingEnvironmentArgumentInApis;
    @Parameter
    private Set<String> fieldsWithResolvers = new HashSet<String>();
    @Parameter
    private Set<String> fieldsWithoutResolvers = new HashSet<String>();
    @Parameter(defaultValue="false")
    private boolean generateRequests;
    @Parameter(defaultValue="Request")
    private String requestSuffix;
    @Parameter(defaultValue="ResponseProjection")
    private String responseProjectionSuffix;
    @Parameter
    private String jsonConfigurationFile;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.addCompileSourceRootIfConfigured();
        MappingConfig mappingConfig = new MappingConfig();
        mappingConfig.setPackageName(this.packageName);
        mappingConfig.setCustomTypesMapping(this.customTypesMapping != null ? this.customTypesMapping : new HashMap());
        mappingConfig.setModelNamePrefix(this.modelNamePrefix);
        mappingConfig.setModelNameSuffix(this.modelNameSuffix);
        mappingConfig.setApiPackageName(this.apiPackageName);
        mappingConfig.setModelPackageName(this.modelPackageName);
        mappingConfig.setGenerateBuilder(Boolean.valueOf(this.generateBuilder));
        mappingConfig.setGenerateApis(Boolean.valueOf(this.generateApis));
        mappingConfig.setModelValidationAnnotation(this.modelValidationAnnotation);
        mappingConfig.setCustomAnnotationsMapping(this.customAnnotationsMapping != null ? this.customAnnotationsMapping : new HashMap());
        mappingConfig.setGenerateEqualsAndHashCode(Boolean.valueOf(this.generateEqualsAndHashCode));
        mappingConfig.setGenerateToString(Boolean.valueOf(this.generateToString));
        mappingConfig.setSubscriptionReturnType(this.subscriptionReturnType);
        mappingConfig.setGenerateAsyncApi(this.generateAsyncApi);
        mappingConfig.setGenerateParameterizedFieldsResolvers(Boolean.valueOf(this.generateParameterizedFieldsResolvers));
        mappingConfig.setGenerateDataFetchingEnvironmentArgumentInApis(Boolean.valueOf(this.generateDataFetchingEnvironmentArgumentInApis));
        mappingConfig.setGenerateExtensionFieldsResolvers(Boolean.valueOf(this.generateExtensionFieldsResolvers));
        mappingConfig.setFieldsWithResolvers(this.fieldsWithResolvers != null ? this.fieldsWithResolvers : new HashSet());
        mappingConfig.setFieldsWithoutResolvers(this.fieldsWithoutResolvers != null ? this.fieldsWithoutResolvers : new HashSet());
        mappingConfig.setGenerateRequests(Boolean.valueOf(this.generateRequests));
        mappingConfig.setRequestSuffix(this.requestSuffix);
        mappingConfig.setResponseProjectionSuffix(this.responseProjectionSuffix);
        MappingConfigSupplier mappingConfigSupplier = this.buildJsonSupplier(this.jsonConfigurationFile);
        try {
            new GraphQLCodegen(this.getSchemas(), this.outputDir, mappingConfig, mappingConfigSupplier).generate();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
    }

    private List<String> getSchemas() throws IOException {
        if (this.graphqlSchemaPaths != null) {
            return Arrays.asList(this.graphqlSchemaPaths);
        }
        Path schemasRootDir = this.getSchemasRootDir();
        SchemaFinder finder = new SchemaFinder(schemasRootDir);
        finder.setRecursive(this.graphqlSchemas.isRecursive());
        finder.setIncludePattern(this.graphqlSchemas.getIncludePattern());
        finder.setExcludedFiles(this.graphqlSchemas.getExcludedFiles());
        return finder.findSchemas();
    }

    private Path getSchemasRootDir() {
        String rootDir = this.graphqlSchemas.getRootDir();
        if (rootDir == null) {
            return this.getDefaultResourcesDirectory().orElseThrow(() -> new IllegalStateException("Default resource folder not found, please provide <rootDir> in <graphqlSchemas>"));
        }
        return Paths.get(rootDir, new String[0]);
    }

    private Optional<Path> getDefaultResourcesDirectory() {
        return this.project.getResources().stream().findFirst().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    private MappingConfigSupplier buildJsonSupplier(String jsonConfigurationFile) {
        if (jsonConfigurationFile != null && !jsonConfigurationFile.isEmpty()) {
            return new JsonMappingConfigSupplier(jsonConfigurationFile);
        }
        return null;
    }

    private void addCompileSourceRootIfConfigured() {
        String path = this.outputDir.getPath();
        this.getLog().info((CharSequence)("Added the following path to the source root: " + path));
        this.project.addCompileSourceRoot(path);
    }

    public String[] getGraphqlSchemaPaths() {
        return this.graphqlSchemaPaths;
    }

    public void setGraphqlSchemaPaths(String[] graphqlSchemaPaths) {
        this.graphqlSchemaPaths = graphqlSchemaPaths;
    }

    public SchemaFinderConfig getGraphqlSchemas() {
        return this.graphqlSchemas;
    }

    public void setGraphqlSchemas(SchemaFinderConfig graphqlSchemas) {
        this.graphqlSchemas = graphqlSchemas;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public Map<String, String> getCustomTypesMapping() {
        return this.customTypesMapping;
    }

    public void setCustomTypesMapping(Map<String, String> customTypesMapping) {
        this.customTypesMapping = customTypesMapping;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getApiPackageName() {
        return this.apiPackageName;
    }

    public void setApiPackageName(String apiPackageName) {
        this.apiPackageName = apiPackageName;
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public void setModelPackageName(String modelPackageName) {
        this.modelPackageName = modelPackageName;
    }

    public String getModelNamePrefix() {
        return this.modelNamePrefix;
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        this.modelNamePrefix = modelNamePrefix;
    }

    public String getModelNameSuffix() {
        return this.modelNameSuffix;
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        this.modelNameSuffix = modelNameSuffix;
    }

    public Map<String, String> getCustomAnnotationsMapping() {
        return this.customAnnotationsMapping;
    }

    public void setCustomAnnotationsMapping(Map<String, String> customAnnotationsMapping) {
        this.customAnnotationsMapping = customAnnotationsMapping;
    }

    public String getModelValidationAnnotation() {
        return this.modelValidationAnnotation;
    }

    public void setModelValidationAnnotation(String modelValidationAnnotation) {
        this.modelValidationAnnotation = modelValidationAnnotation;
    }

    public Boolean getGenerateBuilder() {
        return this.generateBuilder;
    }

    public void setGenerateBuilder(boolean generateBuilder) {
        this.generateBuilder = generateBuilder;
    }

    public Boolean getGenerateApis() {
        return this.generateApis;
    }

    public void setGenerateApis(boolean generateApis) {
        this.generateApis = generateApis;
    }

    public Boolean getGenerateEqualsAndHashCode() {
        return this.generateEqualsAndHashCode;
    }

    public void setGenerateEqualsAndHashCode(boolean generateEqualsAndHashCode) {
        this.generateEqualsAndHashCode = generateEqualsAndHashCode;
    }

    public Boolean getGenerateToString() {
        return this.generateToString;
    }

    public void setGenerateToString(boolean generateToString) {
        this.generateToString = generateToString;
    }

    public Boolean getGenerateAsyncApi() {
        return this.generateAsyncApi;
    }

    public void setGenerateAsyncApi(boolean generateAsyncApi) {
        this.generateAsyncApi = generateAsyncApi;
    }

    public String getSubscriptionReturnType() {
        return this.subscriptionReturnType;
    }

    public void setSubscriptionReturnType(String subscriptionReturnType) {
        this.subscriptionReturnType = subscriptionReturnType;
    }

    public Boolean getGenerateExtensionFieldsResolvers() {
        return this.generateExtensionFieldsResolvers;
    }

    public void setGenerateExtensionFieldsResolvers(boolean generateExtensionFieldsResolvers) {
        this.generateExtensionFieldsResolvers = generateExtensionFieldsResolvers;
    }

    public Boolean getGenerateParameterizedFieldsResolvers() {
        return this.generateParameterizedFieldsResolvers;
    }

    public void setGenerateParameterizedFieldsResolvers(boolean generateParameterizedFieldsResolvers) {
        this.generateParameterizedFieldsResolvers = generateParameterizedFieldsResolvers;
    }

    public Boolean getGenerateDataFetchingEnvironmentArgumentInApis() {
        return this.generateDataFetchingEnvironmentArgumentInApis;
    }

    public void setGenerateDataFetchingEnvironmentArgumentInApis(boolean generateDataFetchingEnvironmentArgumentInApis) {
        this.generateDataFetchingEnvironmentArgumentInApis = generateDataFetchingEnvironmentArgumentInApis;
    }

    public Set<String> getFieldsWithResolvers() {
        return this.fieldsWithResolvers;
    }

    public void setFieldsWithResolvers(Set<String> fieldsWithResolvers) {
        this.fieldsWithResolvers = fieldsWithResolvers;
    }

    public Set<String> getFieldsWithoutResolvers() {
        return this.fieldsWithoutResolvers;
    }

    public void setFieldsWithoutResolvers(Set<String> fieldsWithoutResolvers) {
        this.fieldsWithoutResolvers = fieldsWithoutResolvers;
    }

    public Boolean getGenerateRequests() {
        return this.generateRequests;
    }

    public void setGenerateRequests(boolean generateRequests) {
        this.generateRequests = generateRequests;
    }

    public String getRequestSuffix() {
        return this.requestSuffix;
    }

    public void setRequestSuffix(String requestSuffix) {
        this.requestSuffix = requestSuffix;
    }

    public String getResponseProjectionSuffix() {
        return this.responseProjectionSuffix;
    }

    public void setResponseProjectionSuffix(String responseProjectionSuffix) {
        this.responseProjectionSuffix = responseProjectionSuffix;
    }

    public String getJsonConfigurationFile() {
        return this.jsonConfigurationFile;
    }

    public void setJsonConfigurationFile(String jsonConfigurationFile) {
        this.jsonConfigurationFile = jsonConfigurationFile;
    }
}

