/*
 * Decompiled with CFR 0.152.
 */
package io.github.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.GraphQLCodegen;
import com.kobylynskyi.graphql.codegen.model.ApiInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.ApiNamePrefixStrategy;
import com.kobylynskyi.graphql.codegen.model.ApiRootInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.GraphQLCodegenConfiguration;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.RelayConfig;
import com.kobylynskyi.graphql.codegen.supplier.JsonMappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.supplier.SchemaFinder;
import io.github.kobylynskyi.graphql.codegen.ParentInterfacesConfig;
import io.github.kobylynskyi.graphql.codegen.SchemaFinderConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GraphQLCodegenMojo
extends AbstractMojo
implements GraphQLCodegenConfiguration {
    @Parameter
    private String[] graphqlSchemaPaths;
    @Parameter
    private String graphqlQueryIntrospectionResultPath;
    @Parameter
    private SchemaFinderConfig graphqlSchemas = new SchemaFinderConfig();
    @Parameter(required=true)
    private File outputDir;
    @Parameter
    private Map<String, String> customTypesMapping;
    @Parameter
    private Map<String, String[]> customAnnotationsMapping;
    @Parameter
    private Map<String, String[]> directiveAnnotationsMapping;
    @Parameter
    private String packageName;
    @Parameter(defaultValue="true")
    private boolean generateBuilder;
    @Parameter(defaultValue="true")
    private boolean generateApis;
    @Parameter(defaultValue="false")
    private boolean generateEqualsAndHashCode;
    @Parameter(defaultValue="false")
    private boolean generateImmutableModels;
    @Parameter(defaultValue="false")
    private boolean generateToString;
    @Parameter(defaultValue="3")
    private int responseProjectionMaxDepth;
    @Parameter
    private String apiPackageName;
    @Parameter
    private String apiNamePrefix;
    @Parameter(defaultValue="Resolver")
    private String apiNameSuffix;
    @Parameter
    private String modelPackageName;
    @Parameter
    private String modelNamePrefix;
    @Parameter
    private String modelNameSuffix;
    @Parameter
    private String typeResolverPrefix;
    @Parameter(defaultValue="Resolver")
    private String typeResolverSuffix;
    @Parameter
    private String apiReturnType;
    @Parameter
    private String apiReturnListType;
    @Parameter
    private String subscriptionReturnType;
    @Parameter(defaultValue="SINGLE_INTERFACE")
    private ApiRootInterfaceStrategy apiRootInterfaceStrategy;
    @Parameter(defaultValue="INTERFACE_PER_OPERATION")
    private ApiInterfaceStrategy apiInterfaceStrategy;
    @Parameter(defaultValue="CONSTANT")
    private ApiNamePrefixStrategy apiNamePrefixStrategy;
    @Parameter(defaultValue="javax.validation.constraints.NotNull")
    private String modelValidationAnnotation;
    @Parameter(defaultValue="true")
    private boolean generateParameterizedFieldsResolvers;
    @Parameter(defaultValue="false")
    private boolean generateExtensionFieldsResolvers;
    @Parameter(defaultValue="false")
    private boolean generateDataFetchingEnvironmentArgumentInApis;
    @Parameter(defaultValue="false")
    private boolean generateModelsForRootTypes;
    @Parameter(defaultValue="false")
    private boolean useOptionalForNullableReturnTypes;
    @Parameter
    private String[] fieldsWithResolvers;
    @Parameter
    private String[] fieldsWithoutResolvers;
    @Parameter(defaultValue="false")
    private boolean generateClient;
    @Parameter(defaultValue="Request")
    private String requestSuffix;
    @Parameter(defaultValue="Response")
    private String responseSuffix;
    @Parameter(defaultValue="ResponseProjection")
    private String responseProjectionSuffix;
    @Parameter(defaultValue="ParametrizedInput")
    private String parametrizedInputSuffix;
    @Parameter
    private RelayConfig relayConfig = new RelayConfig();
    @Parameter
    private String jsonConfigurationFile;
    @Parameter
    private ParentInterfacesConfig parentInterfaces = new ParentInterfacesConfig();
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.addCompileSourceRootIfConfigured();
        MappingConfig mappingConfig = new MappingConfig();
        mappingConfig.setPackageName(this.packageName);
        mappingConfig.setCustomTypesMapping(this.customTypesMapping != null ? this.customTypesMapping : new HashMap());
        mappingConfig.setCustomAnnotationsMapping(GraphQLCodegenMojo.convertToListsMap(this.customAnnotationsMapping));
        mappingConfig.setDirectiveAnnotationsMapping(GraphQLCodegenMojo.convertToListsMap(this.directiveAnnotationsMapping));
        mappingConfig.setApiNameSuffix(this.apiNameSuffix);
        mappingConfig.setApiNamePrefix(this.apiNamePrefix);
        mappingConfig.setApiRootInterfaceStrategy(this.apiRootInterfaceStrategy);
        mappingConfig.setApiInterfaceStrategy(this.apiInterfaceStrategy);
        mappingConfig.setApiNamePrefixStrategy(this.apiNamePrefixStrategy);
        mappingConfig.setModelNamePrefix(this.modelNamePrefix);
        mappingConfig.setModelNameSuffix(this.modelNameSuffix);
        mappingConfig.setApiPackageName(this.apiPackageName);
        mappingConfig.setModelPackageName(this.modelPackageName);
        mappingConfig.setGenerateBuilder(Boolean.valueOf(this.generateBuilder));
        mappingConfig.setGenerateApis(Boolean.valueOf(this.generateApis));
        mappingConfig.setTypeResolverSuffix(this.typeResolverSuffix);
        mappingConfig.setTypeResolverPrefix(this.typeResolverPrefix);
        mappingConfig.setModelValidationAnnotation(this.modelValidationAnnotation);
        mappingConfig.setGenerateEqualsAndHashCode(Boolean.valueOf(this.generateEqualsAndHashCode));
        mappingConfig.setGenerateImmutableModels(Boolean.valueOf(this.generateImmutableModels));
        mappingConfig.setGenerateToString(Boolean.valueOf(this.generateToString));
        mappingConfig.setApiReturnType(this.apiReturnType);
        mappingConfig.setApiReturnListType(this.apiReturnListType);
        mappingConfig.setSubscriptionReturnType(this.subscriptionReturnType);
        mappingConfig.setGenerateParameterizedFieldsResolvers(Boolean.valueOf(this.generateParameterizedFieldsResolvers));
        mappingConfig.setGenerateDataFetchingEnvironmentArgumentInApis(Boolean.valueOf(this.generateDataFetchingEnvironmentArgumentInApis));
        mappingConfig.setGenerateExtensionFieldsResolvers(Boolean.valueOf(this.generateExtensionFieldsResolvers));
        mappingConfig.setGenerateModelsForRootTypes(Boolean.valueOf(this.generateModelsForRootTypes));
        mappingConfig.setUseOptionalForNullableReturnTypes(Boolean.valueOf(this.useOptionalForNullableReturnTypes));
        mappingConfig.setFieldsWithResolvers(GraphQLCodegenMojo.mapToHashSet(this.fieldsWithResolvers));
        mappingConfig.setFieldsWithoutResolvers(GraphQLCodegenMojo.mapToHashSet(this.fieldsWithoutResolvers));
        mappingConfig.setGenerateClient(Boolean.valueOf(this.generateClient));
        mappingConfig.setRequestSuffix(this.requestSuffix);
        mappingConfig.setResponseSuffix(this.responseSuffix);
        mappingConfig.setResponseProjectionSuffix(this.responseProjectionSuffix);
        mappingConfig.setParametrizedInputSuffix(this.parametrizedInputSuffix);
        mappingConfig.setResolverParentInterface(this.getResolverParentInterface());
        mappingConfig.setQueryResolverParentInterface(this.getQueryResolverParentInterface());
        mappingConfig.setMutationResolverParentInterface(this.getMutationResolverParentInterface());
        mappingConfig.setSubscriptionResolverParentInterface(this.getSubscriptionResolverParentInterface());
        mappingConfig.setResponseProjectionMaxDepth(this.getResponseProjectionMaxDepth());
        mappingConfig.setRelayConfig(this.relayConfig);
        MappingConfigSupplier mappingConfigSupplier = this.buildJsonSupplier(this.jsonConfigurationFile);
        try {
            new GraphQLCodegen(this.getSchemas(), this.graphqlQueryIntrospectionResultPath, this.outputDir, mappingConfig, mappingConfigSupplier).generate();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
    }

    private List<String> getSchemas() throws IOException {
        if (this.graphqlSchemaPaths != null) {
            return Arrays.asList(this.graphqlSchemaPaths);
        }
        Path schemasRootDir = this.getSchemasRootDir();
        SchemaFinder finder = new SchemaFinder(schemasRootDir);
        finder.setRecursive(this.graphqlSchemas.isRecursive());
        finder.setIncludePattern(this.graphqlSchemas.getIncludePattern());
        finder.setExcludedFiles(this.graphqlSchemas.getExcludedFiles());
        return finder.findSchemas();
    }

    private Path getSchemasRootDir() {
        String rootDir = this.graphqlSchemas.getRootDir();
        if (rootDir == null) {
            return this.getDefaultResourcesDirectory().orElseThrow(() -> new IllegalStateException("Default resource folder not found, please provide <rootDir> in <graphqlSchemas>"));
        }
        return Paths.get(rootDir, new String[0]);
    }

    private Optional<Path> getDefaultResourcesDirectory() {
        return this.project.getResources().stream().findFirst().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    private MappingConfigSupplier buildJsonSupplier(String jsonConfigurationFile) {
        if (jsonConfigurationFile != null && !jsonConfigurationFile.isEmpty()) {
            return new JsonMappingConfigSupplier(jsonConfigurationFile);
        }
        return null;
    }

    private void addCompileSourceRootIfConfigured() {
        String path = this.outputDir.getPath();
        this.getLog().info((CharSequence)("Added the following path to the source root: " + path));
        this.project.addCompileSourceRoot(path);
    }

    public String[] getGraphqlSchemaPaths() {
        return this.graphqlSchemaPaths;
    }

    public void setGraphqlSchemaPaths(String[] graphqlSchemaPaths) {
        this.graphqlSchemaPaths = graphqlSchemaPaths;
    }

    public String getGraphqlQueryIntrospectionResultPath() {
        return this.graphqlQueryIntrospectionResultPath;
    }

    public void setGraphqlQueryIntrospectionResultPath(String graphqlQueryIntrospectionResultPath) {
        this.graphqlQueryIntrospectionResultPath = graphqlQueryIntrospectionResultPath;
    }

    public SchemaFinderConfig getGraphqlSchemas() {
        return this.graphqlSchemas;
    }

    public void setGraphqlSchemas(SchemaFinderConfig graphqlSchemas) {
        this.graphqlSchemas = graphqlSchemas;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public Map<String, String> getCustomTypesMapping() {
        return this.customTypesMapping;
    }

    public void setCustomTypesMapping(Map<String, String> customTypesMapping) {
        this.customTypesMapping = customTypesMapping;
    }

    public Map<String, List<String>> getCustomAnnotationsMapping() {
        return GraphQLCodegenMojo.convertToListsMap(this.customAnnotationsMapping);
    }

    public void setCustomAnnotationsMapping(Map<String, List<String>> customAnnotationsMapping) {
        this.customAnnotationsMapping = GraphQLCodegenMojo.convertToArraysMap(customAnnotationsMapping);
    }

    public Map<String, List<String>> getDirectiveAnnotationsMapping() {
        return GraphQLCodegenMojo.convertToListsMap(this.directiveAnnotationsMapping);
    }

    public void setDirectiveAnnotationsMapping(Map<String, List<String>> directiveAnnotationsMapping) {
        this.directiveAnnotationsMapping = GraphQLCodegenMojo.convertToArraysMap(directiveAnnotationsMapping);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getApiPackageName() {
        return this.apiPackageName;
    }

    public void setApiPackageName(String apiPackageName) {
        this.apiPackageName = apiPackageName;
    }

    public String getApiNamePrefix() {
        return this.apiNamePrefix;
    }

    public void setApiNamePrefix(String apiNamePrefix) {
        this.apiNamePrefix = apiNamePrefix;
    }

    public String getApiNameSuffix() {
        return this.apiNameSuffix;
    }

    public void setApiNameSuffix(String apiNameSuffix) {
        this.apiNameSuffix = apiNameSuffix;
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public void setModelPackageName(String modelPackageName) {
        this.modelPackageName = modelPackageName;
    }

    public String getModelNamePrefix() {
        return this.modelNamePrefix;
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        this.modelNamePrefix = modelNamePrefix;
    }

    public String getModelNameSuffix() {
        return this.modelNameSuffix;
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        this.modelNameSuffix = modelNameSuffix;
    }

    public String getModelValidationAnnotation() {
        return this.modelValidationAnnotation;
    }

    public void setModelValidationAnnotation(String modelValidationAnnotation) {
        this.modelValidationAnnotation = modelValidationAnnotation;
    }

    public Boolean getGenerateBuilder() {
        return this.generateBuilder;
    }

    public void setGenerateBuilder(boolean generateBuilder) {
        this.generateBuilder = generateBuilder;
    }

    public Boolean getGenerateApis() {
        return this.generateApis;
    }

    public void setGenerateApis(boolean generateApis) {
        this.generateApis = generateApis;
    }

    public Boolean getGenerateModelsForRootTypes() {
        return this.generateModelsForRootTypes;
    }

    public void setGenerateModelsForRootTypes(boolean generateModelsForRootTypes) {
        this.generateModelsForRootTypes = generateModelsForRootTypes;
    }

    public Boolean getGenerateEqualsAndHashCode() {
        return this.generateEqualsAndHashCode;
    }

    public void setGenerateEqualsAndHashCode(boolean generateEqualsAndHashCode) {
        this.generateEqualsAndHashCode = generateEqualsAndHashCode;
    }

    public Boolean getGenerateImmutableModels() {
        return this.generateImmutableModels;
    }

    public void setGenerateImmutableModels(boolean generateImmutableModels) {
        this.generateImmutableModels = generateImmutableModels;
    }

    public Boolean getGenerateToString() {
        return this.generateToString;
    }

    public void setGenerateToString(boolean generateToString) {
        this.generateToString = generateToString;
    }

    public String getApiReturnType() {
        return this.apiReturnType;
    }

    public void setApiReturnType(String apiReturnType) {
        this.apiReturnType = apiReturnType;
    }

    public String getApiReturnListType() {
        return this.apiReturnListType;
    }

    public void setApiReturnListType(String apiReturnListType) {
        this.apiReturnListType = apiReturnListType;
    }

    public String getSubscriptionReturnType() {
        return this.subscriptionReturnType;
    }

    public void setSubscriptionReturnType(String subscriptionReturnType) {
        this.subscriptionReturnType = subscriptionReturnType;
    }

    public Boolean getGenerateExtensionFieldsResolvers() {
        return this.generateExtensionFieldsResolvers;
    }

    public void setGenerateExtensionFieldsResolvers(boolean generateExtensionFieldsResolvers) {
        this.generateExtensionFieldsResolvers = generateExtensionFieldsResolvers;
    }

    public Boolean getGenerateParameterizedFieldsResolvers() {
        return this.generateParameterizedFieldsResolvers;
    }

    public void setGenerateParameterizedFieldsResolvers(boolean generateParameterizedFieldsResolvers) {
        this.generateParameterizedFieldsResolvers = generateParameterizedFieldsResolvers;
    }

    public String getTypeResolverPrefix() {
        return this.typeResolverPrefix;
    }

    public void setTypeResolverPrefix(String typeResolverPrefix) {
        this.typeResolverPrefix = typeResolverPrefix;
    }

    public String getTypeResolverSuffix() {
        return this.typeResolverSuffix;
    }

    public void setTypeResolverSuffix(String typeResolverSuffix) {
        this.typeResolverSuffix = typeResolverSuffix;
    }

    public Boolean getGenerateDataFetchingEnvironmentArgumentInApis() {
        return this.generateDataFetchingEnvironmentArgumentInApis;
    }

    public RelayConfig getRelayConfig() {
        return this.relayConfig;
    }

    public void setRelayConfig(RelayConfig relayConfig) {
        this.relayConfig = relayConfig;
    }

    public void setGenerateDataFetchingEnvironmentArgumentInApis(boolean generateDataFetchingEnvironmentArgumentInApis) {
        this.generateDataFetchingEnvironmentArgumentInApis = generateDataFetchingEnvironmentArgumentInApis;
    }

    public Boolean getUseOptionalForNullableReturnTypes() {
        return this.useOptionalForNullableReturnTypes;
    }

    public void setUseOptionalForNullableReturnTypes(boolean useOptionalForNullableReturnTypes) {
        this.useOptionalForNullableReturnTypes = useOptionalForNullableReturnTypes;
    }

    public ApiRootInterfaceStrategy getApiRootInterfaceStrategy() {
        return this.apiRootInterfaceStrategy;
    }

    public void setApiRootInterfaceStrategy(ApiRootInterfaceStrategy apiRootInterfaceStrategy) {
        this.apiRootInterfaceStrategy = apiRootInterfaceStrategy;
    }

    public ApiInterfaceStrategy getApiInterfaceStrategy() {
        return this.apiInterfaceStrategy;
    }

    public void setApiInterfaceStrategy(ApiInterfaceStrategy apiInterfaceStrategy) {
        this.apiInterfaceStrategy = apiInterfaceStrategy;
    }

    public ApiNamePrefixStrategy getApiNamePrefixStrategy() {
        return this.apiNamePrefixStrategy;
    }

    public void setApiNamePrefixStrategy(ApiNamePrefixStrategy apiNamePrefixStrategy) {
        this.apiNamePrefixStrategy = apiNamePrefixStrategy;
    }

    public Set<String> getFieldsWithResolvers() {
        return GraphQLCodegenMojo.mapToHashSet(this.fieldsWithResolvers);
    }

    public void setFieldsWithResolvers(Set<String> fieldsWithResolvers) {
        this.fieldsWithResolvers = GraphQLCodegenMojo.mapToArray(fieldsWithResolvers);
    }

    public Set<String> getFieldsWithoutResolvers() {
        return GraphQLCodegenMojo.mapToHashSet(this.fieldsWithoutResolvers);
    }

    public void setFieldsWithoutResolvers(Set<String> fieldsWithoutResolvers) {
        this.fieldsWithoutResolvers = GraphQLCodegenMojo.mapToArray(fieldsWithoutResolvers);
    }

    public Boolean getGenerateClient() {
        return this.generateClient;
    }

    public void setGenerateClient(boolean generateClient) {
        this.generateClient = generateClient;
    }

    public String getRequestSuffix() {
        return this.requestSuffix;
    }

    public void setRequestSuffix(String requestSuffix) {
        this.requestSuffix = requestSuffix;
    }

    public String getResponseSuffix() {
        return this.responseSuffix;
    }

    public void setResponseSuffix(String responseSuffix) {
        this.responseSuffix = responseSuffix;
    }

    public String getResponseProjectionSuffix() {
        return this.responseProjectionSuffix;
    }

    public void setResponseProjectionSuffix(String responseProjectionSuffix) {
        this.responseProjectionSuffix = responseProjectionSuffix;
    }

    public String getParametrizedInputSuffix() {
        return this.parametrizedInputSuffix;
    }

    public void setParametrizedInputSuffix(String parametrizedInputSuffix) {
        this.parametrizedInputSuffix = parametrizedInputSuffix;
    }

    public ParentInterfacesConfig getParentInterfaces() {
        return this.parentInterfaces;
    }

    public void setParentInterfaces(ParentInterfacesConfig parentInterfaces) {
        this.parentInterfaces = parentInterfaces;
    }

    public String getQueryResolverParentInterface() {
        return this.parentInterfaces.getQueryResolver();
    }

    public String getMutationResolverParentInterface() {
        return this.parentInterfaces.getMutationResolver();
    }

    public String getSubscriptionResolverParentInterface() {
        return this.parentInterfaces.getSubscriptionResolver();
    }

    public String getResolverParentInterface() {
        return this.parentInterfaces.getResolver();
    }

    public String getJsonConfigurationFile() {
        return this.jsonConfigurationFile;
    }

    public void setJsonConfigurationFile(String jsonConfigurationFile) {
        this.jsonConfigurationFile = jsonConfigurationFile;
    }

    public Integer getResponseProjectionMaxDepth() {
        return this.responseProjectionMaxDepth;
    }

    public void setResponseProjectionMaxDepth(int responseProjectionMaxDepth) {
        this.responseProjectionMaxDepth = responseProjectionMaxDepth;
    }

    private static Map<String, List<String>> convertToListsMap(Map<String, String[]> sourceMap) {
        if (sourceMap == null) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, String[]> e : sourceMap.entrySet()) {
            if (e.getValue() == null) continue;
            map.put(e.getKey(), Arrays.asList((Object[])e.getValue()));
        }
        return map;
    }

    private static Map<String, String[]> convertToArraysMap(Map<String, List<String>> sourceMap) {
        if (sourceMap == null) {
            return new HashMap<String, String[]>();
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> e : sourceMap.entrySet()) {
            if (e.getValue() == null) continue;
            map.put(e.getKey(), e.getValue().toArray(new String[0]));
        }
        return map;
    }

    private static Set<String> mapToHashSet(String[] sourceSet) {
        if (sourceSet == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(sourceSet));
    }

    private static String[] mapToArray(Set<String> sourceSet) {
        if (sourceSet == null) {
            return new String[0];
        }
        return sourceSet.toArray(new String[0]);
    }
}

