/*
 * Decompiled with CFR 0.152.
 */
package io.github.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.GraphQLCodegen;
import com.kobylynskyi.graphql.codegen.java.JavaGraphQLCodegen;
import com.kobylynskyi.graphql.codegen.kotlin.KotlinGraphQLCodegen;
import com.kobylynskyi.graphql.codegen.model.ApiInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.ApiNamePrefixStrategy;
import com.kobylynskyi.graphql.codegen.model.ApiRootInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.GeneratedLanguage;
import com.kobylynskyi.graphql.codegen.model.GraphQLCodegenConfiguration;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.RelayConfig;
import com.kobylynskyi.graphql.codegen.model.exception.LanguageNotSupportedException;
import com.kobylynskyi.graphql.codegen.scala.ScalaGraphQLCodegen;
import com.kobylynskyi.graphql.codegen.supplier.JsonMappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.supplier.SchemaFinder;
import io.github.kobylynskyi.graphql.codegen.ParentInterfacesConfig;
import io.github.kobylynskyi.graphql.codegen.SchemaFinderConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class GraphQLCodegenMojo
extends AbstractMojo
implements GraphQLCodegenConfiguration {
    @Parameter
    private String[] graphqlSchemaPaths;
    @Parameter
    private String graphqlQueryIntrospectionResultPath;
    @Parameter
    private SchemaFinderConfig graphqlSchemas = new SchemaFinderConfig();
    @Parameter(required=true)
    private File outputDir;
    @Parameter
    private Properties customTypesMapping = new Properties();
    @Parameter
    private Map<String, Properties> customAnnotationsMapping;
    @Parameter
    private Map<String, Properties> directiveAnnotationsMapping;
    @Parameter
    private String packageName;
    @Parameter(defaultValue="true")
    private boolean generateBuilder;
    @Parameter(defaultValue="true")
    private boolean generateApis;
    @Parameter(defaultValue="false")
    private boolean generateEqualsAndHashCode;
    @Parameter(defaultValue="false")
    private boolean generateImmutableModels;
    @Parameter(defaultValue="false")
    private boolean generateToString;
    @Parameter
    private String apiPackageName;
    @Parameter
    private String apiNamePrefix;
    @Parameter(defaultValue="Resolver")
    private String apiNameSuffix;
    @Parameter
    private String modelPackageName;
    @Parameter
    private String modelNamePrefix;
    @Parameter
    private String modelNameSuffix;
    @Parameter
    private String typeResolverPrefix;
    @Parameter(defaultValue="Resolver")
    private String typeResolverSuffix;
    @Parameter
    private String apiReturnType;
    @Parameter
    private String apiReturnListType;
    @Parameter
    private String subscriptionReturnType;
    @Parameter(defaultValue="SINGLE_INTERFACE")
    private ApiRootInterfaceStrategy apiRootInterfaceStrategy;
    @Parameter(defaultValue="INTERFACE_PER_OPERATION")
    private ApiInterfaceStrategy apiInterfaceStrategy;
    @Parameter(defaultValue="CONSTANT")
    private ApiNamePrefixStrategy apiNamePrefixStrategy;
    @Parameter(defaultValue="javax.validation.constraints.NotNull")
    private String modelValidationAnnotation;
    @Parameter(defaultValue="true")
    private boolean generateParameterizedFieldsResolvers;
    @Parameter(defaultValue="false")
    private boolean generateExtensionFieldsResolvers;
    @Parameter(defaultValue="false")
    private boolean generateDataFetchingEnvironmentArgumentInApis;
    @Parameter(defaultValue="false")
    private boolean generateModelsForRootTypes;
    @Parameter(defaultValue="false")
    private boolean useOptionalForNullableReturnTypes;
    @Parameter(defaultValue="true")
    private boolean generateApisWithThrowsException;
    @Parameter
    private String[] fieldsWithResolvers;
    @Parameter
    private String[] fieldsWithoutResolvers;
    @Parameter
    private RelayConfig relayConfig = new RelayConfig();
    @Parameter(defaultValue="false")
    private boolean generateClient;
    @Parameter(defaultValue="Request")
    private String requestSuffix;
    @Parameter(defaultValue="Response")
    private String responseSuffix;
    @Parameter(defaultValue="ResponseProjection")
    private String responseProjectionSuffix;
    @Parameter(defaultValue="ParametrizedInput")
    private String parametrizedInputSuffix;
    @Parameter
    private String[] useObjectMapperForRequestSerialization;
    @Parameter(defaultValue="3")
    private int responseProjectionMaxDepth;
    @Parameter
    private ParentInterfacesConfig parentInterfaces = new ParentInterfacesConfig();
    @Parameter(defaultValue="JAVA")
    private GeneratedLanguage generatedLanguage;
    @Parameter
    private String jsonConfigurationFile;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.addCompileSourceRootIfConfigured();
        MappingConfig mappingConfig = new MappingConfig();
        mappingConfig.setPackageName(this.packageName);
        mappingConfig.setCustomTypesMapping(GraphQLCodegenMojo.convertToMap(this.customTypesMapping));
        mappingConfig.setCustomAnnotationsMapping(GraphQLCodegenMojo.convertToListsMap(this.customAnnotationsMapping));
        mappingConfig.setDirectiveAnnotationsMapping(GraphQLCodegenMojo.convertToListsMap(this.directiveAnnotationsMapping));
        mappingConfig.setApiNameSuffix(this.apiNameSuffix);
        mappingConfig.setApiNamePrefix(this.apiNamePrefix);
        mappingConfig.setApiRootInterfaceStrategy(this.apiRootInterfaceStrategy);
        mappingConfig.setApiInterfaceStrategy(this.apiInterfaceStrategy);
        mappingConfig.setApiNamePrefixStrategy(this.apiNamePrefixStrategy);
        mappingConfig.setModelNamePrefix(this.modelNamePrefix);
        mappingConfig.setModelNameSuffix(this.modelNameSuffix);
        mappingConfig.setApiPackageName(this.apiPackageName);
        mappingConfig.setModelPackageName(this.modelPackageName);
        mappingConfig.setGenerateBuilder(Boolean.valueOf(this.generateBuilder));
        mappingConfig.setGenerateApis(Boolean.valueOf(this.generateApis));
        mappingConfig.setTypeResolverSuffix(this.typeResolverSuffix);
        mappingConfig.setTypeResolverPrefix(this.typeResolverPrefix);
        mappingConfig.setModelValidationAnnotation(this.modelValidationAnnotation);
        mappingConfig.setGenerateEqualsAndHashCode(Boolean.valueOf(this.generateEqualsAndHashCode));
        mappingConfig.setGenerateImmutableModels(Boolean.valueOf(this.generateImmutableModels));
        mappingConfig.setGenerateToString(Boolean.valueOf(this.generateToString));
        mappingConfig.setApiReturnType(this.apiReturnType);
        mappingConfig.setApiReturnListType(this.apiReturnListType);
        mappingConfig.setSubscriptionReturnType(this.subscriptionReturnType);
        mappingConfig.setGenerateParameterizedFieldsResolvers(Boolean.valueOf(this.generateParameterizedFieldsResolvers));
        mappingConfig.setGenerateDataFetchingEnvironmentArgumentInApis(Boolean.valueOf(this.generateDataFetchingEnvironmentArgumentInApis));
        mappingConfig.setGenerateExtensionFieldsResolvers(Boolean.valueOf(this.generateExtensionFieldsResolvers));
        mappingConfig.setGenerateModelsForRootTypes(Boolean.valueOf(this.generateModelsForRootTypes));
        mappingConfig.setUseOptionalForNullableReturnTypes(Boolean.valueOf(this.useOptionalForNullableReturnTypes));
        mappingConfig.setGenerateApisWithThrowsException(Boolean.valueOf(this.generateApisWithThrowsException));
        mappingConfig.setFieldsWithResolvers(GraphQLCodegenMojo.mapToHashSet(this.fieldsWithResolvers));
        mappingConfig.setFieldsWithoutResolvers(GraphQLCodegenMojo.mapToHashSet(this.fieldsWithoutResolvers));
        mappingConfig.setRelayConfig(this.relayConfig);
        mappingConfig.setGenerateClient(Boolean.valueOf(this.generateClient));
        mappingConfig.setRequestSuffix(this.requestSuffix);
        mappingConfig.setResponseSuffix(this.responseSuffix);
        mappingConfig.setResponseProjectionSuffix(this.responseProjectionSuffix);
        mappingConfig.setParametrizedInputSuffix(this.parametrizedInputSuffix);
        mappingConfig.setResponseProjectionMaxDepth(Integer.valueOf(this.responseProjectionMaxDepth));
        mappingConfig.setUseObjectMapperForRequestSerialization(GraphQLCodegenMojo.mapToHashSet(this.useObjectMapperForRequestSerialization));
        mappingConfig.setResolverParentInterface(this.getResolverParentInterface());
        mappingConfig.setQueryResolverParentInterface(this.getQueryResolverParentInterface());
        mappingConfig.setMutationResolverParentInterface(this.getMutationResolverParentInterface());
        mappingConfig.setSubscriptionResolverParentInterface(this.getSubscriptionResolverParentInterface());
        mappingConfig.setGeneratedLanguage(this.generatedLanguage);
        try {
            this.instantiateCodegen(mappingConfig).generate();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
    }

    private GraphQLCodegen instantiateCodegen(MappingConfig mappingConfig) throws IOException {
        switch (this.generatedLanguage) {
            case JAVA: {
                return new JavaGraphQLCodegen(this.getSchemas(), this.graphqlQueryIntrospectionResultPath, this.outputDir, mappingConfig, this.buildJsonSupplier(this.jsonConfigurationFile));
            }
            case SCALA: {
                return new ScalaGraphQLCodegen(this.getSchemas(), this.graphqlQueryIntrospectionResultPath, this.outputDir, mappingConfig, this.buildJsonSupplier(this.jsonConfigurationFile));
            }
            case KOTLIN: {
                return new KotlinGraphQLCodegen(this.getSchemas(), this.graphqlQueryIntrospectionResultPath, this.outputDir, mappingConfig, this.buildJsonSupplier(this.jsonConfigurationFile));
            }
        }
        throw new LanguageNotSupportedException(this.generatedLanguage);
    }

    private List<String> getSchemas() throws IOException {
        if (this.graphqlSchemaPaths != null) {
            return Arrays.asList(this.graphqlSchemaPaths);
        }
        Path schemasRootDir = this.getSchemasRootDir();
        SchemaFinder finder = new SchemaFinder(schemasRootDir);
        finder.setRecursive(this.graphqlSchemas.isRecursive());
        finder.setIncludePattern(this.graphqlSchemas.getIncludePattern());
        finder.setExcludedFiles(this.graphqlSchemas.getExcludedFiles());
        return finder.findSchemas();
    }

    private Path getSchemasRootDir() {
        String rootDir = this.graphqlSchemas.getRootDir();
        if (rootDir == null) {
            return this.getDefaultResourcesDirectory().orElseThrow(() -> new IllegalStateException("Default resource folder not found, please provide <rootDir> in <graphqlSchemas>"));
        }
        return Paths.get(rootDir, new String[0]);
    }

    private Optional<Path> getDefaultResourcesDirectory() {
        return this.project.getResources().stream().findFirst().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    private MappingConfigSupplier buildJsonSupplier(String jsonConfigurationFile) {
        if (jsonConfigurationFile != null && !jsonConfigurationFile.isEmpty()) {
            return new JsonMappingConfigSupplier(jsonConfigurationFile);
        }
        return null;
    }

    private void addCompileSourceRootIfConfigured() {
        String path = this.outputDir.getPath();
        this.getLog().info((CharSequence)("Added the following path to the source root: " + path));
        this.project.addCompileSourceRoot(path);
    }

    public String[] getGraphqlSchemaPaths() {
        return this.graphqlSchemaPaths;
    }

    public String getGraphqlQueryIntrospectionResultPath() {
        return this.graphqlQueryIntrospectionResultPath;
    }

    public SchemaFinderConfig getGraphqlSchemas() {
        return this.graphqlSchemas;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public Map<String, String> getCustomTypesMapping() {
        return GraphQLCodegenMojo.convertToMap(this.customTypesMapping);
    }

    public Map<String, List<String>> getCustomAnnotationsMapping() {
        return GraphQLCodegenMojo.convertToListsMap(this.customAnnotationsMapping);
    }

    public Map<String, List<String>> getDirectiveAnnotationsMapping() {
        return GraphQLCodegenMojo.convertToListsMap(this.directiveAnnotationsMapping);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getApiPackageName() {
        return this.apiPackageName;
    }

    public String getApiNamePrefix() {
        return this.apiNamePrefix;
    }

    public String getApiNameSuffix() {
        return this.apiNameSuffix;
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public String getModelNamePrefix() {
        return this.modelNamePrefix;
    }

    public String getModelNameSuffix() {
        return this.modelNameSuffix;
    }

    public String getModelValidationAnnotation() {
        return this.modelValidationAnnotation;
    }

    public Boolean getGenerateBuilder() {
        return this.generateBuilder;
    }

    public Boolean getGenerateApis() {
        return this.generateApis;
    }

    public Boolean getGenerateModelsForRootTypes() {
        return this.generateModelsForRootTypes;
    }

    public Boolean getGenerateEqualsAndHashCode() {
        return this.generateEqualsAndHashCode;
    }

    public Boolean getGenerateImmutableModels() {
        return this.generateImmutableModels;
    }

    public Boolean getGenerateToString() {
        return this.generateToString;
    }

    public String getApiReturnType() {
        return this.apiReturnType;
    }

    public String getApiReturnListType() {
        return this.apiReturnListType;
    }

    public String getSubscriptionReturnType() {
        return this.subscriptionReturnType;
    }

    public Boolean getGenerateExtensionFieldsResolvers() {
        return this.generateExtensionFieldsResolvers;
    }

    public Boolean getGenerateParameterizedFieldsResolvers() {
        return this.generateParameterizedFieldsResolvers;
    }

    public String getTypeResolverPrefix() {
        return this.typeResolverPrefix;
    }

    public String getTypeResolverSuffix() {
        return this.typeResolverSuffix;
    }

    public Boolean getGenerateDataFetchingEnvironmentArgumentInApis() {
        return this.generateDataFetchingEnvironmentArgumentInApis;
    }

    public RelayConfig getRelayConfig() {
        return this.relayConfig;
    }

    public Boolean getUseOptionalForNullableReturnTypes() {
        return this.useOptionalForNullableReturnTypes;
    }

    public Boolean getGenerateApisWithThrowsException() {
        return this.generateApisWithThrowsException;
    }

    public ApiRootInterfaceStrategy getApiRootInterfaceStrategy() {
        return this.apiRootInterfaceStrategy;
    }

    public ApiInterfaceStrategy getApiInterfaceStrategy() {
        return this.apiInterfaceStrategy;
    }

    public ApiNamePrefixStrategy getApiNamePrefixStrategy() {
        return this.apiNamePrefixStrategy;
    }

    public Set<String> getFieldsWithResolvers() {
        return GraphQLCodegenMojo.mapToHashSet(this.fieldsWithResolvers);
    }

    public Set<String> getFieldsWithoutResolvers() {
        return GraphQLCodegenMojo.mapToHashSet(this.fieldsWithoutResolvers);
    }

    public Integer getResponseProjectionMaxDepth() {
        return this.responseProjectionMaxDepth;
    }

    public Boolean getGenerateClient() {
        return this.generateClient;
    }

    public String getRequestSuffix() {
        return this.requestSuffix;
    }

    public String getResponseSuffix() {
        return this.responseSuffix;
    }

    public String getResponseProjectionSuffix() {
        return this.responseProjectionSuffix;
    }

    public String getParametrizedInputSuffix() {
        return this.parametrizedInputSuffix;
    }

    public Set<String> getUseObjectMapperForRequestSerialization() {
        return GraphQLCodegenMojo.mapToHashSet(this.useObjectMapperForRequestSerialization);
    }

    public String getQueryResolverParentInterface() {
        return this.parentInterfaces.getQueryResolver();
    }

    public String getMutationResolverParentInterface() {
        return this.parentInterfaces.getMutationResolver();
    }

    public String getSubscriptionResolverParentInterface() {
        return this.parentInterfaces.getSubscriptionResolver();
    }

    public String getResolverParentInterface() {
        return this.parentInterfaces.getResolver();
    }

    public GeneratedLanguage getGeneratedLanguage() {
        return this.generatedLanguage;
    }

    public ParentInterfacesConfig getParentInterfaces() {
        return this.parentInterfaces;
    }

    public String getJsonConfigurationFile() {
        return this.jsonConfigurationFile;
    }

    private static Map<String, List<String>> convertToListsMap(Map<String, Properties> sourceMap) {
        if (sourceMap == null) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(sourceMap.size());
        for (Map.Entry<String, Properties> e : sourceMap.entrySet()) {
            if (e.getValue() == null) continue;
            Collection<Object> values = e.getValue().values();
            ArrayList<String> stringValues = new ArrayList<String>(values.size());
            for (Object value : values) {
                stringValues.add(value.toString());
            }
            map.put(e.getKey(), stringValues);
        }
        return map;
    }

    private static Set<String> mapToHashSet(String[] sourceSet) {
        if (sourceSet == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(sourceSet));
    }

    private static Map<String, String> convertToMap(Properties properties) {
        if (properties == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        for (String name : properties.stringPropertyNames()) {
            result.put(name, properties.getProperty(name));
        }
        return result;
    }
}

