/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.FreeMarkerTemplatesRegistry;
import com.kobylynskyi.graphql.codegen.GraphqlCodegenFileCreator;
import com.kobylynskyi.graphql.codegen.GraphqlDocumentParser;
import com.kobylynskyi.graphql.codegen.mapper.EnumDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToRequestDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionsToResolverDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.InterfaceDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.TypeDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.UnionDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.DefinitionTypeDeterminer;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.UnsupportedGraphqlDefinitionException;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import freemarker.template.TemplateException;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.UnionTypeDefinition;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GraphqlCodegen {
    private List<String> schemas;
    private File outputDir;
    private MappingConfig mappingConfig;
    private MappingConfig result;

    public GraphqlCodegen(List<String> schemas, File outputDir, MappingConfig mappingConfig) {
        this(schemas, outputDir, mappingConfig, null);
    }

    public GraphqlCodegen(List<String> schemas, File outputDir, MappingConfig mappingConfig, MappingConfigSupplier externalMappingConfigSupplier) {
        this.schemas = schemas;
        this.outputDir = outputDir;
        this.mappingConfig = mappingConfig;
        this.mappingConfig.combine(externalMappingConfigSupplier != null ? (MappingConfig)externalMappingConfigSupplier.get() : null);
        this.initDefaultValues(mappingConfig);
    }

    private void initDefaultValues(MappingConfig mappingConfig) {
        if (mappingConfig.getModelValidationAnnotation() == null) {
            mappingConfig.setModelValidationAnnotation("javax.validation.constraints.NotNull");
        }
        if (mappingConfig.getGenerateBuilder() == null) {
            mappingConfig.setGenerateBuilder(true);
        }
        if (mappingConfig.getGenerateEqualsAndHashCode() == null) {
            mappingConfig.setGenerateEqualsAndHashCode(false);
        }
        if (mappingConfig.getGenerateRequests() == null) {
            mappingConfig.setGenerateRequests(false);
        }
        if (mappingConfig.getRequestSuffix() == null) {
            mappingConfig.setRequestSuffix("Request");
        }
        if (mappingConfig.getResponseProjectionSuffix() == null) {
            mappingConfig.setResponseProjectionSuffix("ResponseProjection");
        }
        if (mappingConfig.getGenerateToString() == null) {
            mappingConfig.setGenerateToString(false);
        }
        if (mappingConfig.getGenerateApis() == null) {
            mappingConfig.setGenerateApis(true);
        }
        if (mappingConfig.getGenerateParameterizedFieldsResolvers() == null) {
            mappingConfig.setGenerateParameterizedFieldsResolvers(true);
        }
        if (mappingConfig.getGenerateDataFetchingEnvironmentArgumentInApis() == null) {
            mappingConfig.setGenerateDataFetchingEnvironmentArgumentInApis(false);
        }
        if (mappingConfig.getGenerateRequests().booleanValue()) {
            mappingConfig.setGenerateToString(true);
        }
    }

    public void generate() throws Exception {
        GraphqlCodegenFileCreator.prepareOutputDir(this.outputDir);
        long startTime = System.currentTimeMillis();
        if (!this.schemas.isEmpty()) {
            Document document = GraphqlDocumentParser.getDocument(this.schemas);
            this.initCustomTypeMappings(document);
            this.processDocument(document);
        }
        long elapsed = System.currentTimeMillis() - startTime;
        System.out.println(String.format("Finished processing %d schema(s) in %d ms", this.schemas.size(), elapsed));
    }

    private void processDocument(Document document) throws IOException, TemplateException {
        Set<String> typeNames = GraphqlCodegen.getAllTypeNames(document);
        for (Definition definition : document.getDefinitions()) {
            try {
                this.processDefinition(document, definition, typeNames);
            }
            catch (UnsupportedGraphqlDefinitionException unsupportedGraphqlDefinitionException) {}
        }
        System.out.println(String.format("Generated %d definitions in folder '%s'", document.getDefinitions().size(), this.outputDir.getAbsolutePath()));
    }

    private void processDefinition(Document document, Definition<?> definition, Set<String> typeNames) throws IOException, TemplateException {
        switch (DefinitionTypeDeterminer.determine(definition)) {
            case OPERATION: {
                this.generateOperation((ObjectTypeDefinition)definition);
                break;
            }
            case TYPE: {
                this.generateType((ObjectTypeDefinition)definition, document, typeNames);
                this.generateFieldResolvers((ObjectTypeDefinition)definition);
                break;
            }
            case INTERFACE: {
                this.generateInterface((InterfaceTypeDefinition)definition);
                break;
            }
            case ENUM: {
                this.generateEnum((EnumTypeDefinition)definition);
                break;
            }
            case INPUT: {
                this.generateInput((InputObjectTypeDefinition)definition);
                break;
            }
            case UNION: {
                this.generateUnion((UnionTypeDefinition)definition);
            }
        }
    }

    private void generateUnion(UnionTypeDefinition definition) throws IOException, TemplateException {
        Map<String, Object> dataModel = UnionDefinitionToDataModelMapper.map(this.mappingConfig, definition);
        GraphqlCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.unionTemplate, dataModel, this.outputDir);
    }

    private void generateInterface(InterfaceTypeDefinition definition) throws IOException, TemplateException {
        Map<String, Object> dataModel = InterfaceDefinitionToDataModelMapper.map(this.mappingConfig, definition);
        GraphqlCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.interfaceTemplate, dataModel, this.outputDir);
    }

    private void generateOperation(ObjectTypeDefinition definition) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(this.mappingConfig.getGenerateApis())) {
            for (FieldDefinition operationDef : definition.getFieldDefinitions()) {
                Map<String, Object> dataModel = FieldDefinitionsToResolverDataModelMapper.mapRootTypeField(this.mappingConfig, operationDef, definition.getName());
                GraphqlCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.operationsTemplate, dataModel, this.outputDir);
            }
            Map<String, Object> dataModel = FieldDefinitionsToResolverDataModelMapper.mapRootTypeFields(this.mappingConfig, definition);
            GraphqlCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.operationsTemplate, dataModel, this.outputDir);
        }
        if (Boolean.TRUE.equals(this.mappingConfig.getGenerateRequests())) {
            for (FieldDefinition operationDef : definition.getFieldDefinitions()) {
                Map<String, Object> requestDataModel = FieldDefinitionToRequestDataModelMapper.map(this.mappingConfig, operationDef, definition.getName());
                GraphqlCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.requestTemplate, requestDataModel, this.outputDir);
            }
        }
    }

    private void generateType(ObjectTypeDefinition definition, Document document, Set<String> typeNames) throws IOException, TemplateException {
        Map<String, Object> dataModel = TypeDefinitionToDataModelMapper.map(this.mappingConfig, definition, document);
        GraphqlCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.typeTemplate, dataModel, this.outputDir);
        if (Boolean.TRUE.equals(this.mappingConfig.getGenerateRequests())) {
            Map<String, Object> responseProjDataModel = TypeDefinitionToDataModelMapper.mapResponseProjection(this.mappingConfig, definition, document, typeNames);
            GraphqlCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.responseProjectionTemplate, responseProjDataModel, this.outputDir);
        }
    }

    private void generateFieldResolvers(ObjectTypeDefinition definition) throws IOException, TemplateException {
        List<FieldDefinition> fieldDefsWithResolvers = definition.getFieldDefinitions().stream().filter(fieldDef -> FieldDefinitionToParameterMapper.generateResolversForField(this.mappingConfig, fieldDef, definition.getName())).collect(Collectors.toList());
        if (!fieldDefsWithResolvers.isEmpty()) {
            Map<String, Object> dataModel = FieldDefinitionsToResolverDataModelMapper.mapToTypeResolver(this.mappingConfig, fieldDefsWithResolvers, definition.getName());
            GraphqlCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.operationsTemplate, dataModel, this.outputDir);
        }
    }

    private void generateInput(InputObjectTypeDefinition definition) throws IOException, TemplateException {
        Map<String, Object> dataModel = InputDefinitionToDataModelMapper.map(this.mappingConfig, definition);
        GraphqlCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.typeTemplate, dataModel, this.outputDir);
    }

    private static Set<String> getAllTypeNames(Document document) {
        return document.getDefinitionsOfType(ObjectTypeDefinition.class).stream().filter(typeDef -> !Utils.isGraphqlOperation(typeDef.getName())).map(ObjectTypeDefinition::getName).collect(Collectors.toSet());
    }

    private void generateEnum(EnumTypeDefinition definition) throws IOException, TemplateException {
        Map<String, Object> dataModel = EnumDefinitionToDataModelMapper.map(this.mappingConfig, definition);
        GraphqlCodegenFileCreator.generateFile(FreeMarkerTemplatesRegistry.enumTemplate, dataModel, this.outputDir);
    }

    private void initCustomTypeMappings(Document document) {
        for (Definition definition : document.getDefinitions()) {
            if (!(definition instanceof ScalarTypeDefinition)) continue;
            String scalarName = ((ScalarTypeDefinition)definition).getName();
            this.mappingConfig.putCustomTypeMappingIfAbsent(scalarName, "String");
        }
        this.mappingConfig.putCustomTypeMappingIfAbsent("ID", "String");
        this.mappingConfig.putCustomTypeMappingIfAbsent("String", "String");
        this.mappingConfig.putCustomTypeMappingIfAbsent("Int", "Integer");
        this.mappingConfig.putCustomTypeMappingIfAbsent("Float", "Double");
        this.mappingConfig.putCustomTypeMappingIfAbsent("Boolean", "Boolean");
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public MappingConfig getMappingConfig() {
        return this.mappingConfig;
    }

    public MappingConfig getResult() {
        return this.result;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setMappingConfig(MappingConfig mappingConfig) {
        this.mappingConfig = mappingConfig;
    }

    public void setResult(MappingConfig result) {
        this.result = result;
    }
}

