/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.utils.Utils;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.util.Map;

class GraphqlCodegenFileCreator {
    private static final String EXTENSION = ".java";

    GraphqlCodegenFileCreator() {
    }

    static void generateFile(Template template, Map<String, Object> dataModel, File outputDir) throws IOException, TemplateException {
        String fileName = dataModel.get("className") + EXTENSION;
        File fileOutputDir = GraphqlCodegenFileCreator.getFileTargetDirectory(dataModel, outputDir);
        File javaSourceFile = new File(fileOutputDir, fileName);
        boolean fileCreated = javaSourceFile.createNewFile();
        if (!fileCreated) {
            throw new FileAlreadyExistsException("File already exists: " + javaSourceFile.getPath());
        }
        template.process(dataModel, (Writer)new FileWriter(javaSourceFile));
    }

    static void prepareOutputDir(File outputDir) throws IOException {
        Utils.deleteDir(outputDir);
        Utils.createDirIfAbsent(outputDir);
    }

    private static File getFileTargetDirectory(Map<String, Object> dataModel, File outputDir) throws IOException {
        Object packageName = dataModel.get("package");
        File targetDir = packageName != null && !Utils.isBlank(packageName.toString()) ? new File(outputDir, packageName.toString().replace(".", File.separator)) : outputDir;
        Utils.createDirIfAbsent(targetDir);
        return targetDir;
    }
}

