/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.GraphqlDocumentParser;
import com.kobylynskyi.graphql.codegen.model.SchemaValidationException;
import graphql.GraphQLException;
import java.io.IOException;
import java.util.List;

public class GraphqlCodegenValidate {
    private final List<String> schemas;

    public void validate() throws IOException {
        for (String schema : this.schemas) {
            try {
                long startTime = System.currentTimeMillis();
                GraphqlDocumentParser.getDocument(schema);
                System.out.println(String.format("Validated schema '%s' in %d ms", schema, System.currentTimeMillis() - startTime));
            }
            catch (GraphQLException e) {
                throw new SchemaValidationException(e.getMessage());
            }
        }
    }

    public GraphqlCodegenValidate(List<String> schemas) {
        this.schemas = schemas;
    }
}

