/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultValueMapper {
    public static String map(Value<?> defaultValue, Type<?> graphQLType) {
        if (defaultValue instanceof NullValue) {
            return DefaultValueMapper.mapNullValue();
        }
        if (defaultValue instanceof BooleanValue) {
            return DefaultValueMapper.mapBoolean((BooleanValue)defaultValue);
        }
        if (defaultValue instanceof IntValue) {
            return DefaultValueMapper.mapInt((IntValue)defaultValue);
        }
        if (defaultValue instanceof FloatValue) {
            return DefaultValueMapper.mapFloat((FloatValue)defaultValue);
        }
        if (defaultValue instanceof StringValue) {
            return DefaultValueMapper.mapString((StringValue)defaultValue);
        }
        if (defaultValue instanceof EnumValue) {
            return DefaultValueMapper.mapEnum(graphQLType, (EnumValue)defaultValue);
        }
        if (defaultValue instanceof ObjectValue) {
            return DefaultValueMapper.mapObject((ObjectValue)defaultValue);
        }
        if (defaultValue instanceof ArrayValue) {
            return DefaultValueMapper.mapArray((ArrayValue)defaultValue, graphQLType);
        }
        return null;
    }

    private static String mapNullValue() {
        return "null";
    }

    private static String mapBoolean(BooleanValue defaultValue) {
        return defaultValue.isValue() ? "true" : "false";
    }

    private static String mapInt(IntValue defaultValue) {
        return String.valueOf(defaultValue.getValue());
    }

    private static String mapFloat(FloatValue defaultValue) {
        return String.valueOf(defaultValue.getValue());
    }

    private static String mapString(StringValue defaultValue) {
        return "\"" + defaultValue.getValue() + "\"";
    }

    private static String mapEnum(Type<?> graphQLType, EnumValue defaultValue) {
        if (graphQLType instanceof TypeName) {
            return ((TypeName)graphQLType).getName() + "." + defaultValue.getName();
        }
        if (graphQLType instanceof NonNullType) {
            return DefaultValueMapper.mapEnum(((NonNullType)graphQLType).getType(), defaultValue);
        }
        throw new IllegalArgumentException("Unexpected Enum default value for list type");
    }

    private static String mapObject(ObjectValue defaultValue) {
        return null;
    }

    private static String mapArray(ArrayValue defaultValue, Type<?> graphQLType) {
        if (!(graphQLType instanceof ListType)) {
            throw new IllegalArgumentException("Unexpected array default value for non-list type");
        }
        List values = defaultValue.getValues();
        if (values.isEmpty()) {
            return "Collections.emptyList()";
        }
        Type elementType = ((ListType)graphQLType).getType();
        return values.stream().map(v -> DefaultValueMapper.map(v, elementType)).collect(Collectors.joining(", ", "Arrays.asList(", ")"));
    }
}

