/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.NamedNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EnumDefinitionToDataModelMapper {
    public static Map<String, Object> map(MappingConfig mappingConfig, EnumTypeDefinition enumDef) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        String packageName = MapperUtils.getModelPackageName(mappingConfig);
        dataModel.put("package", packageName);
        dataModel.put("imports", MapperUtils.getImports(mappingConfig, packageName));
        dataModel.put("className", MapperUtils.getClassNameWithPrefixAndSuffix(mappingConfig, (NamedNode)enumDef));
        dataModel.put("fields", EnumDefinitionToDataModelMapper.map(enumDef.getEnumValueDefinitions()));
        return dataModel;
    }

    private static List<String> map(List<EnumValueDefinition> enumValueDefinitions) {
        return enumValueDefinitions.stream().map(EnumValueDefinition::getName).map(MapperUtils::capitalizeIfRestricted).collect(Collectors.toList());
    }
}

