/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.ProjectionParameterDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.FieldDefinition;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FieldDefinitionToParameterMapper {
    public static List<ParameterDefinition> mapFields(MappingConfig mappingConfig, List<FieldDefinition> fieldDefinitions, String parentTypeName) {
        return fieldDefinitions.stream().filter(fieldDef -> !FieldDefinitionToParameterMapper.generateResolversForField(mappingConfig, fieldDef, parentTypeName)).map(fieldDef -> FieldDefinitionToParameterMapper.mapField(mappingConfig, fieldDef, parentTypeName)).collect(Collectors.toList());
    }

    public static List<ProjectionParameterDefinition> mapProjectionFields(MappingConfig mappingConfig, List<FieldDefinition> fieldDefinitions, String parentTypeName, Set<String> typeNames) {
        return fieldDefinitions.stream().map(fieldDef -> FieldDefinitionToParameterMapper.mapProjectionField(mappingConfig, fieldDef, parentTypeName, typeNames)).collect(Collectors.toList());
    }

    private static ParameterDefinition mapField(MappingConfig mappingConfig, FieldDefinition fieldDef, String parentTypeName) {
        ParameterDefinition parameter = new ParameterDefinition();
        parameter.setName(MapperUtils.capitalizeIfRestricted(fieldDef.getName()));
        parameter.setType(GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, fieldDef.getType(), fieldDef.getName(), parentTypeName));
        parameter.setAnnotations(GraphqlTypeToJavaTypeMapper.getAnnotations(mappingConfig, fieldDef.getType(), fieldDef.getName(), parentTypeName, false));
        return parameter;
    }

    private static ProjectionParameterDefinition mapProjectionField(MappingConfig mappingConfig, FieldDefinition fieldDef, String parentTypeName, Set<String> typeNames) {
        ProjectionParameterDefinition parameter = new ProjectionParameterDefinition();
        parameter.setName(MapperUtils.capitalizeIfRestricted(fieldDef.getName()));
        String nestedType = GraphqlTypeToJavaTypeMapper.getNestedTypeName(fieldDef.getType());
        if (typeNames.contains(nestedType)) {
            parameter.setType(nestedType + mappingConfig.getResponseProjectionSuffix());
        }
        return parameter;
    }

    public static boolean generateResolversForField(MappingConfig mappingConfig, FieldDefinition fieldDef, String parentTypeName) {
        boolean resolverForParamField = mappingConfig.getGenerateParameterizedFieldsResolvers() != false && !Utils.isEmpty(fieldDef.getInputValueDefinitions());
        boolean resolverForSpecificField = mappingConfig.getFieldsWithResolvers().contains(parentTypeName + "." + fieldDef.getName());
        return resolverForParamField || resolverForSpecificField;
    }
}

