/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputValueDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.OperationDefinition;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FieldDefinitionsToResolverDataModelMapper {
    public static Map<String, Object> mapToTypeResolver(MappingConfig mappingConfig, List<FieldDefinition> fieldDefs, String parentTypeName) {
        String className = parentTypeName + "Resolver";
        return FieldDefinitionsToResolverDataModelMapper.mapToResolverModel(mappingConfig, parentTypeName, className, fieldDefs);
    }

    public static Map<String, Object> mapRootTypeField(MappingConfig mappingConfig, FieldDefinition fieldDefinition, String rootTypeName) {
        String className = Utils.capitalize(fieldDefinition.getName()) + rootTypeName;
        List<FieldDefinition> fieldDefs = Collections.singletonList(fieldDefinition);
        return FieldDefinitionsToResolverDataModelMapper.mapToResolverModel(mappingConfig, rootTypeName, className, fieldDefs);
    }

    public static Map<String, Object> mapRootTypeFields(MappingConfig mappingConfig, ObjectTypeDefinition rootTypeDefinition) {
        String parentTypeName = rootTypeDefinition.getName();
        String className = Utils.capitalize(parentTypeName);
        List fieldDefinitions = rootTypeDefinition.getFieldDefinitions();
        return FieldDefinitionsToResolverDataModelMapper.mapToResolverModel(mappingConfig, parentTypeName, className, fieldDefinitions);
    }

    private static Map<String, Object> mapToResolverModel(MappingConfig mappingConfig, String parentTypeName, String className, List<FieldDefinition> fieldDefinitions) {
        String packageName = MapperUtils.getApiPackageName(mappingConfig);
        Set<String> imports = MapperUtils.getImportsForFieldResolvers(mappingConfig, packageName, parentTypeName);
        List<OperationDefinition> operations = FieldDefinitionsToResolverDataModelMapper.mapToOperations(mappingConfig, fieldDefinitions, parentTypeName);
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", packageName);
        dataModel.put("imports", imports);
        dataModel.put("className", className);
        dataModel.put("operations", operations);
        return dataModel;
    }

    private static List<OperationDefinition> mapToOperations(MappingConfig mappingConfig, List<FieldDefinition> fieldDefinitions, String parentTypeName) {
        return fieldDefinitions.stream().map(fieldDef -> FieldDefinitionsToResolverDataModelMapper.map(mappingConfig, fieldDef, parentTypeName)).collect(Collectors.toList());
    }

    private static OperationDefinition map(MappingConfig mappingConfig, FieldDefinition resolvedField, String parentTypeName) {
        String javaType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, resolvedField.getType(), resolvedField.getName(), parentTypeName);
        OperationDefinition operation = new OperationDefinition();
        operation.setName(resolvedField.getName());
        operation.setType(GraphqlTypeToJavaTypeMapper.wrapIntoAsyncIfRequired(mappingConfig, javaType, parentTypeName));
        operation.setAnnotations(GraphqlTypeToJavaTypeMapper.getAnnotations(mappingConfig, resolvedField.getType(), resolvedField.getName(), parentTypeName));
        operation.setParameters(FieldDefinitionsToResolverDataModelMapper.getOperationParameters(mappingConfig, resolvedField, parentTypeName));
        return operation;
    }

    private static List<ParameterDefinition> getOperationParameters(MappingConfig mappingConfig, FieldDefinition resolvedField, String parentTypeName) {
        ArrayList<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>();
        if (!Utils.isGraphqlOperation(parentTypeName)) {
            String parentObjectParamType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, (Type)new TypeName(parentTypeName));
            String parentObjectParamName = MapperUtils.capitalizeIfRestricted(Utils.uncapitalize(parentObjectParamType));
            parameters.add(new ParameterDefinition(parentObjectParamType, parentObjectParamName, null, Collections.emptyList()));
        }
        parameters.addAll(InputValueDefinitionToParameterMapper.map(mappingConfig, resolvedField.getInputValueDefinitions(), resolvedField.getName()));
        if (mappingConfig.getGenerateDataFetchingEnvironmentArgumentInApis().booleanValue()) {
            parameters.add(ParameterDefinition.DATA_FETCHING_ENVIRONMENT);
        }
        return parameters;
    }
}

