/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class GraphqlTypeToJavaTypeMapper {
    GraphqlTypeToJavaTypeMapper() {
    }

    static String getJavaType(MappingConfig mappingConfig, Type type) {
        return GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, type, null, null);
    }

    static String getJavaType(MappingConfig mappingConfig, String graphqlTypeName) {
        return GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, graphqlTypeName, null, null);
    }

    static String getJavaType(MappingConfig mappingConfig, Type graphqlType, String name, String parentTypeName) {
        if (graphqlType instanceof TypeName) {
            return GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, ((TypeName)graphqlType).getName(), name, parentTypeName);
        }
        if (graphqlType instanceof ListType) {
            String mappedCollectionType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, ((ListType)graphqlType).getType(), name, parentTypeName);
            return GraphqlTypeToJavaTypeMapper.wrapIntoJavaCollection(mappedCollectionType);
        }
        if (graphqlType instanceof NonNullType) {
            return GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, ((NonNullType)graphqlType).getType(), name, parentTypeName);
        }
        return null;
    }

    static String getNestedTypeName(Type graphqlType) {
        if (graphqlType instanceof TypeName) {
            return ((TypeName)graphqlType).getName();
        }
        if (graphqlType instanceof ListType) {
            return GraphqlTypeToJavaTypeMapper.getNestedTypeName(((ListType)graphqlType).getType());
        }
        if (graphqlType instanceof NonNullType) {
            return GraphqlTypeToJavaTypeMapper.getNestedTypeName(((NonNullType)graphqlType).getType());
        }
        return null;
    }

    private static String getJavaType(MappingConfig mappingConfig, String graphlType, String name, String parentTypeName) {
        Map<String, String> customTypesMapping = mappingConfig.getCustomTypesMapping();
        if (name != null && parentTypeName != null && customTypesMapping.containsKey(parentTypeName + "." + name)) {
            return customTypesMapping.get(parentTypeName + "." + name);
        }
        if (customTypesMapping.containsKey(graphlType)) {
            return customTypesMapping.get(graphlType);
        }
        return MapperUtils.getClassNameWithPrefixAndSuffix(mappingConfig, graphlType);
    }

    static List<String> getAnnotations(MappingConfig mappingConfig, Type graphlType, String name, String parentTypeName) {
        return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingConfig, graphlType, name, parentTypeName, false);
    }

    static List<String> getAnnotations(MappingConfig mappingConfig, Type type, String name, String parentTypeName, boolean mandatory) {
        if (type instanceof TypeName) {
            return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingConfig, ((TypeName)type).getName(), name, parentTypeName, mandatory);
        }
        if (type instanceof ListType) {
            return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingConfig, ((ListType)type).getType(), name, parentTypeName, mandatory);
        }
        if (type instanceof NonNullType) {
            return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingConfig, ((NonNullType)type).getType(), name, parentTypeName, true);
        }
        return null;
    }

    private static List<String> getAnnotations(MappingConfig mappingConfig, String graphlType, String name, String parentTypeName, boolean mandatory) {
        String modelValidationAnnotation;
        ArrayList<String> annotations = new ArrayList<String>();
        if (mandatory && !Utils.isBlank(modelValidationAnnotation = mappingConfig.getModelValidationAnnotation())) {
            annotations.add(modelValidationAnnotation);
        }
        Map<String, String> customAnnotationsMapping = mappingConfig.getCustomAnnotationsMapping();
        if (name != null && parentTypeName != null && customAnnotationsMapping.containsKey(parentTypeName + "." + name)) {
            annotations.add(customAnnotationsMapping.get(parentTypeName + "." + name));
        } else if (customAnnotationsMapping.containsKey(graphlType)) {
            annotations.add(customAnnotationsMapping.get(graphlType));
        }
        return annotations;
    }

    private static String wrapIntoJavaCollection(String type) {
        return String.format("Collection<%s>", type);
    }

    private static String wrapIntoJavaCompletableFuture(String type) {
        return String.format("CompletableFuture<%s>", type);
    }

    static String wrapIntoAsyncIfRequired(MappingConfig mappingConfig, String javaTypeName, String parentTypeName) {
        if (MapperUtils.shouldUseAsyncMethods(mappingConfig, parentTypeName)) {
            return GraphqlTypeToJavaTypeMapper.wrapIntoJavaCompletableFuture(javaTypeName);
        }
        return GraphqlTypeToJavaTypeMapper.wrapIntoSubscriptionIfRequired(mappingConfig, javaTypeName, parentTypeName);
    }

    private static String wrapIntoSubscriptionIfRequired(MappingConfig mappingConfig, String javaTypeName, String parentTypeName) {
        if (parentTypeName.equalsIgnoreCase(GraphQLOperation.SUBSCRIPTION.name()) && !Utils.isBlank(mappingConfig.getSubscriptionReturnType())) {
            return String.format("%s<%s>", mappingConfig.getSubscriptionReturnType(), javaTypeName);
        }
        return javaTypeName;
    }
}

