/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.DefaultValueMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import graphql.language.InputValueDefinition;
import java.util.List;
import java.util.stream.Collectors;

public class InputValueDefinitionToParameterMapper {
    public static List<ParameterDefinition> map(MappingConfig mappingConfig, List<InputValueDefinition> valueDefinitions, String parentTypeName) {
        return valueDefinitions.stream().map(inputValueDef -> InputValueDefinitionToParameterMapper.map(mappingConfig, inputValueDef, parentTypeName)).collect(Collectors.toList());
    }

    private static ParameterDefinition map(MappingConfig mappingConfig, InputValueDefinition inputValueDefinition, String parentTypeName) {
        ParameterDefinition parameter = new ParameterDefinition();
        parameter.setName(MapperUtils.capitalizeIfRestricted(inputValueDefinition.getName()));
        parameter.setType(GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, inputValueDefinition.getType()));
        parameter.setDefaultValue(DefaultValueMapper.map(inputValueDefinition.getDefaultValue(), inputValueDefinition.getType()));
        parameter.setAnnotations(GraphqlTypeToJavaTypeMapper.getAnnotations(mappingConfig, inputValueDefinition.getType(), inputValueDefinition.getName(), parentTypeName));
        return parameter;
    }
}

