/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Document;
import graphql.language.NamedNode;
import graphql.language.UnionTypeDefinition;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MapperUtils {
    private static final Set<String> JAVA_RESTRICTED_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));

    static String capitalizeIfRestricted(String fieldName) {
        if (JAVA_RESTRICTED_KEYWORDS.contains(fieldName)) {
            return Utils.capitalize(fieldName);
        }
        return fieldName;
    }

    static List<String> getUnionsHavingType(MappingConfig mappingConfig, NamedNode definition, Document document) {
        return document.getDefinitions().stream().filter(def -> def instanceof UnionTypeDefinition).map(def -> (UnionTypeDefinition)def).filter(union -> MapperUtils.isDefinitionPartOfUnion(definition, union)).map(UnionTypeDefinition::getName).map(unionName -> MapperUtils.getClassNameWithPrefixAndSuffix(mappingConfig, unionName)).collect(Collectors.toList());
    }

    private static boolean isDefinitionPartOfUnion(NamedNode definition, UnionTypeDefinition union) {
        return union.getMemberTypes().stream().filter(member -> member instanceof NamedNode).map(member -> (NamedNode)member).anyMatch(member -> member.getName().equals(definition.getName()));
    }

    static String getClassNameWithPrefixAndSuffix(MappingConfig mappingConfig, NamedNode definition) {
        return MapperUtils.getClassNameWithPrefixAndSuffix(mappingConfig, definition.getName());
    }

    static String getClassNameWithPrefixAndSuffix(MappingConfig mappingConfig, String definitionName) {
        StringBuilder classNameBuilder = new StringBuilder();
        if (!Utils.isBlank(mappingConfig.getModelNamePrefix())) {
            classNameBuilder.append(mappingConfig.getModelNamePrefix());
        }
        classNameBuilder.append(Utils.capitalize(definitionName));
        if (!Utils.isBlank(mappingConfig.getModelNameSuffix())) {
            classNameBuilder.append(mappingConfig.getModelNameSuffix());
        }
        return classNameBuilder.toString();
    }

    static String getApiPackageName(MappingConfig mappingConfig) {
        if (!Utils.isBlank(mappingConfig.getApiPackageName())) {
            return mappingConfig.getApiPackageName();
        }
        return mappingConfig.getPackageName();
    }

    static String getModelPackageName(MappingConfig mappingConfig) {
        if (!Utils.isBlank(mappingConfig.getModelPackageName())) {
            return mappingConfig.getModelPackageName();
        }
        return mappingConfig.getPackageName();
    }

    static Set<String> getImports(MappingConfig mappingConfig, String packageName) {
        String genericPackageName;
        String apiPackageName;
        HashSet<String> imports = new HashSet<String>();
        String modelPackageName = mappingConfig.getModelPackageName();
        if (!Utils.isBlank(modelPackageName) && !modelPackageName.equals(packageName)) {
            imports.add(modelPackageName);
        }
        if (!Utils.isBlank(apiPackageName = mappingConfig.getApiPackageName()) && !apiPackageName.equals(packageName)) {
            imports.add(apiPackageName);
        }
        if (!Utils.isBlank(genericPackageName = mappingConfig.getPackageName()) && !genericPackageName.equals(packageName)) {
            imports.add(genericPackageName);
        }
        imports.add("java.util");
        return imports;
    }

    static Set<String> getImportsForFieldResolvers(MappingConfig mappingConfig, String packageName, String objectTypeName) {
        Set<String> imports = MapperUtils.getImports(mappingConfig, packageName);
        if (mappingConfig.getGenerateDataFetchingEnvironmentArgumentInApis().booleanValue()) {
            imports.add("graphql.schema");
        }
        if (MapperUtils.shouldUseAsyncMethods(mappingConfig, objectTypeName)) {
            imports.add("java.util.concurrent");
        }
        return imports;
    }

    static Set<String> getImportsForRequests(MappingConfig mappingConfig, String packageName) {
        Set<String> imports = MapperUtils.getImports(mappingConfig, packageName);
        imports.add(GraphQLOperation.class.getPackage().getName());
        return imports;
    }

    static boolean shouldUseAsyncMethods(MappingConfig mappingConfig, String typeName) {
        boolean isAsyncApi = mappingConfig.getGenerateAsyncApi() != null && mappingConfig.getGenerateAsyncApi() != false;
        return isAsyncApi && !GraphQLOperation.SUBSCRIPTION.name().equalsIgnoreCase(typeName);
    }
}

