/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.ProjectionParameterDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Document;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.NamedNode;
import graphql.language.ObjectTypeDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeDefinitionToDataModelMapper {
    public static Map<String, Object> map(MappingConfig mappingConfig, ObjectTypeDefinition typeDefinition, Document document) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        String packageName = MapperUtils.getModelPackageName(mappingConfig);
        dataModel.put("package", packageName);
        dataModel.put("imports", MapperUtils.getImports(mappingConfig, packageName));
        dataModel.put("className", MapperUtils.getClassNameWithPrefixAndSuffix(mappingConfig, (NamedNode)typeDefinition));
        LinkedHashSet<String> allInterfaces = new LinkedHashSet<String>(MapperUtils.getUnionsHavingType(mappingConfig, (NamedNode)typeDefinition, document));
        typeDefinition.getImplements().stream().map(anImplement -> GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, anImplement)).forEach(allInterfaces::add);
        dataModel.put("implements", allInterfaces);
        dataModel.put("fields", TypeDefinitionToDataModelMapper.getFields(mappingConfig, typeDefinition, document));
        dataModel.put("builder", mappingConfig.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingConfig.getGenerateEqualsAndHashCode());
        dataModel.put("toString", mappingConfig.getGenerateToString());
        dataModel.put("toStringEscapeJson", mappingConfig.getGenerateRequests());
        return dataModel;
    }

    public static Map<String, Object> mapResponseProjection(MappingConfig mappingConfig, ObjectTypeDefinition typeDefinition, Document document, Set<String> typeNames) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        String packageName = MapperUtils.getModelPackageName(mappingConfig);
        dataModel.put("package", packageName);
        dataModel.put("imports", MapperUtils.getImportsForRequests(mappingConfig, packageName));
        dataModel.put("className", Utils.capitalize(typeDefinition.getName()) + mappingConfig.getResponseProjectionSuffix());
        dataModel.put("fields", TypeDefinitionToDataModelMapper.getProjectionFields(mappingConfig, typeDefinition, document, typeNames));
        dataModel.put("builder", mappingConfig.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingConfig.getGenerateEqualsAndHashCode());
        return dataModel;
    }

    private static Set<ParameterDefinition> getFields(MappingConfig mappingConfig, ObjectTypeDefinition typeDefinition, Document document) {
        LinkedHashSet<ParameterDefinition> allParameters = new LinkedHashSet<ParameterDefinition>();
        allParameters.addAll(FieldDefinitionToParameterMapper.mapFields(mappingConfig, typeDefinition.getFieldDefinitions(), typeDefinition.getName()));
        List<InterfaceTypeDefinition> interfaces = TypeDefinitionToDataModelMapper.getInterfacesOfType(mappingConfig, typeDefinition, document);
        interfaces.stream().map(i -> FieldDefinitionToParameterMapper.mapFields(mappingConfig, i.getFieldDefinitions(), i.getName())).forEach(allParameters::addAll);
        return allParameters;
    }

    private static Set<ProjectionParameterDefinition> getProjectionFields(MappingConfig mappingConfig, ObjectTypeDefinition typeDefinition, Document document, Set<String> typeNames) {
        LinkedHashSet<ProjectionParameterDefinition> allParameters = new LinkedHashSet<ProjectionParameterDefinition>();
        allParameters.addAll(FieldDefinitionToParameterMapper.mapProjectionFields(mappingConfig, typeDefinition.getFieldDefinitions(), typeDefinition.getName(), typeNames));
        List<InterfaceTypeDefinition> interfaces = TypeDefinitionToDataModelMapper.getInterfacesOfType(mappingConfig, typeDefinition, document);
        interfaces.stream().map(i -> FieldDefinitionToParameterMapper.mapProjectionFields(mappingConfig, i.getFieldDefinitions(), i.getName(), typeNames)).forEach(allParameters::addAll);
        return allParameters;
    }

    private static List<InterfaceTypeDefinition> getInterfacesOfType(MappingConfig mappingConfig, ObjectTypeDefinition definition, Document document) {
        if (definition.getImplements().isEmpty()) {
            return Collections.emptyList();
        }
        Set typeImplements = definition.getImplements().stream().map(type -> GraphqlTypeToJavaTypeMapper.getJavaType(mappingConfig, type)).collect(Collectors.toSet());
        return document.getDefinitions().stream().filter(def -> def instanceof InterfaceTypeDefinition).map(def -> (InterfaceTypeDefinition)def).filter(def -> typeImplements.contains(def.getName())).collect(Collectors.toList());
    }
}

