/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model;

import com.kobylynskyi.graphql.codegen.model.GraphqlDefinitionType;
import com.kobylynskyi.graphql.codegen.model.UnsupportedGraphqlDefinitionException;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Definition;
import graphql.language.DirectiveDefinition;
import graphql.language.EnumTypeDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.UnionTypeDefinition;
import lombok.NonNull;

public class DefinitionTypeDeterminer {
    public static GraphqlDefinitionType determine(@NonNull Definition definition) {
        if (definition == null) {
            throw new NullPointerException("definition is marked non-null but is null");
        }
        if (definition instanceof ObjectTypeDefinition) {
            ObjectTypeDefinition typeDef = (ObjectTypeDefinition)definition;
            if (Utils.isGraphqlOperation(typeDef.getName())) {
                return GraphqlDefinitionType.OPERATION;
            }
            return GraphqlDefinitionType.TYPE;
        }
        if (definition instanceof EnumTypeDefinition) {
            return GraphqlDefinitionType.ENUM;
        }
        if (definition instanceof InputObjectTypeDefinition) {
            return GraphqlDefinitionType.INPUT;
        }
        if (definition instanceof SchemaDefinition) {
            return GraphqlDefinitionType.SCHEMA;
        }
        if (definition instanceof UnionTypeDefinition) {
            return GraphqlDefinitionType.UNION;
        }
        if (definition instanceof ScalarTypeDefinition) {
            return GraphqlDefinitionType.SCALAR;
        }
        if (definition instanceof InterfaceTypeDefinition) {
            return GraphqlDefinitionType.INTERFACE;
        }
        if (definition instanceof DirectiveDefinition) {
            return GraphqlDefinitionType.DIRECTIVE;
        }
        throw new UnsupportedGraphqlDefinitionException(definition);
    }
}

