/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.graphql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLRequest;
import com.kobylynskyi.graphql.codegen.model.graphql.UnableToBuildJsonQueryException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public class GraphQLRequestSerializer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String serialize(GraphQLRequest graphQLRequest) {
        if (graphQLRequest == null || graphQLRequest.getRequest() == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(graphQLRequest.getRequest().getOperationType().name().toLowerCase());
        builder.append(" { ");
        builder.append(graphQLRequest.getRequest().getOperationName());
        Map<String, Object> input = graphQLRequest.getRequest().getInput();
        if (input != null && !input.isEmpty()) {
            builder.append("(");
            Iterator<Map.Entry<String, Object>> inputEntryIterator = input.entrySet().iterator();
            while (inputEntryIterator.hasNext()) {
                Map.Entry<String, Object> inputEntry = inputEntryIterator.next();
                if (inputEntry.getValue() != null) {
                    builder.append(inputEntry.getKey());
                    builder.append(": ");
                    builder.append(GraphQLRequestSerializer.getEntry(inputEntry.getValue()));
                }
                if (!inputEntryIterator.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(")");
        }
        if (graphQLRequest.getResponseProjection() != null) {
            builder.append(graphQLRequest.getResponseProjection().toString());
        }
        builder.append(" }");
        return GraphQLRequestSerializer.buildJsonQuery(builder.toString());
    }

    private static String buildJsonQuery(String queryString) {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put("query", queryString);
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)objectNode);
        }
        catch (JsonProcessingException e) {
            throw new UnableToBuildJsonQueryException((Exception)((Object)e));
        }
    }

    private static String getEntry(Object input) {
        if (input instanceof Collection) {
            Collection inputCollection = (Collection)input;
            return inputCollection.stream().map(GraphQLRequestSerializer::getEntry).collect(Collectors.joining(", ", "[ ", " ]"));
        }
        if (input instanceof Enum) {
            return input.toString();
        }
        if (input instanceof String) {
            return "\"" + GraphQLRequestSerializer.escapeJsonString(input.toString()) + "\"";
        }
        return input.toString();
    }

    public static String escapeJsonString(String stringValue) {
        int len = stringValue.length();
        StringBuilder sb = new StringBuilder(len);
        block9: for (int i = 0; i < len; ++i) {
            char ch = stringValue.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

