/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.utils;

import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;

public final class Utils {
    private Utils() {
    }

    public static boolean isGraphqlOperation(String typeDef) {
        String typeDefNormalized = typeDef.toUpperCase();
        return typeDefNormalized.equals(GraphQLOperation.QUERY.name()) || typeDefNormalized.equals(GraphQLOperation.MUTATION.name()) || typeDefNormalized.equals(GraphQLOperation.SUBSCRIPTION.name());
    }

    public static String capitalize(String aString) {
        char[] chars = aString.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String uncapitalize(String aString) {
        char[] chars = aString.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getFileContent(String filePath) throws IOException {
        return new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }

    public static void deleteDir(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File subFile : files) {
                if (subFile.isDirectory()) {
                    Utils.deleteDir(subFile);
                    continue;
                }
                Files.delete(subFile.toPath());
            }
        }
        Files.delete(dir.toPath());
    }

    public static void createDirIfAbsent(File dir) throws IOException {
        if (dir.exists()) {
            return;
        }
        boolean outputDirCreated = dir.mkdirs();
        if (!outputDirCreated) {
            throw new IOException("Unable to create output directory");
        }
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }
}

