/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDocument;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedEnumTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInputObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedScalarTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedUnionTypeDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.NamedNode;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.parser.MultiSourceReader;
import graphql.parser.Parser;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

class GraphQLDocumentParser {
    private static final Parser GRAPHQL_PARSER = new Parser();

    private GraphQLDocumentParser() {
    }

    static ExtendedDocument getDocument(MappingConfig mappingConfig, List<String> schemaPaths) throws IOException {
        Document document = GraphQLDocumentParser.readDocument(schemaPaths);
        ExtendedDocumentBuilder extendedDocumentBuilder = new ExtendedDocumentBuilder();
        for (Definition definition : document.getDefinitions()) {
            GraphQLDocumentParser.processDefinition(mappingConfig, extendedDocumentBuilder, definition);
        }
        return extendedDocumentBuilder.build();
    }

    private static void processDefinition(MappingConfig mappingConfig, ExtendedDocumentBuilder extendedDocumentBuilder, Definition<?> definition) {
        if (!(definition instanceof NamedNode)) {
            return;
        }
        String definitionName = ((NamedNode)definition).getName();
        if (definition instanceof ObjectTypeDefinition) {
            if (Utils.isGraphqlOperation(definitionName)) {
                GraphQLDocumentParser.populateDefinition(extendedDocumentBuilder.operationDefinitions, definition, definitionName, ObjectTypeExtensionDefinition.class, s -> new ExtendedObjectTypeDefinition());
                if (Boolean.TRUE.equals(mappingConfig.getGenerateModelsForRootTypes())) {
                    GraphQLDocumentParser.populateDefinition(extendedDocumentBuilder.typeDefinitions, definition, definitionName, ObjectTypeExtensionDefinition.class, s -> new ExtendedObjectTypeDefinition());
                }
            } else {
                GraphQLDocumentParser.populateDefinition(extendedDocumentBuilder.typeDefinitions, definition, definitionName, ObjectTypeExtensionDefinition.class, s -> new ExtendedObjectTypeDefinition());
            }
        } else if (definition instanceof EnumTypeDefinition) {
            GraphQLDocumentParser.populateDefinition(extendedDocumentBuilder.enumDefinitions, definition, definitionName, EnumTypeExtensionDefinition.class, s -> new ExtendedEnumTypeDefinition());
        } else if (definition instanceof InputObjectTypeDefinition) {
            GraphQLDocumentParser.populateDefinition(extendedDocumentBuilder.inputDefinitions, definition, definitionName, InputObjectTypeExtensionDefinition.class, s -> new ExtendedInputObjectTypeDefinition());
        } else if (definition instanceof UnionTypeDefinition) {
            GraphQLDocumentParser.populateDefinition(extendedDocumentBuilder.unionDefinitions, definition, definitionName, UnionTypeExtensionDefinition.class, s -> new ExtendedUnionTypeDefinition());
        } else if (definition instanceof ScalarTypeDefinition) {
            GraphQLDocumentParser.populateDefinition(extendedDocumentBuilder.scalarDefinitions, definition, definitionName, ScalarTypeExtensionDefinition.class, s -> new ExtendedScalarTypeDefinition());
        } else if (definition instanceof InterfaceTypeDefinition) {
            GraphQLDocumentParser.populateDefinition(extendedDocumentBuilder.interfaceDefinitions, definition, definitionName, InterfaceTypeExtensionDefinition.class, s -> new ExtendedInterfaceTypeDefinition());
        }
    }

    private static <D extends ExtendedDefinition<B, E>, B extends NamedNode<B>, E extends B> void populateDefinition(Map<String, D> definitionsMap, Definition<?> definition, String definitionName, Class<E> extensionDefinitionClass, Function<String, D> mappingFunction) {
        ExtendedDefinition extendedDefinition = (ExtendedDefinition)definitionsMap.computeIfAbsent(definitionName, mappingFunction);
        if (extensionDefinitionClass.isAssignableFrom(definition.getClass())) {
            extendedDefinition.getExtensions().add((NamedNode)definition);
        } else {
            extendedDefinition.setDefinition((NamedNode)definition);
        }
    }

    private static Document readDocument(List<String> schemaPaths) throws IOException {
        try (MultiSourceReader reader = GraphQLDocumentParser.createMultiSourceReader(schemaPaths);){
            Document document = GRAPHQL_PARSER.parseDocument((Reader)reader);
            return document;
        }
    }

    public static MultiSourceReader createMultiSourceReader(List<String> schemaPaths) throws IOException {
        if (schemaPaths == null) {
            return MultiSourceReader.newMultiSourceReader().build();
        }
        MultiSourceReader.Builder builder = MultiSourceReader.newMultiSourceReader();
        for (String path : schemaPaths) {
            String content = Utils.getFileContent(path) + System.lineSeparator();
            builder.string(content, path);
        }
        return builder.trackData(true).build();
    }

    private static class ExtendedDocumentBuilder {
        private final Map<String, ExtendedObjectTypeDefinition> operationDefinitions = new HashMap<String, ExtendedObjectTypeDefinition>();
        private final Map<String, ExtendedObjectTypeDefinition> typeDefinitions = new HashMap<String, ExtendedObjectTypeDefinition>();
        private final Map<String, ExtendedInputObjectTypeDefinition> inputDefinitions = new HashMap<String, ExtendedInputObjectTypeDefinition>();
        private final Map<String, ExtendedEnumTypeDefinition> enumDefinitions = new HashMap<String, ExtendedEnumTypeDefinition>();
        private final Map<String, ExtendedScalarTypeDefinition> scalarDefinitions = new HashMap<String, ExtendedScalarTypeDefinition>();
        private final Map<String, ExtendedInterfaceTypeDefinition> interfaceDefinitions = new HashMap<String, ExtendedInterfaceTypeDefinition>();
        private final Map<String, ExtendedUnionTypeDefinition> unionDefinitions = new HashMap<String, ExtendedUnionTypeDefinition>();

        private ExtendedDocumentBuilder() {
        }

        ExtendedDocument build() {
            return new ExtendedDocument(this.operationDefinitions.values(), this.typeDefinitions.values(), this.inputDefinitions.values(), this.enumDefinitions.values(), this.scalarDefinitions.values(), this.interfaceDefinitions.values(), this.unionDefinitions.values());
        }
    }
}

