/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultValueMapper {
    private static final String NULL_STRING = "null";

    private DefaultValueMapper() {
    }

    public static String map(MappingContext mappingContext, Value<?> defaultValue, Type<?> graphQLType) {
        if (defaultValue instanceof NullValue) {
            return NULL_STRING;
        }
        if (defaultValue instanceof BooleanValue) {
            return DefaultValueMapper.mapBoolean((BooleanValue)defaultValue);
        }
        if (defaultValue instanceof IntValue) {
            return DefaultValueMapper.mapInt((IntValue)defaultValue);
        }
        if (defaultValue instanceof FloatValue) {
            return DefaultValueMapper.mapFloat((FloatValue)defaultValue);
        }
        if (defaultValue instanceof StringValue) {
            return DefaultValueMapper.mapString((StringValue)defaultValue);
        }
        if (defaultValue instanceof EnumValue) {
            return DefaultValueMapper.mapEnum(mappingContext, graphQLType, (EnumValue)defaultValue);
        }
        if (defaultValue instanceof ObjectValue) {
            return null;
        }
        if (defaultValue instanceof ArrayValue) {
            return DefaultValueMapper.mapArray(mappingContext, graphQLType, (ArrayValue)defaultValue);
        }
        return null;
    }

    private static String mapBoolean(BooleanValue defaultValue) {
        return defaultValue.isValue() ? "true" : "false";
    }

    private static String mapInt(IntValue defaultValue) {
        return String.valueOf(defaultValue.getValue());
    }

    private static String mapFloat(FloatValue defaultValue) {
        return String.valueOf(defaultValue.getValue());
    }

    private static String mapString(StringValue defaultValue) {
        return "\"" + defaultValue.getValue() + "\"";
    }

    private static String mapEnum(MappingContext mappingContext, Type<?> graphQLType, EnumValue defaultValue) {
        if (graphQLType instanceof TypeName) {
            String typeName = ((TypeName)graphQLType).getName();
            typeName = MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, typeName);
            return typeName + "." + defaultValue.getName();
        }
        if (graphQLType instanceof NonNullType) {
            return DefaultValueMapper.mapEnum(mappingContext, ((NonNullType)graphQLType).getType(), defaultValue);
        }
        throw new IllegalArgumentException("Unexpected Enum default value for list type");
    }

    private static String mapArray(MappingContext mappingContext, Type<?> graphQLType, ArrayValue defaultValue) {
        if (graphQLType instanceof NonNullType) {
            return DefaultValueMapper.mapArray(mappingContext, ((NonNullType)graphQLType).getType(), defaultValue);
        }
        if (graphQLType instanceof ListType) {
            List values = defaultValue.getValues();
            if (values.isEmpty()) {
                return "java.util.Collections.emptyList()";
            }
            Type elementType = ((ListType)graphQLType).getType();
            return values.stream().map(v -> DefaultValueMapper.map(mappingContext, v, elementType)).collect(Collectors.joining(", ", "java.util.Arrays.asList(", ")"));
        }
        throw new IllegalArgumentException("Unexpected array default value for non-list type");
    }
}

