/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.ProjectionParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.util.List;
import java.util.stream.Collectors;

public class FieldDefinitionToParameterMapper {
    private FieldDefinitionToParameterMapper() {
    }

    public static List<ParameterDefinition> mapFields(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefinitions, String parentTypeName) {
        return fieldDefinitions.stream().filter(fieldDef -> !FieldDefinitionToParameterMapper.generateResolversForField(mappingContext, fieldDef, parentTypeName)).map(fieldDef -> FieldDefinitionToParameterMapper.mapField(mappingContext, fieldDef, parentTypeName)).collect(Collectors.toList());
    }

    public static List<ProjectionParameterDefinition> mapProjectionFields(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefinitions, ExtendedDefinition<?, ?> parentTypeDefinition) {
        return fieldDefinitions.stream().map(fieldDef -> FieldDefinitionToParameterMapper.mapProjectionField(mappingContext, fieldDef, parentTypeDefinition)).collect(Collectors.toList());
    }

    private static ParameterDefinition mapField(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, String parentTypeName) {
        ParameterDefinition parameter = new ParameterDefinition();
        parameter.setName(MapperUtils.capitalizeIfRestricted(fieldDef.getName()));
        parameter.setType(GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, fieldDef.getType(), fieldDef.getName(), parentTypeName).getName());
        parameter.setAnnotations(GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, fieldDef.getType(), fieldDef.getName(), parentTypeName, false));
        parameter.setJavaDoc(fieldDef.getJavaDoc());
        parameter.setDeprecated(fieldDef.isDeprecated());
        return parameter;
    }

    private static ProjectionParameterDefinition mapProjectionField(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, ExtendedDefinition<?, ?> parentTypeDef) {
        ProjectionParameterDefinition parameter = new ProjectionParameterDefinition();
        parameter.setName(MapperUtils.capitalizeIfRestricted(fieldDef.getName()));
        parameter.setMethodName(parameter.getName());
        String nestedType = GraphqlTypeToJavaTypeMapper.getNestedTypeName(fieldDef.getType());
        if (mappingContext.getTypeAndUnionNames().contains(nestedType)) {
            parameter.setType(nestedType + mappingContext.getResponseProjectionSuffix());
        }
        if (!Utils.isEmpty(fieldDef.getInputValueDefinitions())) {
            parameter.setParametrizedInputClassName(MapperUtils.getParametrizedInputClassName(mappingContext, fieldDef, parentTypeDef));
        }
        parameter.setDeprecated(fieldDef.isDeprecated());
        return parameter;
    }

    public static boolean generateResolversForField(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, String parentTypeName) {
        boolean resolverForExtendedType;
        boolean resolverForParamField;
        boolean noResolverForWholeType = mappingContext.getFieldsWithoutResolvers().contains(parentTypeName);
        if (noResolverForWholeType) {
            return false;
        }
        boolean noResolverForSpecificField = mappingContext.getFieldsWithoutResolvers().contains(parentTypeName + "." + fieldDef.getName());
        if (noResolverForSpecificField) {
            return false;
        }
        boolean bl = resolverForParamField = mappingContext.getGenerateParameterizedFieldsResolvers() != false && !Utils.isEmpty(fieldDef.getInputValueDefinitions());
        if (resolverForParamField) {
            return true;
        }
        boolean bl2 = resolverForExtendedType = mappingContext.getGenerateExtensionFieldsResolvers() != false && fieldDef.isFromExtension();
        if (resolverForExtendedType) {
            return true;
        }
        boolean resolverForWholeType = mappingContext.getFieldsWithResolvers().contains(parentTypeName);
        if (resolverForWholeType) {
            return true;
        }
        return mappingContext.getFieldsWithResolvers().contains(parentTypeName + "." + fieldDef.getName());
    }
}

