/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputValueDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.OperationDefinition;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FieldDefinitionsToResolverDataModelMapper {
    private FieldDefinitionsToResolverDataModelMapper() {
    }

    public static Map<String, Object> mapToTypeResolver(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefs, String parentTypeName) {
        String className = MapperUtils.getTypeResolverClassNameWithPrefixAndSuffix(mappingContext, parentTypeName);
        return FieldDefinitionsToResolverDataModelMapper.mapToResolverModel(mappingContext, parentTypeName, className, fieldDefs, Collections.singletonList("Resolver for " + parentTypeName), FieldDefinitionsToResolverDataModelMapper.getParentInterface(mappingContext, parentTypeName));
    }

    public static Map<String, Object> mapRootTypeField(MappingContext mappingContext, ExtendedFieldDefinition fieldDefinition, String rootTypeName, List<String> fieldNames) {
        String className = MapperUtils.getApiClassNameWithPrefixAndSuffix(mappingContext, fieldDefinition, rootTypeName, fieldNames);
        List<ExtendedFieldDefinition> fieldDefs = Collections.singletonList(fieldDefinition);
        return FieldDefinitionsToResolverDataModelMapper.mapToResolverModel(mappingContext, rootTypeName, className, fieldDefs, fieldDefinition.getJavaDoc(), FieldDefinitionsToResolverDataModelMapper.getParentInterface(mappingContext, rootTypeName));
    }

    public static Map<String, Object> mapRootTypeFields(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        String className = MapperUtils.getApiClassNameWithPrefixAndSuffix(mappingContext, definition);
        return FieldDefinitionsToResolverDataModelMapper.mapToResolverModel(mappingContext, definition.getName(), className, definition.getFieldDefinitions(), definition.getJavaDoc(), FieldDefinitionsToResolverDataModelMapper.getParentInterface(mappingContext, definition.getName()));
    }

    private static Map<String, Object> mapToResolverModel(MappingContext mappingContext, String parentTypeName, String className, List<ExtendedFieldDefinition> fieldDefinitions, List<String> javaDoc, String parentInterface) {
        String packageName = MapperUtils.getApiPackageName(mappingContext);
        Set<String> imports = MapperUtils.getImports(mappingContext, packageName);
        List<OperationDefinition> operations = FieldDefinitionsToResolverDataModelMapper.mapToOperations(mappingContext, fieldDefinitions, parentTypeName);
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", packageName);
        dataModel.put("imports", imports);
        dataModel.put("className", className);
        dataModel.put("operations", operations);
        dataModel.put("javaDoc", javaDoc);
        dataModel.put("implements", parentInterface != null ? Collections.singletonList(parentInterface) : null);
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    private static List<OperationDefinition> mapToOperations(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefinitions, String parentTypeName) {
        return fieldDefinitions.stream().map(fieldDef -> FieldDefinitionsToResolverDataModelMapper.map(mappingContext, fieldDef, parentTypeName)).collect(Collectors.toList());
    }

    private static OperationDefinition map(MappingContext mappingContext, ExtendedFieldDefinition resolvedField, String parentTypeName) {
        String javaType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, resolvedField.getType(), resolvedField.getName(), parentTypeName).getName();
        OperationDefinition operation = new OperationDefinition();
        operation.setName(resolvedField.getName());
        operation.setType(GraphqlTypeToJavaTypeMapper.wrapIntoAsyncIfRequired(mappingContext, javaType, parentTypeName));
        operation.setAnnotations(GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, resolvedField.getType(), resolvedField.getName(), parentTypeName, false));
        operation.setParameters(FieldDefinitionsToResolverDataModelMapper.getOperationParameters(mappingContext, resolvedField, parentTypeName));
        operation.setJavaDoc(resolvedField.getJavaDoc());
        operation.setDeprecated(resolvedField.isDeprecated());
        return operation;
    }

    private static List<ParameterDefinition> getOperationParameters(MappingContext mappingContext, ExtendedFieldDefinition resolvedField, String parentTypeName) {
        ArrayList<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>();
        if (!Utils.isGraphqlOperation(parentTypeName)) {
            String parentObjectParamType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, new TypeName(parentTypeName));
            String parentObjectParamName = MapperUtils.capitalizeIfRestricted(Utils.uncapitalize(parentObjectParamType));
            parameters.add(new ParameterDefinition(parentObjectParamType, parentObjectParamName, null, Collections.emptyList(), Collections.emptyList(), resolvedField.isDeprecated()));
        }
        parameters.addAll(InputValueDefinitionToParameterMapper.map(mappingContext, resolvedField.getInputValueDefinitions(), resolvedField.getName()));
        if (Boolean.TRUE.equals(mappingContext.getGenerateDataFetchingEnvironmentArgumentInApis())) {
            parameters.add(ParameterDefinition.DATA_FETCHING_ENVIRONMENT);
        }
        return parameters;
    }

    public static String getParentInterface(MappingContext mappingContext, String typeName) {
        try {
            switch (GraphQLOperation.valueOf(typeName.toUpperCase())) {
                case QUERY: {
                    return mappingContext.getQueryResolverParentInterface();
                }
                case MUTATION: {
                    return mappingContext.getMutationResolverParentInterface();
                }
                case SUBSCRIPTION: {
                    return mappingContext.getSubscriptionResolverParentInterface();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mappingContext.getResolverParentInterface() == null) {
            return null;
        }
        return mappingContext.getResolverParentInterface().replace("{{TYPE}}", MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, typeName));
    }
}

