/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class GraphqlTypeToJavaTypeMapper {
    private GraphqlTypeToJavaTypeMapper() {
    }

    static String getJavaType(MappingContext mappingContext, Type<?> type) {
        return GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, type, null, null).getName();
    }

    static String getJavaType(MappingContext mappingContext, String graphqlTypeName) {
        return GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, graphqlTypeName, null, null).getName();
    }

    static NamedDefinition getJavaType(MappingContext mappingContext, Type<?> graphqlType, String name, String parentTypeName) {
        if (graphqlType instanceof TypeName) {
            return GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, ((TypeName)graphqlType).getName(), name, parentTypeName);
        }
        if (graphqlType instanceof ListType) {
            NamedDefinition mappedCollectionType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, ((ListType)graphqlType).getType(), name, parentTypeName);
            if (mappedCollectionType.isInterface() && mappingContext.getInterfaceNames().contains(parentTypeName)) {
                mappedCollectionType.setName(GraphqlTypeToJavaTypeMapper.wrapSuperTypeIntoJavaList(mappedCollectionType.getName()));
            } else {
                mappedCollectionType.setName(GraphqlTypeToJavaTypeMapper.wrapIntoJavaList(mappedCollectionType.getName()));
            }
            return mappedCollectionType;
        }
        if (graphqlType instanceof NonNullType) {
            return GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, ((NonNullType)graphqlType).getType(), name, parentTypeName);
        }
        throw new IllegalArgumentException("Unknown type: " + graphqlType);
    }

    static String getNestedTypeName(Type<?> graphqlType) {
        if (graphqlType instanceof TypeName) {
            return ((TypeName)graphqlType).getName();
        }
        if (graphqlType instanceof ListType) {
            return GraphqlTypeToJavaTypeMapper.getNestedTypeName(((ListType)graphqlType).getType());
        }
        if (graphqlType instanceof NonNullType) {
            return GraphqlTypeToJavaTypeMapper.getNestedTypeName(((NonNullType)graphqlType).getType());
        }
        return null;
    }

    private static NamedDefinition getJavaType(MappingContext mappingContext, String graphQLType, String name, String parentTypeName) {
        Map<String, String> customTypesMapping = mappingContext.getCustomTypesMapping();
        String javaTypeName = name != null && parentTypeName != null && customTypesMapping.containsKey(parentTypeName + "." + name) ? customTypesMapping.get(parentTypeName + "." + name) : (customTypesMapping.containsKey(graphQLType) ? customTypesMapping.get(graphQLType) : MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, graphQLType));
        return new NamedDefinition(javaTypeName, mappingContext.getInterfaceNames().contains(graphQLType));
    }

    static List<String> getAnnotations(MappingContext mappingContext, Type<?> type, String name, String parentTypeName, boolean mandatory) {
        if (type instanceof TypeName) {
            return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, ((TypeName)type).getName(), name, parentTypeName, mandatory);
        }
        if (type instanceof ListType) {
            return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, ((ListType)type).getType(), name, parentTypeName, mandatory);
        }
        if (type instanceof NonNullType) {
            return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, ((NonNullType)type).getType(), name, parentTypeName, true);
        }
        return Collections.emptyList();
    }

    private static List<String> getAnnotations(MappingContext mappingContext, String graphQLType, String name, String parentTypeName, boolean mandatory) {
        String modelValidationAnnotation;
        ArrayList<String> annotations = new ArrayList<String>();
        if (mandatory && Utils.isNotBlank(modelValidationAnnotation = mappingContext.getModelValidationAnnotation())) {
            annotations.add(modelValidationAnnotation);
        }
        Map<String, String> customAnnotationsMapping = mappingContext.getCustomAnnotationsMapping();
        if (name != null && parentTypeName != null && customAnnotationsMapping.containsKey(parentTypeName + "." + name)) {
            annotations.add(customAnnotationsMapping.get(parentTypeName + "." + name));
        } else if (customAnnotationsMapping.containsKey(graphQLType)) {
            annotations.add(customAnnotationsMapping.get(graphQLType));
        }
        return annotations;
    }

    private static String wrapIntoJavaList(String type) {
        return String.format("java.util.List<%s>", type);
    }

    private static String wrapSuperTypeIntoJavaList(String type) {
        return String.format("java.util.List<? extends %s>", type);
    }

    private static String wrapIntoJavaCompletableFuture(String type) {
        return String.format("java.util.concurrent.CompletableFuture<%s>", type);
    }

    static String wrapIntoAsyncIfRequired(MappingContext mappingContext, String javaTypeName, String parentTypeName) {
        if (MapperUtils.shouldUseAsyncMethods(mappingContext, parentTypeName)) {
            return GraphqlTypeToJavaTypeMapper.wrapIntoJavaCompletableFuture(javaTypeName);
        }
        return GraphqlTypeToJavaTypeMapper.wrapIntoSubscriptionIfRequired(mappingContext, javaTypeName, parentTypeName);
    }

    private static String wrapIntoSubscriptionIfRequired(MappingContext mappingContext, String javaTypeName, String parentTypeName) {
        if (parentTypeName.equalsIgnoreCase(GraphQLOperation.SUBSCRIPTION.name()) && Utils.isNotBlank(mappingContext.getSubscriptionReturnType())) {
            return String.format("%s<%s>", mappingContext.getSubscriptionReturnType(), javaTypeName);
        }
        return javaTypeName;
    }
}

