/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.DefaultValueMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.InputValueDefinition;
import java.util.List;
import java.util.stream.Collectors;

public class InputValueDefinitionToParameterMapper {
    private InputValueDefinitionToParameterMapper() {
    }

    public static List<ParameterDefinition> map(MappingContext mappingContext, List<InputValueDefinition> valueDefinitions, String parentTypeName) {
        return valueDefinitions.stream().map(inputValueDef -> InputValueDefinitionToParameterMapper.map(mappingContext, inputValueDef, parentTypeName)).collect(Collectors.toList());
    }

    private static ParameterDefinition map(MappingContext mappingContext, InputValueDefinition inputValueDefinition, String parentTypeName) {
        ParameterDefinition parameter = new ParameterDefinition();
        parameter.setName(MapperUtils.capitalizeIfRestricted(inputValueDefinition.getName()));
        parameter.setType(GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, inputValueDefinition.getType()));
        parameter.setDefaultValue(DefaultValueMapper.map(mappingContext, inputValueDefinition.getDefaultValue(), inputValueDefinition.getType()));
        parameter.setAnnotations(GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, inputValueDefinition.getType(), inputValueDefinition.getName(), parentTypeName, false));
        parameter.setDeprecated(InputValueDefinitionToParameterMapper.isDeprecated(inputValueDefinition));
        return parameter;
    }

    private static boolean isDeprecated(DirectivesContainer<?> node) {
        return node.getDirectives().stream().map(Directive::getName).anyMatch(Deprecated.class.getSimpleName()::equalsIgnoreCase);
    }
}

