/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.model.ApiRootInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDocument;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.InputValueDefinition;
import graphql.language.SourceLocation;
import graphql.language.TypeName;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;

class MapperUtils {
    private static final Set<String> JAVA_RESTRICTED_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));

    private MapperUtils() {
    }

    static String capitalizeIfRestricted(String fieldName) {
        if (JAVA_RESTRICTED_KEYWORDS.contains(fieldName)) {
            return Utils.capitalize(fieldName);
        }
        return fieldName;
    }

    static String getModelClassNameWithPrefixAndSuffix(MappingContext mappingContext, ExtendedDefinition<?, ?> extendedDefinition) {
        return MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, extendedDefinition.getName());
    }

    static String getModelClassNameWithPrefixAndSuffix(MappingContext mappingContext, String definitionName) {
        StringBuilder classNameBuilder = new StringBuilder();
        if (Utils.isNotBlank(mappingContext.getModelNamePrefix())) {
            classNameBuilder.append(mappingContext.getModelNamePrefix());
        }
        classNameBuilder.append(Utils.capitalize(definitionName));
        if (Utils.isNotBlank(mappingContext.getModelNameSuffix())) {
            classNameBuilder.append(mappingContext.getModelNameSuffix());
        }
        return classNameBuilder.toString();
    }

    static String getTypeResolverClassNameWithPrefixAndSuffix(MappingContext mappingContext, String typeName) {
        StringBuilder classNameBuilder = new StringBuilder();
        if (Utils.isNotBlank(mappingContext.getTypeResolverPrefix())) {
            classNameBuilder.append(mappingContext.getTypeResolverPrefix());
        }
        classNameBuilder.append(Utils.capitalize(typeName));
        if (Utils.isNotBlank(mappingContext.getTypeResolverSuffix())) {
            classNameBuilder.append(mappingContext.getTypeResolverSuffix());
        }
        return classNameBuilder.toString();
    }

    static String getApiClassNameWithPrefixAndSuffix(MappingContext mappingContext, ExtendedFieldDefinition fieldDefinition, String rootTypeName, List<String> fieldNames) {
        StringBuilder classNameBuilder = new StringBuilder();
        classNameBuilder.append(MapperUtils.getApiPrefix(mappingContext, fieldDefinition.getSourceLocation()));
        classNameBuilder.append(Utils.capitalize(fieldDefinition.getName()));
        if (Collections.frequency(fieldNames, fieldDefinition.getName()) > 1) {
            classNameBuilder.append(MapperUtils.getClassNameSuffixWithInputValues(fieldDefinition));
        }
        if (Utils.isNotBlank(rootTypeName)) {
            classNameBuilder.append(rootTypeName);
        }
        if (Utils.isNotBlank(mappingContext.getApiNameSuffix())) {
            classNameBuilder.append(mappingContext.getApiNameSuffix());
        }
        return classNameBuilder.toString();
    }

    static String getApiClassNameWithPrefixAndSuffix(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        StringBuilder classNameBuilder = new StringBuilder();
        if (mappingContext.getApiRootInterfaceStrategy() == ApiRootInterfaceStrategy.SINGLE_INTERFACE) {
            if (Utils.isNotBlank(mappingContext.getApiNamePrefix())) {
                classNameBuilder.append(mappingContext.getApiNamePrefix());
            }
        } else {
            classNameBuilder.append(MapperUtils.getApiPrefix(mappingContext, definition.getSourceLocation()));
        }
        classNameBuilder.append(Utils.capitalize(definition.getName()));
        if (Utils.isNotBlank(mappingContext.getApiNameSuffix())) {
            classNameBuilder.append(mappingContext.getApiNameSuffix());
        }
        return classNameBuilder.toString();
    }

    private static String getApiPrefix(MappingContext mappingContext, SourceLocation sourceLocation) {
        switch (mappingContext.getApiNamePrefixStrategy()) {
            case FILE_NAME_AS_PREFIX: {
                return MapperUtils.getPrefixFromSourceLocation(sourceLocation, File::getName);
            }
            case FOLDER_NAME_AS_PREFIX: {
                return MapperUtils.getPrefixFromSourceLocation(sourceLocation, MapperUtils.getParentFileNameFunction());
            }
        }
        if (Utils.isNotBlank(mappingContext.getApiNamePrefix())) {
            return mappingContext.getApiNamePrefix();
        }
        return "";
    }

    private static String getPrefixFromSourceLocation(SourceLocation sourceLocation, Function<File, String> fileStringFunction) {
        if (sourceLocation == null || sourceLocation.getSourceName() == null) {
            return "";
        }
        String fileName = fileStringFunction.apply(new File(sourceLocation.getSourceName()));
        fileName = fileName.replaceFirst("[.][^.]+$", "");
        fileName = Utils.capitalizeString(fileName);
        fileName = fileName.replaceAll("[^A-Za-z0-9]", "");
        return fileName;
    }

    static String getParametrizedInputClassName(MappingContext mappingContext, ExtendedFieldDefinition fieldDefinition, ExtendedDefinition<?, ?> parentTypeDefinition) {
        return Utils.capitalize(parentTypeDefinition.getName()) + Utils.capitalize(fieldDefinition.getName()) + mappingContext.getParametrizedInputSuffix();
    }

    static String getApiPackageName(MappingContext mappingContext) {
        if (Utils.isNotBlank(mappingContext.getApiPackageName())) {
            return mappingContext.getApiPackageName();
        }
        return mappingContext.getPackageName();
    }

    static String getModelPackageName(MappingContext mappingContext) {
        if (Utils.isNotBlank(mappingContext.getModelPackageName())) {
            return mappingContext.getModelPackageName();
        }
        return mappingContext.getPackageName();
    }

    static Set<String> getImports(MappingContext mappingContext, String packageName) {
        String genericPackageName;
        HashSet<String> imports = new HashSet<String>();
        String modelPackageName = mappingContext.getModelPackageName();
        if (Utils.isNotBlank(modelPackageName) && !modelPackageName.equals(packageName)) {
            imports.add(modelPackageName);
        }
        if (Utils.isNotBlank(genericPackageName = mappingContext.getPackageName()) && !genericPackageName.equals(packageName)) {
            imports.add(genericPackageName);
        }
        return imports;
    }

    static boolean shouldUseAsyncMethods(MappingContext mappingContext, String typeName) {
        return mappingContext.getGenerateAsyncApi() != false && !GraphQLOperation.SUBSCRIPTION.name().equalsIgnoreCase(typeName);
    }

    static String getClassNameSuffixWithInputValues(ExtendedFieldDefinition fieldDefinition) {
        StringJoiner inputValueNamesJoiner = new StringJoiner("And");
        fieldDefinition.getInputValueDefinitions().stream().map(InputValueDefinition::getName).map(Utils::capitalize).forEach(inputValueNamesJoiner::add);
        String inputValueNames = inputValueNamesJoiner.toString();
        if (inputValueNames.isEmpty()) {
            return inputValueNames;
        }
        return "By" + inputValueNames;
    }

    static List<ExtendedInterfaceTypeDefinition> getInterfacesOfType(ExtendedObjectTypeDefinition definition, ExtendedDocument document) {
        if (definition.getImplements().isEmpty()) {
            return Collections.emptyList();
        }
        Set typeImplements = definition.getImplements().stream().filter(type -> TypeName.class.isAssignableFrom(type.getClass())).map(TypeName.class::cast).map(TypeName::getName).collect(Collectors.toSet());
        return document.getInterfaceDefinitions().stream().filter(def -> typeImplements.contains(def.getName())).collect(Collectors.toList());
    }

    private static Function<File, String> getParentFileNameFunction() {
        return file -> file != null && file.getParentFile() != null ? file.getParentFile().getName() : null;
    }
}

