/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputValueDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.ProjectionParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedUnionTypeDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RequestResponseDefinitionToDataModelMapper {
    private RequestResponseDefinitionToDataModelMapper() {
    }

    public static Map<String, Object> mapResponseProjection(MappingContext mappingContext, ExtendedDefinition<?, ?> definition) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", MapperUtils.getModelPackageName(mappingContext));
        dataModel.put("className", Utils.capitalize(definition.getName()) + mappingContext.getResponseProjectionSuffix());
        dataModel.put("javaDoc", Collections.singletonList("Response projection for " + definition.getName()));
        dataModel.put("fields", RequestResponseDefinitionToDataModelMapper.getProjectionFields(mappingContext, definition));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    public static Map<String, Object> mapParametrizedInput(MappingContext mappingContext, ExtendedFieldDefinition fieldDefinition, ExtendedObjectTypeDefinition parentTypeDefinition) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", MapperUtils.getModelPackageName(mappingContext));
        dataModel.put("className", MapperUtils.getParametrizedInputClassName(mappingContext, fieldDefinition, parentTypeDefinition));
        dataModel.put("javaDoc", Collections.singletonList(String.format("Parametrized input for field %s in type %s", fieldDefinition.getName(), parentTypeDefinition.getName())));
        dataModel.put("fields", InputValueDefinitionToParameterMapper.map(mappingContext, fieldDefinition.getInputValueDefinitions(), parentTypeDefinition.getName()));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    public static Map<String, Object> mapResponse(MappingContext mappingContext, ExtendedFieldDefinition operationDef, String objectTypeName, List<String> fieldNames) {
        String javaType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, operationDef.getType(), operationDef.getName(), objectTypeName).getName();
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", MapperUtils.getModelPackageName(mappingContext));
        dataModel.put("className", RequestResponseDefinitionToDataModelMapper.getClassName(operationDef, fieldNames, objectTypeName, mappingContext.getResponseSuffix()));
        dataModel.put("javaDoc", operationDef.getJavaDoc());
        dataModel.put("deprecated", operationDef.isDeprecated());
        dataModel.put("operationName", operationDef.getName());
        dataModel.put("returnTypeName", javaType);
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    public static Map<String, Object> mapRequest(MappingContext mappingContext, ExtendedFieldDefinition operationDef, String objectTypeName, List<String> fieldNames) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", MapperUtils.getModelPackageName(mappingContext));
        dataModel.put("className", RequestResponseDefinitionToDataModelMapper.getClassName(operationDef, fieldNames, objectTypeName, mappingContext.getRequestSuffix()));
        dataModel.put("javaDoc", operationDef.getJavaDoc());
        dataModel.put("operationName", operationDef.getName());
        dataModel.put("operationType", objectTypeName.toUpperCase());
        dataModel.put("fields", InputValueDefinitionToParameterMapper.map(mappingContext, operationDef.getInputValueDefinitions(), operationDef.getName()));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("toString", mappingContext.getGenerateToString());
        dataModel.put("toStringForRequest", mappingContext.getGenerateClient());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    private static String getClassName(ExtendedFieldDefinition operationDef, List<String> fieldNames, String objectType, String suffix) {
        StringBuilder classNameBuilder = new StringBuilder();
        classNameBuilder.append(Utils.capitalize(operationDef.getName()));
        if (Collections.frequency(fieldNames, operationDef.getName()) > 1) {
            classNameBuilder.append(MapperUtils.getClassNameSuffixWithInputValues(operationDef));
        }
        classNameBuilder.append(objectType);
        if (Utils.isNotBlank(suffix)) {
            classNameBuilder.append(suffix);
        }
        return classNameBuilder.toString();
    }

    private static Collection<ProjectionParameterDefinition> getProjectionFields(MappingContext mappingContext, ExtendedDefinition<?, ?> definition) {
        LinkedHashMap<String, ProjectionParameterDefinition> allParameters = new LinkedHashMap<String, ProjectionParameterDefinition>();
        if (definition instanceof ExtendedObjectTypeDefinition) {
            ExtendedObjectTypeDefinition typeDefinition = (ExtendedObjectTypeDefinition)definition;
            FieldDefinitionToParameterMapper.mapProjectionFields(mappingContext, typeDefinition.getFieldDefinitions(), typeDefinition).forEach(p -> allParameters.put(p.getName(), (ProjectionParameterDefinition)p));
            MapperUtils.getInterfacesOfType(typeDefinition, mappingContext.getDocument()).stream().map(i -> FieldDefinitionToParameterMapper.mapProjectionFields(mappingContext, i.getFieldDefinitions(), i)).flatMap(Collection::stream).filter(paramDef -> !allParameters.containsKey(paramDef.getName())).forEach(paramDef -> allParameters.put(paramDef.getName(), (ProjectionParameterDefinition)paramDef));
        } else if (definition instanceof ExtendedUnionTypeDefinition) {
            ExtendedUnionTypeDefinition unionDefinition = (ExtendedUnionTypeDefinition)definition;
            for (String memberTypeName : unionDefinition.getMemberTypeNames()) {
                ProjectionParameterDefinition parameter = new ProjectionParameterDefinition();
                parameter.setName("...on " + memberTypeName);
                parameter.setMethodName("on" + memberTypeName);
                parameter.setType(memberTypeName + mappingContext.getResponseProjectionSuffix());
                allParameters.put(parameter.getName(), parameter);
            }
            ProjectionParameterDefinition typeNameProjParamDef = new ProjectionParameterDefinition();
            typeNameProjParamDef.setName("__typename");
            typeNameProjParamDef.setMethodName("typename");
            allParameters.put(typeNameProjParamDef.getName(), typeNameProjParamDef);
        }
        return allParameters.values();
    }
}

