/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDocument;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeDefinitionToDataModelMapper {
    private TypeDefinitionToDataModelMapper() {
    }

    public static Map<String, Object> map(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        ExtendedDocument document = mappingContext.getDocument();
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", MapperUtils.getModelPackageName(mappingContext));
        dataModel.put("className", MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, definition));
        dataModel.put("javaDoc", definition.getJavaDoc());
        dataModel.put("implements", TypeDefinitionToDataModelMapper.getInterfaces(mappingContext, definition));
        dataModel.put("fields", TypeDefinitionToDataModelMapper.getFields(mappingContext, definition, document));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("immutableModels", mappingContext.getGenerateImmutableModels());
        dataModel.put("toString", mappingContext.getGenerateToString());
        dataModel.put("toStringForRequest", mappingContext.getGenerateClient());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    private static Collection<ParameterDefinition> getFields(MappingContext mappingContext, ExtendedObjectTypeDefinition typeDefinition, ExtendedDocument document) {
        LinkedHashMap allParameters = new LinkedHashMap();
        FieldDefinitionToParameterMapper.mapFields(mappingContext, typeDefinition.getFieldDefinitions(), typeDefinition.getName()).forEach(p -> allParameters.put(p.getName(), p));
        MapperUtils.getInterfacesOfType(typeDefinition, document).stream().map(i -> FieldDefinitionToParameterMapper.mapFields(mappingContext, i.getFieldDefinitions(), i.getName())).flatMap(Collection::stream).forEach(paramDef -> allParameters.merge(paramDef.getName(), paramDef, TypeDefinitionToDataModelMapper::merge));
        return allParameters.values();
    }

    private static ParameterDefinition merge(ParameterDefinition typeDef, ParameterDefinition interfaceDef) {
        if (Utils.isEmpty(typeDef.getAnnotations())) {
            typeDef.setAnnotations(interfaceDef.getAnnotations());
        }
        if (Utils.isEmpty(typeDef.getJavaDoc())) {
            typeDef.setJavaDoc(interfaceDef.getJavaDoc());
        }
        return typeDef;
    }

    private static Set<String> getInterfaces(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        List unionsNames = mappingContext.getDocument().getUnionDefinitions().stream().filter(union -> union.isDefinitionPartOfUnion(definition)).map(ExtendedDefinition::getName).map(unionName -> MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, unionName)).collect(Collectors.toList());
        Set interfaceNames = definition.getImplements().stream().map(anImplement -> GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, anImplement)).collect(Collectors.toSet());
        LinkedHashSet<String> allInterfaces = new LinkedHashSet<String>();
        allInterfaces.addAll(unionsNames);
        allInterfaces.addAll(interfaceNames);
        return allInterfaces;
    }
}

