/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.definitions;

import graphql.language.Comment;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class ExtendedDefinition<T extends NamedNode<T>, E extends T> {
    protected T definition;
    protected List<E> extensions = new ArrayList();

    public String getName() {
        if (this.definition != null) {
            return this.definition.getName();
        }
        return this.extensions.stream().map(NamedNode::getName).findFirst().orElse(null);
    }

    public SourceLocation getSourceLocation() {
        if (this.definition != null) {
            return this.definition.getSourceLocation();
        }
        return this.extensions.stream().map(Node::getSourceLocation).findFirst().orElse(null);
    }

    public List<String> getJavaDoc() {
        ArrayList<String> comments = new ArrayList<String>();
        if (this.definition != null && this.definition.getComments() != null) {
            this.definition.getComments().stream().map(Comment::getContent).filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).forEach(comments::add);
        }
        this.extensions.stream().map(Node::getComments).flatMap(Collection::stream).filter(Objects::nonNull).map(Comment::getContent).filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).forEach(comments::add);
        return comments;
    }

    public T getDefinition() {
        return this.definition;
    }

    public void setDefinition(T definition) {
        this.definition = definition;
    }

    public List<E> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<E> extensions) {
        this.extensions = extensions;
    }
}

