/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.definitions;

import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.Type;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ExtendedObjectTypeDefinition
extends ExtendedDefinition<ObjectTypeDefinition, ObjectTypeExtensionDefinition> {
    public List<ExtendedFieldDefinition> getFieldDefinitions() {
        ArrayList<ExtendedFieldDefinition> definitions = new ArrayList<ExtendedFieldDefinition>();
        if (this.definition != null) {
            ((ObjectTypeDefinition)this.definition).getFieldDefinitions().stream().map(f -> new ExtendedFieldDefinition((FieldDefinition)f, false)).forEach(definitions::add);
        }
        this.extensions.stream().map(ObjectTypeDefinition::getFieldDefinitions).flatMap(Collection::stream).map(f -> new ExtendedFieldDefinition((FieldDefinition)f, true)).forEach(definitions::add);
        return definitions;
    }

    public Map<String, ExtendedObjectTypeDefinition> groupBySourceLocationFile() {
        return this.groupBySourceLocation(File::getName);
    }

    public Map<String, ExtendedObjectTypeDefinition> groupBySourceLocationFolder() {
        return this.groupBySourceLocation(File::getParent);
    }

    private Map<String, ExtendedObjectTypeDefinition> groupBySourceLocation(Function<File, String> fileStringFunction) {
        HashMap<String, ExtendedObjectTypeDefinition> definitionMap = new HashMap<String, ExtendedObjectTypeDefinition>();
        if (this.definition != null) {
            File file = new File(((ObjectTypeDefinition)this.definition).getSourceLocation().getSourceName());
            definitionMap.computeIfAbsent(fileStringFunction.apply(file), d -> new ExtendedObjectTypeDefinition()).setDefinition(this.definition);
        }
        for (ObjectTypeExtensionDefinition extension : this.extensions) {
            File file = new File(extension.getSourceLocation().getSourceName());
            definitionMap.computeIfAbsent(fileStringFunction.apply(file), d -> new ExtendedObjectTypeDefinition()).getExtensions().add(extension);
        }
        return definitionMap;
    }

    public List<Type> getImplements() {
        ArrayList<Type> definitionImplements = new ArrayList<Type>();
        if (this.definition != null) {
            definitionImplements.addAll(((ObjectTypeDefinition)this.definition).getImplements());
        }
        this.extensions.stream().map(ObjectTypeDefinition::getImplements).forEach(definitionImplements::addAll);
        return definitionImplements;
    }
}

