/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.GraphQLCodegen;
import com.kobylynskyi.graphql.codegen.model.GeneratedLanguage;
import com.kobylynskyi.graphql.codegen.model.exception.UnableToLoadFreeMarkerTemplateException;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.Version;
import java.io.IOException;
import java.util.EnumMap;

class FreeMarkerTemplatesRegistry {
    private static final Version FREEMARKER_TEMPLATE_VERSION = Configuration.VERSION_2_3_30;
    private static final EnumMap<GeneratedLanguage, EnumMap<FreeMarkerTemplateType, Template>> templateMap = new EnumMap(GeneratedLanguage.class);

    private FreeMarkerTemplatesRegistry() {
    }

    public static Template getTemplateWithLang(GeneratedLanguage generatedLanguage, FreeMarkerTemplateType templateType) {
        return templateMap.get((Object)generatedLanguage).get((Object)templateType);
    }

    static {
        BeansWrapper beansWrapper = new BeansWrapper(FREEMARKER_TEMPLATE_VERSION);
        Configuration configuration = new Configuration(FREEMARKER_TEMPLATE_VERSION);
        configuration.setClassLoaderForTemplateLoading(GraphQLCodegen.class.getClassLoader(), "");
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        configuration.setLogTemplateExceptions(false);
        configuration.setWrapUncheckedExceptions(true);
        configuration.setSharedVariable("statics", (TemplateModel)beansWrapper.getStaticModels());
        try {
            EnumMap<FreeMarkerTemplateType, Template> javaTemplates = new EnumMap<FreeMarkerTemplateType, Template>(FreeMarkerTemplateType.class);
            javaTemplates.put(FreeMarkerTemplateType.TYPE, configuration.getTemplate("templates/java-lang/javaClassGraphqlType.ftl"));
            javaTemplates.put(FreeMarkerTemplateType.ENUM, configuration.getTemplate("templates/java-lang/javaClassGraphqlEnum.ftl"));
            javaTemplates.put(FreeMarkerTemplateType.UNION, configuration.getTemplate("templates/java-lang/javaClassGraphqlUnion.ftl"));
            javaTemplates.put(FreeMarkerTemplateType.REQUEST, configuration.getTemplate("templates/java-lang/javaClassGraphqlRequest.ftl"));
            javaTemplates.put(FreeMarkerTemplateType.RESPONSE, configuration.getTemplate("templates/java-lang/javaClassGraphqlResponse.ftl"));
            javaTemplates.put(FreeMarkerTemplateType.INTERFACE, configuration.getTemplate("templates/java-lang/javaClassGraphqlInterface.ftl"));
            javaTemplates.put(FreeMarkerTemplateType.OPERATIONS, configuration.getTemplate("templates/java-lang/javaClassGraphqlOperations.ftl"));
            javaTemplates.put(FreeMarkerTemplateType.PARAMETRIZED_INPUT, configuration.getTemplate("templates/java-lang/javaClassGraphqlParametrizedInput.ftl"));
            javaTemplates.put(FreeMarkerTemplateType.RESPONSE_PROJECTION, configuration.getTemplate("templates/java-lang/javaClassGraphqlResponseProjection.ftl"));
            templateMap.put(GeneratedLanguage.JAVA, javaTemplates);
            EnumMap<FreeMarkerTemplateType, Template> scalaTemplates = new EnumMap<FreeMarkerTemplateType, Template>(FreeMarkerTemplateType.class);
            scalaTemplates.put(FreeMarkerTemplateType.TYPE, configuration.getTemplate("templates/scala-lang/scalaClassGraphqlType.ftl"));
            scalaTemplates.put(FreeMarkerTemplateType.ENUM, configuration.getTemplate("templates/scala-lang/scalaClassGraphqlEnum.ftl"));
            scalaTemplates.put(FreeMarkerTemplateType.UNION, configuration.getTemplate("templates/scala-lang/scalaClassGraphqlUnion.ftl"));
            scalaTemplates.put(FreeMarkerTemplateType.REQUEST, configuration.getTemplate("templates/scala-lang/scalaClassGraphqlRequest.ftl"));
            scalaTemplates.put(FreeMarkerTemplateType.RESPONSE, configuration.getTemplate("templates/scala-lang/scalaClassGraphqlResponse.ftl"));
            scalaTemplates.put(FreeMarkerTemplateType.INTERFACE, configuration.getTemplate("templates/scala-lang/scalaClassGraphqlInterface.ftl"));
            scalaTemplates.put(FreeMarkerTemplateType.OPERATIONS, configuration.getTemplate("templates/scala-lang/scalaClassGraphqlOperations.ftl"));
            scalaTemplates.put(FreeMarkerTemplateType.PARAMETRIZED_INPUT, configuration.getTemplate("templates/scala-lang/scalaClassGraphqlParametrizedInput.ftl"));
            scalaTemplates.put(FreeMarkerTemplateType.RESPONSE_PROJECTION, configuration.getTemplate("templates/scala-lang/scalaClassGraphqlResponseProjection.ftl"));
            templateMap.put(GeneratedLanguage.SCALA, scalaTemplates);
            EnumMap<FreeMarkerTemplateType, Template> kotlinTemplates = new EnumMap<FreeMarkerTemplateType, Template>(FreeMarkerTemplateType.class);
            kotlinTemplates.put(FreeMarkerTemplateType.TYPE, configuration.getTemplate("templates/kotlin-lang/kotlinClassGraphqlType.ftl"));
            kotlinTemplates.put(FreeMarkerTemplateType.ENUM, configuration.getTemplate("templates/kotlin-lang/kotlinClassGraphqlEnum.ftl"));
            kotlinTemplates.put(FreeMarkerTemplateType.UNION, configuration.getTemplate("templates/kotlin-lang/kotlinClassGraphqlUnion.ftl"));
            kotlinTemplates.put(FreeMarkerTemplateType.REQUEST, configuration.getTemplate("templates/kotlin-lang/kotlinClassGraphqlRequest.ftl"));
            kotlinTemplates.put(FreeMarkerTemplateType.RESPONSE, configuration.getTemplate("templates/kotlin-lang/kotlinClassGraphqlResponse.ftl"));
            kotlinTemplates.put(FreeMarkerTemplateType.INTERFACE, configuration.getTemplate("templates/kotlin-lang/kotlinClassGraphqlInterface.ftl"));
            kotlinTemplates.put(FreeMarkerTemplateType.OPERATIONS, configuration.getTemplate("templates/kotlin-lang/kotlinClassGraphqlOperations.ftl"));
            kotlinTemplates.put(FreeMarkerTemplateType.PARAMETRIZED_INPUT, configuration.getTemplate("templates/kotlin-lang/kotlinClassGraphqlParametrizedInput.ftl"));
            kotlinTemplates.put(FreeMarkerTemplateType.RESPONSE_PROJECTION, configuration.getTemplate("templates/kotlin-lang/kotlinClassGraphqlResponseProjection.ftl"));
            templateMap.put(GeneratedLanguage.KOTLIN, kotlinTemplates);
        }
        catch (IOException e) {
            throw new UnableToLoadFreeMarkerTemplateException(e);
        }
    }
}

