/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.MapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.EnumDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionsToResolverDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputValueDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.InterfaceDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.RequestResponseDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.TypeDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.UnionDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.ValueFormatter;
import com.kobylynskyi.graphql.codegen.mapper.ValueMapper;

public class DataModelMapperFactory {
    private final EnumDefinitionToDataModelMapper enumDefToDataModelMapper;
    private final FieldDefinitionsToResolverDataModelMapper fieldDefsToResolverDataModelMapper;
    private final InputDefinitionToDataModelMapper inputDefToDataModelMapper;
    private final InterfaceDefinitionToDataModelMapper interfaceDefToDataModelMapper;
    private final RequestResponseDefinitionToDataModelMapper requestResponseDefToDataModelMapper;
    private final TypeDefinitionToDataModelMapper typeDefToDataModelMapper;
    private final UnionDefinitionToDataModelMapper unionDefToDataModelMapper;
    private final DataModelMapper dataModelMapper;
    private final FieldDefinitionToParameterMapper fieldDefToParamMapper;

    public DataModelMapperFactory(MapperFactory generatedLanguageMapperFactory) {
        ValueFormatter valueFormatter = generatedLanguageMapperFactory.createValueFormatter();
        this.dataModelMapper = generatedLanguageMapperFactory.createDataModelMapper();
        ValueMapper valueMapper = new ValueMapper(valueFormatter, this.dataModelMapper);
        GraphQLTypeMapper graphQlTypeMapper = generatedLanguageMapperFactory.createGraphQLTypeMapper(valueMapper);
        this.fieldDefToParamMapper = new FieldDefinitionToParameterMapper(graphQlTypeMapper, this.dataModelMapper);
        this.enumDefToDataModelMapper = new EnumDefinitionToDataModelMapper(graphQlTypeMapper, this.dataModelMapper);
        this.unionDefToDataModelMapper = new UnionDefinitionToDataModelMapper(graphQlTypeMapper, this.dataModelMapper);
        this.typeDefToDataModelMapper = new TypeDefinitionToDataModelMapper(graphQlTypeMapper, this.dataModelMapper, this.fieldDefToParamMapper);
        this.interfaceDefToDataModelMapper = new InterfaceDefinitionToDataModelMapper(graphQlTypeMapper, this.dataModelMapper, this.fieldDefToParamMapper);
        InputValueDefinitionToParameterMapper inputValueDefToParamMapper = new InputValueDefinitionToParameterMapper(valueMapper, graphQlTypeMapper, this.dataModelMapper);
        this.inputDefToDataModelMapper = new InputDefinitionToDataModelMapper(graphQlTypeMapper, this.dataModelMapper, inputValueDefToParamMapper);
        this.fieldDefsToResolverDataModelMapper = new FieldDefinitionsToResolverDataModelMapper(graphQlTypeMapper, this.dataModelMapper, inputValueDefToParamMapper);
        this.requestResponseDefToDataModelMapper = new RequestResponseDefinitionToDataModelMapper(graphQlTypeMapper, this.dataModelMapper, this.fieldDefToParamMapper, inputValueDefToParamMapper);
    }

    public EnumDefinitionToDataModelMapper getEnumDefinitionMapper() {
        return this.enumDefToDataModelMapper;
    }

    public FieldDefinitionsToResolverDataModelMapper getFieldDefinitionsToResolverMapper() {
        return this.fieldDefsToResolverDataModelMapper;
    }

    public InputDefinitionToDataModelMapper getInputDefinitionMapper() {
        return this.inputDefToDataModelMapper;
    }

    public InterfaceDefinitionToDataModelMapper getInterfaceDefinitionMapper() {
        return this.interfaceDefToDataModelMapper;
    }

    public UnionDefinitionToDataModelMapper getUnionDefinitionMapper() {
        return this.unionDefToDataModelMapper;
    }

    public RequestResponseDefinitionToDataModelMapper getRequestResponseDefinitionMapper() {
        return this.requestResponseDefToDataModelMapper;
    }

    public TypeDefinitionToDataModelMapper getTypeDefinitionMapper() {
        return this.typeDefToDataModelMapper;
    }

    public DataModelMapper getDataModelMapper() {
        return this.dataModelMapper;
    }

    public FieldDefinitionToParameterMapper getFieldDefToParamMapper() {
        return this.fieldDefToParamMapper;
    }
}

