/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.model.DeprecatedDefinition;
import com.kobylynskyi.graphql.codegen.model.EnumValueDefinition;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedEnumTypeDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Comment;
import graphql.language.DirectivesContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EnumDefinitionToDataModelMapper {
    private final GraphQLTypeMapper graphQlTypeMapper;
    private final DataModelMapper dataModelMapper;

    public EnumDefinitionToDataModelMapper(GraphQLTypeMapper graphQlTypeMapper, DataModelMapper dataModelMapper) {
        this.graphQlTypeMapper = graphQlTypeMapper;
        this.dataModelMapper = dataModelMapper;
    }

    private static Set<String> getUnionInterfaces(MappingContext mappingContext, ExtendedEnumTypeDefinition definition) {
        return mappingContext.getDocument().getUnionDefinitions().stream().filter(union -> union.isDefinitionPartOfUnion(definition)).map(ExtendedDefinition::getName).map(unionName -> DataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, unionName)).collect(Collectors.toSet());
    }

    private static List<String> getJavaDoc(graphql.language.EnumValueDefinition def) {
        if (def.getDescription() != null) {
            return Collections.singletonList(def.getDescription().getContent());
        }
        if (def.getComments() == null) {
            return Collections.emptyList();
        }
        return def.getComments().stream().map(Comment::getContent).filter(Utils::isNotBlank).map(String::trim).collect(Collectors.toList());
    }

    public DeprecatedDefinition getDeprecated(MappingContext mappingContext, DirectivesContainer<?> directivesContainer) {
        return this.graphQlTypeMapper.getDeprecated(mappingContext, directivesContainer);
    }

    public Map<String, Object> map(MappingContext mappingContext, ExtendedEnumTypeDefinition definition) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", DataModelMapper.getModelPackageName(mappingContext));
        dataModel.put("className", this.dataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, definition));
        dataModel.put("implements", EnumDefinitionToDataModelMapper.getUnionInterfaces(mappingContext, definition));
        dataModel.put("annotations", this.graphQlTypeMapper.getAnnotations(mappingContext, definition));
        dataModel.put("javaDoc", definition.getJavaDoc());
        dataModel.put("fields", this.map(mappingContext, definition.getValueDefinitions()));
        dataModel.put("generatedAnnotation", mappingContext.getAddGeneratedAnnotation());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        dataModel.put("serializationLibrary", "JACKSON");
        return dataModel;
    }

    private List<EnumValueDefinition> map(MappingContext mappingContext, List<graphql.language.EnumValueDefinition> enumValueDefinitions) {
        return enumValueDefinitions.stream().map(f -> new EnumValueDefinition(this.dataModelMapper.capitalizeIfRestricted(mappingContext, f.getName()), f.getName(), EnumDefinitionToDataModelMapper.getJavaDoc(f), this.getDeprecated(mappingContext, (DirectivesContainer<?>)f))).collect(Collectors.toList());
    }
}

