/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.ValueMapper;
import com.kobylynskyi.graphql.codegen.model.DeprecatedDefinition;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.MultiLanguageDeprecated;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.ListType;
import graphql.language.NamedNode;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface GraphQLTypeMapper {
    public static String getNestedTypeName(Type<?> graphqlType) {
        if (graphqlType instanceof TypeName) {
            return ((TypeName)graphqlType).getName();
        }
        if (graphqlType instanceof ListType) {
            return GraphQLTypeMapper.getNestedTypeName(((ListType)graphqlType).getType());
        }
        if (graphqlType instanceof NonNullType) {
            return GraphQLTypeMapper.getNestedTypeName(((NonNullType)graphqlType).getType());
        }
        return null;
    }

    public static String getMandatoryType(String typeName) {
        return typeName + "!";
    }

    public static List<Directive> getDirectives(NamedNode<?> def) {
        if (def instanceof DirectivesContainer) {
            return ((DirectivesContainer)def).getDirectives();
        }
        return Collections.emptyList();
    }

    public String wrapIntoList(MappingContext var1, String var2, boolean var3);

    public String wrapSuperTypeIntoList(MappingContext var1, String var2, boolean var3);

    public String wrapApiReturnTypeIfRequired(MappingContext var1, NamedDefinition var2, String var3);

    public boolean isPrimitive(String var1);

    public boolean addModelValidationAnnotationForType(String var1);

    default public String getGenericsString(MappingContext mappingContext, String genericType, String typeParameter) {
        if (genericType.contains("%s")) {
            return String.format(genericType, typeParameter);
        }
        return String.format("%s<%s>", genericType, typeParameter);
    }

    default public String getLanguageType(MappingContext mappingContext, Type<?> type) {
        return this.getLanguageType(mappingContext, type, null, null).getJavaName();
    }

    default public NamedDefinition getLanguageType(MappingContext mappingContext, Type<?> graphqlType, String name, String parentTypeName) {
        return this.getLanguageType(mappingContext, graphqlType, name, parentTypeName, false, false);
    }

    default public NamedDefinition getLanguageType(MappingContext mappingContext, Type<?> graphqlType, String name, String parentTypeName, boolean mandatory, boolean collection) {
        if (graphqlType instanceof TypeName) {
            return this.getLanguageType(mappingContext, ((TypeName)graphqlType).getName(), name, parentTypeName, mandatory, collection);
        }
        if (graphqlType instanceof ListType) {
            NamedDefinition mappedCollectionType = this.getLanguageType(mappingContext, ((ListType)graphqlType).getType(), name, parentTypeName, false, true);
            if (mappedCollectionType.isInterface() && mappingContext.getInterfacesName().contains(parentTypeName)) {
                mappedCollectionType.setJavaName(this.wrapSuperTypeIntoList(mappingContext, mappedCollectionType.getJavaName(), mandatory));
            } else {
                mappedCollectionType.setJavaName(this.wrapIntoList(mappingContext, mappedCollectionType.getJavaName(), mandatory));
            }
            return mappedCollectionType;
        }
        if (graphqlType instanceof NonNullType) {
            return this.getLanguageType(mappingContext, ((NonNullType)graphqlType).getType(), name, parentTypeName, true, collection);
        }
        throw new IllegalArgumentException("Unknown type: " + graphqlType);
    }

    default public NamedDefinition getLanguageType(MappingContext mappingContext, String graphQLType, String name, String parentTypeName, boolean mandatory, boolean collection) {
        String langTypeName;
        Map<String, String> customTypesMapping = mappingContext.getCustomTypesMapping();
        Set<String> serializeFieldsUsingObjectMapper = mappingContext.getUseObjectMapperForRequestSerialization();
        boolean primitiveCanBeUsed = !collection;
        boolean serializeUsingObjectMapper = false;
        if (name != null && parentTypeName != null && customTypesMapping.containsKey(parentTypeName + "." + name)) {
            langTypeName = customTypesMapping.get(parentTypeName + "." + name);
            primitiveCanBeUsed = false;
        } else {
            langTypeName = mandatory && customTypesMapping.containsKey(GraphQLTypeMapper.getMandatoryType(graphQLType)) ? customTypesMapping.get(GraphQLTypeMapper.getMandatoryType(graphQLType)) : (customTypesMapping.containsKey(graphQLType) ? customTypesMapping.get(graphQLType) : DataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, graphQLType));
        }
        if (serializeFieldsUsingObjectMapper.contains(graphQLType) || name != null && parentTypeName != null && serializeFieldsUsingObjectMapper.contains(parentTypeName + "." + name)) {
            serializeUsingObjectMapper = true;
        }
        return new NamedDefinition(langTypeName, graphQLType, mappingContext.getInterfacesName().contains(graphQLType), mandatory, primitiveCanBeUsed, serializeUsingObjectMapper);
    }

    default public List<String> getAnnotations(MappingContext mappingContext, Type<?> type, NamedNode<?> def, String parentTypeName, boolean mandatory) {
        if (type instanceof ListType) {
            return this.getAnnotations(mappingContext, ((ListType)type).getType(), def, parentTypeName, mandatory);
        }
        if (type instanceof NonNullType) {
            return this.getAnnotations(mappingContext, ((NonNullType)type).getType(), def, parentTypeName, true);
        }
        if (type instanceof TypeName) {
            return this.getAnnotations(mappingContext, ((TypeName)type).getName(), def.getName(), parentTypeName, GraphQLTypeMapper.getDirectives(def), mandatory);
        }
        return Collections.emptyList();
    }

    default public List<String> getAnnotations(MappingContext mappingContext, ExtendedDefinition<?, ?> extendedDefinition) {
        return this.getAnnotations(mappingContext, extendedDefinition.getName(), extendedDefinition.getName(), null, Collections.emptyList(), false);
    }

    default public List<String> getAnnotations(MappingContext mappingContext, String name) {
        return this.getAnnotations(mappingContext, name, name, null, Collections.emptyList(), false);
    }

    default public List<String> getAnnotations(MappingContext mappingContext, String graphQLTypeName, String name, String parentTypeName, List<Directive> directives, boolean mandatory) {
        List<String> annotationsToAdd;
        ArrayList<String> annotations = new ArrayList<String>();
        if (mandatory) {
            String possiblyPrimitiveType = mappingContext.getCustomTypesMapping().get(GraphQLTypeMapper.getMandatoryType(graphQLTypeName));
            String modelValidationAnnotation = mappingContext.getModelValidationAnnotation();
            if (Utils.isNotBlank(modelValidationAnnotation) && this.addModelValidationAnnotationForType(possiblyPrimitiveType)) {
                annotations.add(modelValidationAnnotation);
            }
        }
        Map<String, List<String>> customAnnotationsMapping = mappingContext.getCustomAnnotationsMapping();
        if (name != null && parentTypeName != null && customAnnotationsMapping.containsKey(parentTypeName + "." + name)) {
            annotationsToAdd = customAnnotationsMapping.get(parentTypeName + "." + name);
            if (!Utils.isEmpty(annotationsToAdd)) {
                annotations.addAll(annotationsToAdd);
            }
        } else if (customAnnotationsMapping.containsKey(graphQLTypeName) && !Utils.isEmpty(annotationsToAdd = customAnnotationsMapping.get(graphQLTypeName))) {
            annotations.addAll(annotationsToAdd);
        }
        Map<String, List<String>> directiveAnnotationsMapping = mappingContext.getDirectiveAnnotationsMapping();
        for (Directive directive : directives) {
            if (!directiveAnnotationsMapping.containsKey(directive.getName())) continue;
            annotations.addAll(this.getAnnotationsForDirective(mappingContext, directiveAnnotationsMapping.get(directive.getName()), directive));
        }
        return annotations;
    }

    default public List<String> getAnnotationsForDirective(MappingContext mappingContext, List<String> directiveAnnotations, Directive directive) {
        ArrayList<String> directiveAnnotationsMapped = new ArrayList<String>();
        Iterator<String> iterator = directiveAnnotations.iterator();
        while (iterator.hasNext()) {
            String annotation;
            String directiveAnnotationMapped = annotation = iterator.next();
            for (Argument dirArg : directive.getArguments()) {
                String argumentValueFormatter = Utils.substringBetween(annotation, "{{" + dirArg.getName(), "}}");
                if (argumentValueFormatter == null) continue;
                directiveAnnotationMapped = directiveAnnotationMapped.replace(String.format("{{%s%s}}", dirArg.getName(), argumentValueFormatter), this.getValueMapper().map(mappingContext, dirArg.getValue(), null, argumentValueFormatter));
            }
            directiveAnnotationsMapped.add(directiveAnnotationMapped);
        }
        return directiveAnnotationsMapped;
    }

    default public String getTypeConsideringPrimitive(MappingContext mappingContext, NamedDefinition namedDefinition, String computedTypeName) {
        String possiblyPrimitiveType;
        String graphqlTypeName = namedDefinition.getGraphqlTypeName();
        if (namedDefinition.isMandatory() && namedDefinition.isPrimitiveCanBeUsed() && this.isPrimitive(possiblyPrimitiveType = mappingContext.getCustomTypesMapping().get(GraphQLTypeMapper.getMandatoryType(graphqlTypeName)))) {
            return possiblyPrimitiveType;
        }
        return computedTypeName;
    }

    default public String getResponseReturnType(MappingContext mappingContext, NamedDefinition namedDefinition, String computedTypeName) {
        return computedTypeName;
    }

    default public DeprecatedDefinition getDeprecated(MappingContext mappingContext, DirectivesContainer<?> directivesContainer) {
        return directivesContainer.getDirectives().stream().filter(d -> d.getName().equalsIgnoreCase(Deprecated.class.getSimpleName())).findFirst().map(directive -> MultiLanguageDeprecated.getLanguageDeprecated(mappingContext.getGeneratedLanguage(), directive)).orElse(null);
    }

    public ValueMapper getValueMapper();
}

